/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.signal;

import org.tech.vineyard.linear.algebra.Vector;
import org.tech.vineyard.signal.ComplexNumber;
import org.tech.vineyard.signal.ComplexVector;

public class DiscreteFourierTransform {
    Vector v;
    ComplexVector V;

    public DiscreteFourierTransform(Vector v) {
        this.v = v;
        this.V = this.dft();
    }

    private ComplexVector dft() {
        ComplexVector dft = new ComplexVector(this.v.size());
        int n = this.v.size();
        for (int k = 0; k < n; ++k) {
            this.dftCoefficient(dft, k);
        }
        return dft;
    }

    private void dftCoefficient(ComplexVector dft, int k) {
        int n = this.v.size();
        int realSum = 0;
        int imageSum = 0;
        for (int m = 0; m < n; ++m) {
            double phase = -(Math.PI * 2 * (double)m * (double)k) / (double)n;
            realSum = (int)((double)realSum + this.v.v[m] * Math.cos(phase));
            imageSum = (int)((double)imageSum + this.v.v[m] * Math.sin(phase));
        }
        dft.real.v[k] = realSum;
        dft.image.v[k] = imageSum;
    }

    public Vector lowPassFilter(int harmonics, int predictions) {
        int n = this.v.size();
        Vector frequencies = this.frequencies(n, 1.0);
        Vector indexes = this.indexesAbsAscending(n);
        int m = n + predictions;
        Vector filtered = new Vector(m);
        Vector time = Vector.range(m);
        for (int i = 0; i <= Math.min(2 * harmonics, n - 1); ++i) {
            int index = (int)indexes.v[i];
            filtered = filtered.add(time.apply(this.harmonic(this.V.get(index), frequencies.v[index])));
        }
        return filtered;
    }

    private Vector.Transform harmonic(ComplexNumber harmonic, double frequency) {
        int n = this.v.size();
        double amplitude = harmonic.absolute() / (double)n;
        double phase = harmonic.angle();
        return t -> amplitude * Math.cos(Math.PI * 2 * frequency * t + phase);
    }

    private Vector indexesAbsAscending(int n) {
        double[] d = new double[n];
        d[0] = 0.0;
        int p = n / 2;
        if (n % 2 == 1) {
            ++p;
        }
        for (int i = 1; i < p; ++i) {
            d[2 * i - 1] = i;
            d[2 * i] = n - i;
        }
        if (n % 2 == 0) {
            d[n - 1] = p;
        }
        return new Vector(d);
    }

    private Vector frequencies(int n, double spacing) {
        int i;
        double[] d = new double[n];
        int p = n % 2 == 0 ? n / 2 - 1 : (n - 1) / 2;
        for (i = 0; i <= p; ++i) {
            d[i] = i;
        }
        for (i = p + 1; i < n; ++i) {
            d[i] = i - n;
        }
        return new Vector(d).divide(spacing * (double)n);
    }
}

