/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.sort;

import java.util.ArrayList;
import java.util.List;
import org.tech.vineyard.sort.Sort;

public class MergeSort<T extends Comparable<T>>
implements Sort<T> {
    private List<T> buffer;

    @Override
    public void sort(List<T> list) {
        this.buffer = new ArrayList<T>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.buffer.add(null);
        }
        this.mergeSort(list);
    }

    private void mergeSort(List<T> list) {
        for (int width = 1; width < list.size(); width <<= 1) {
            for (int start = 0; start < list.size(); start += width << 1) {
                int middle = start + width - 1;
                int end = Math.min(start + (width << 1) - 1, list.size() - 1);
                this.merge(list, start, middle, end);
            }
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Comparable)this.buffer.get(i));
            }
        }
    }

    private void merge(List<T> list, int start, int middle, int end) {
        int left = start;
        int right = middle + 1;
        int i = start;
        while (i <= end) {
            while (left <= middle && (right > end || ((Comparable)list.get(left)).compareTo((Comparable)list.get(right)) <= 0)) {
                this.buffer.set(i, (Comparable)list.get(left));
                ++left;
                ++i;
            }
            while (right <= end && (left > middle || ((Comparable)list.get(left)).compareTo((Comparable)list.get(right)) > 0)) {
                this.buffer.set(i, (Comparable)list.get(right));
                ++right;
                ++i;
            }
        }
    }
}

