/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.sort;

import java.util.List;
import org.tech.vineyard.sort.Sort;

public class QuickSort<T extends Comparable<T>>
implements Sort<T> {
    @Override
    public void sort(List<T> list) {
        this.quickSort(list, 0, list.size() - 1);
    }

    private void quickSort(List<T> list, int start, int end) {
        if (start >= end) {
            return;
        }
        int j = this.partition(list, start, end);
        this.quickSort(list, start, j - 1);
        this.quickSort(list, j + 1, end);
    }

    private int partition(List<T> list, int start, int end) {
        Comparable pivot = (Comparable)list.get(end);
        int j = start;
        for (int i = start; i < end; ++i) {
            if (((Comparable)list.get(i)).compareTo(pivot) >= 0) continue;
            this.swap(list, j, i);
            ++j;
        }
        this.swap(list, j, end);
        return j;
    }

    private void swap(List<T> list, int j, int i) {
        Comparable tmp = (Comparable)list.get(i);
        list.set(i, (Comparable)list.get(j));
        list.set(j, tmp);
    }
}

