/*
 * Decompiled with CFR 0.152.
 */
package org.tech.vineyard.string;

import java.util.LinkedList;
import java.util.List;

public class SuffixTree {
    char[] C;
    Node root;

    SuffixTree(String text) {
        this.C = text.toCharArray();
        this.buildn3();
    }

    private void buildUkkonen() {
        this.root = new Node(0, -1);
        for (int i = 0; i < this.C.length; ++i) {
            System.out.println(i);
            Node parent = this.root;
            Node previousInternalNode = null;
            block1: for (int j = 0; j <= i; ++j) {
                int edgeLabelLength;
                for (int k = j; k <= i; k += edgeLabelLength) {
                    Node child = parent.findChild(this.C[k]);
                    if (child == null) {
                        if (parent != this.root && parent.children.size() == 0) {
                            int length = 1 + parent.e - parent.s + 1;
                            parent.e = i;
                            parent.s = parent.e - length + 1;
                        } else {
                            child = new Node(i, i);
                            parent.addChild(child);
                        }
                        ++k;
                        parent = this.root;
                        continue block1;
                    }
                    edgeLabelLength = child.e - child.s + 1;
                    if (k + edgeLabelLength >= i) {
                        parent = child;
                        continue;
                    }
                    int l = child.s + i - k;
                    if (this.C[i] != this.C[l]) {
                        Node internalNode = child.splitLabel(l);
                        internalNode.suffix = previousInternalNode;
                        previousInternalNode = internalNode;
                        child.addChild(new Node(i, i));
                        if (parent != this.root) {
                            // empty if block
                        }
                    }
                    k = i + 1;
                    continue block1;
                }
            }
            this.print(this.root, 0);
        }
    }

    private void buildn3() {
        this.root = new Node(0, -1);
        for (int i = 0; i < this.C.length; ++i) {
            for (int j = 0; j <= i; ++j) {
                this.extend(j, i);
            }
        }
        this.print(this.root, 0);
    }

    private void extend(int j, int i) {
        int j0 = j;
        Node parent = this.root;
        int l = -1;
        for (Node node = parent.findChild(this.C[j]); node != null && j <= i; node = node.findChild(this.C[j])) {
            for (l = node.s; j <= i && l <= node.e && this.C[l] == this.C[j]; ++j, ++l) {
            }
            if (j == i + 1) {
                return;
            }
            if (l <= node.e) {
                System.out.println("Creating node " + l + " " + j0 + " " + i + " " + node.s + " " + node.e);
                node.splitLabel(l);
                node.addChild(new Node(i, i));
                return;
            }
            parent = node;
        }
        if (parent != this.root && parent.children.size() == 0) {
            int length = parent.e - parent.s + 1;
            parent.e = i;
            parent.s = parent.e - length;
        } else {
            parent.addChild(new Node(i, i));
        }
    }

    private void addSuffixes() {
        for (int i = 0; i < this.C.length; ++i) {
            this.addSuffix(i);
        }
    }

    private void addSuffix(int i) {
        Node node;
        int end = this.C.length - 1;
        Node parent = node = this.root;
        int j = -1;
        while (node != null && i <= end) {
            for (j = node.s; i <= end && j <= node.e && this.C[i] == this.C[j]; ++i, ++j) {
            }
            if (i == end + 1) {
                return;
            }
            if (node.s < j && j <= node.e) {
                node.splitLabel(j);
                break;
            }
            parent = node;
            node = node.findChild(this.C[i]);
        }
        node = new Node(i, end);
        parent.addChild(node);
    }

    public void print(Node node, int i) {
        for (int j = 0; j < i; ++j) {
            System.out.print(" ");
        }
        this.printNode(node);
        for (Node child : node.children) {
            this.print(child, i + node.e - node.s + 1);
        }
    }

    private void printNode(Node node) {
        System.out.println(new String(this.C, node.s, node.e - node.s + 1) + " " + node.s + " " + node.e);
    }

    public Integer match(String pattern) {
        int i = 0;
        int j = -1;
        for (Node node = this.root; node != null && i < pattern.length(); node = node.findChild(pattern.charAt(i))) {
            for (j = node.s; i < pattern.length() && j <= node.e && pattern.charAt(i) == this.C[j]; ++i, ++j) {
            }
            if (i == pattern.length()) {
                return j - pattern.length();
            }
            if (j >= node.e) continue;
            return null;
        }
        return null;
    }

    class Node {
        int s;
        int e;
        List<Node> children;
        Node parent;
        public Node suffix;

        Node(int s, int e) {
            this.s = s;
            this.e = e;
            this.children = new LinkedList<Node>();
        }

        public Node findChild(char c) {
            for (Node child : this.children) {
                if (c != SuffixTree.this.C[child.s]) continue;
                return child;
            }
            return null;
        }

        public void addChild(Node child) {
            this.children.add(child);
            child.parent = this;
        }

        public Node splitLabel(int j) {
            Node child = new Node(j, this.e);
            this.e = j - 1;
            List<Node> tmp = child.children;
            child.children = this.children;
            for (Node grandChild : child.children) {
                grandChild.parent = child;
            }
            this.children = tmp;
            this.addChild(child);
            return child;
        }

        public String toString() {
            return "(" + this.s + "," + this.e + ")";
        }
    }
}

