/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.animation.expressions;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.util.MathHelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0001\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001J\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001J\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001J\u0016\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tJ\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/alexzhirkevich/compottie/internal/animation/expressions/RandomSource;", "", "<init>", "()V", "randomInstance", "Lkotlin/random/Random;", "noiseMap", "", "", "", "setSeed", "", "seed", "timeless", "", "random", "maxValOrArray", "maxValOrArray1", "maxValOrArray2", "gaussRandom", "noise", "t", "getOrInitNoise", "x", "compottie_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRandomSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomSource.kt\nio/github/alexzhirkevich/compottie/internal/animation/expressions/RandomSource\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,133:1\n151#2,3:134\n33#2,4:137\n154#2,2:141\n38#2:143\n156#2:144\n*S KotlinDebug\n*F\n+ 1 RandomSource.kt\nio/github/alexzhirkevich/compottie/internal/animation/expressions/RandomSource\n*L\n34#1:134,3\n34#1:137,4\n34#1:141,2\n34#1:143\n34#1:144\n*E\n"})
public final class RandomSource {
    @NotNull
    private Random randomInstance = (Random)Random.Default;
    @NotNull
    private final Map<Integer, Float> noiseMap = new LinkedHashMap();
    public static final int $stable = 8;

    public final void setSeed(int seed, boolean timeless) {
        this.randomInstance = RandomKt.Random((int)seed);
        this.noiseMap.clear();
    }

    public final float random() {
        return this.randomInstance.nextFloat();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object random(@NotNull Object maxValOrArray) {
        Intrinsics.checkNotNullParameter((Object)maxValOrArray, (String)"maxValOrArray");
        Object object = maxValOrArray;
        if (!(object instanceof Number)) {
            if (object instanceof List) {
                List $this$fastMap$iv = (List)maxValOrArray;
                boolean $i$f$fastMap = false;
                ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
                List $this$fastForEach$iv$iv = $this$fastMap$iv;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv$iv.size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    void it;
                    Object item$iv$iv;
                    Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl = false;
                    Object e = it$iv;
                    Collection collection = target$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Number");
                    collection.add(Float.valueOf(((Number)it).floatValue() * this.randomInstance.nextFloat()));
                }
                return target$iv;
            }
            throw new IllegalStateException(("Can't use " + maxValOrArray + " as a random() parameter").toString());
        }
        return Float.valueOf(this.randomInstance.nextFloat() * ((Number)maxValOrArray).floatValue());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object random(@NotNull Object maxValOrArray1, @NotNull Object maxValOrArray2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)maxValOrArray1, (String)"maxValOrArray1");
        Intrinsics.checkNotNullParameter((Object)maxValOrArray2, (String)"maxValOrArray2");
        if (maxValOrArray1 instanceof Number && maxValOrArray2 instanceof Number) {
            object = Float.valueOf(this.randomInstance.nextFloat() * ((Number)maxValOrArray2).floatValue() + ((Number)maxValOrArray1).floatValue());
        } else if (maxValOrArray1 instanceof List && maxValOrArray2 instanceof List) {
            int n = Math.min(((List)maxValOrArray1).size(), ((List)maxValOrArray2).size());
            ArrayList<Float> arrayList = new ArrayList<Float>(n);
            int n2 = 0;
            while (n2 < n) {
                void it;
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Float> arrayList2 = arrayList;
                boolean bl = false;
                float f = this.randomInstance.nextFloat();
                Object e = ((List)maxValOrArray1).get((int)it);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Number");
                float f2 = f * ((Number)e).floatValue();
                Object e2 = ((List)maxValOrArray2).get((int)it);
                Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.Number");
                arrayList2.add(Float.valueOf(f2 + ((Number)e2).floatValue()));
            }
            object = arrayList;
        } else {
            throw new IllegalStateException(("Can't use " + maxValOrArray1 + " and " + maxValOrArray2 + " as a random() parameter").toString());
        }
        return object;
    }

    public final float gaussRandom() {
        float r = (float)Math.sqrt((float)-2 * (float)Math.log(this.random()));
        double alpha = Math.PI * 2 * (double)this.random();
        return r * (float)Math.cos(alpha) + 1.0f;
    }

    @NotNull
    public final Object gaussRandom(@NotNull Object maxValOrArray) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)maxValOrArray, (String)"maxValOrArray");
        Object object2 = maxValOrArray;
        if (object2 instanceof Number) {
            object = Float.valueOf(this.gaussRandom() * ((Number)maxValOrArray).floatValue());
        } else if (object2 instanceof List) {
            List list;
            List cfr_ignored_0 = (List)maxValOrArray;
            List $this$gaussRandom_u24lambda_u242 = list = CollectionsKt.createListBuilder((int)((List)maxValOrArray).size());
            boolean bl = false;
            while ($this$gaussRandom_u24lambda_u242.size() < ((List)maxValOrArray).size()) {
                float r = (float)Math.sqrt((float)-2 * (float)Math.log(this.randomInstance.nextFloat()));
                double alpha = Math.PI * 2 * (double)this.randomInstance.nextFloat();
                $this$gaussRandom_u24lambda_u242.add(Float.valueOf((r * (float)Math.cos(alpha) + 1.0f) * ((Number)((List)maxValOrArray).get($this$gaussRandom_u24lambda_u242.size())).floatValue()));
                $this$gaussRandom_u24lambda_u242.add(Float.valueOf(r * (float)Math.sin(alpha) + 1.0f * ((Number)((List)maxValOrArray).get($this$gaussRandom_u24lambda_u242.size())).floatValue()));
            }
            if ($this$gaussRandom_u24lambda_u242.size() > ((List)maxValOrArray).size()) {
                CollectionsKt.removeLast((List)$this$gaussRandom_u24lambda_u242);
            }
            object = CollectionsKt.build((List)list);
        } else {
            throw new IllegalStateException(("Can't use " + maxValOrArray + " as a random() parameter").toString());
        }
        return object;
    }

    @NotNull
    public final Object gaussRandom(@NotNull Object maxValOrArray1, @NotNull Object maxValOrArray2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)maxValOrArray1, (String)"maxValOrArray1");
        Intrinsics.checkNotNullParameter((Object)maxValOrArray2, (String)"maxValOrArray2");
        if (maxValOrArray1 instanceof Number && maxValOrArray2 instanceof Number) {
            object = Float.valueOf(this.gaussRandom() * ((Number)maxValOrArray2).floatValue() + ((Number)maxValOrArray1).floatValue());
        } else if (maxValOrArray1 instanceof List && maxValOrArray2 instanceof List) {
            List list;
            List cfr_ignored_0 = (List)maxValOrArray1;
            List cfr_ignored_1 = (List)maxValOrArray2;
            int cap = Math.min(((List)maxValOrArray1).size(), ((List)maxValOrArray2).size());
            List $this$gaussRandom_u24lambda_u243 = list = CollectionsKt.createListBuilder((int)cap);
            boolean bl = false;
            while ($this$gaussRandom_u24lambda_u243.size() < cap) {
                float r = (float)Math.sqrt((float)-2 * (float)Math.log(this.randomInstance.nextFloat()));
                double alpha = Math.PI * 2 * (double)this.randomInstance.nextFloat();
                $this$gaussRandom_u24lambda_u243.add(Float.valueOf((r * (float)Math.cos(alpha) + 1.0f) * ((Number)((List)maxValOrArray1).get($this$gaussRandom_u24lambda_u243.size())).floatValue() + ((Number)((List)maxValOrArray2).get($this$gaussRandom_u24lambda_u243.size())).floatValue()));
                $this$gaussRandom_u24lambda_u243.add(Float.valueOf((r * (float)Math.sin(alpha) + 1.0f) * ((Number)((List)maxValOrArray1).get($this$gaussRandom_u24lambda_u243.size())).floatValue() + ((Number)((List)maxValOrArray2).get($this$gaussRandom_u24lambda_u243.size())).floatValue()));
            }
            if ($this$gaussRandom_u24lambda_u243.size() > cap) {
                CollectionsKt.removeLast((List)$this$gaussRandom_u24lambda_u243);
            }
            object = CollectionsKt.build((List)list);
        } else {
            throw new IllegalStateException(("Can't use " + maxValOrArray1 + " and " + maxValOrArray2 + " as a random() parameter").toString());
        }
        return object;
    }

    public final float noise(float t) {
        int prevX = (int)t;
        int nextX = prevX + 1;
        float fracX = t - (float)prevX;
        float y0 = this.getOrInitNoise(prevX);
        float y1 = this.getOrInitNoise(nextX);
        return MathHelpersKt.lerp((float)y0, (float)y1, (float)fracX);
    }

    private final float getOrInitNoise(int x) {
        float f;
        Float f2 = this.noiseMap.get(x);
        if (f2 != null) {
            f = f2.floatValue();
        } else {
            float f3;
            float it = f3 = this.randomInstance.nextFloat() * (float)2 - 1.0f;
            boolean bl = false;
            Integer n = x;
            Float f4 = Float.valueOf(it);
            this.noiseMap.put(n, f4);
            f = f3;
        }
        return f;
    }
}

