/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.helpers;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.graphics.Path;
import io.github.alexzhirkevich.compottie.internal.helpers.Bezier$;
import io.github.alexzhirkevich.compottie.internal.helpers.BezierKt;
import io.github.alexzhirkevich.compottie.internal.helpers.CubicCurveData;
import io.github.alexzhirkevich.compottie.internal.utils.MiscUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Transient;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.FloatSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 >2\u00020\u0001:\u0002=>BS\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u00a2\u0006\u0004\b\t\u0010\nBe\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005\u0012\u0014\u0010\b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\t\u0010\u000fJ\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0003J\u001e\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0006J\u000e\u00102\u001a\u00020,2\u0006\u00103\u001a\u000204J\b\u00105\u001a\u00020,H\u0002J%\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0001\u00a2\u0006\u0002\b<R$\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0002\u0010\u0012\"\u0004\b\u0013\u0010\u0014R0\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0011\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R0\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001a\u0010\u0011\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R(\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0011\u001a\u0004\b\u001e\u0010\u0017R2\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b#\u0010\u0011\u001a\u0004\b$\u0010\u0017R(\u0010&\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020%8\u0006@BX\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010*\u0012\u0004\b'\u0010\u0011\u001a\u0004\b(\u0010)\u00a8\u0006?"}, d2={"Lio/github/alexzhirkevich/compottie/internal/helpers/Bezier;", "", "isClosed", "", "inTangents", "", "", "outTangents", "vertices", "<init>", "(ZLjava/util/List;Ljava/util/List;Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IZLjava/util/List;Ljava/util/List;Ljava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "isClosed$annotations", "()V", "()Z", "setClosed", "(Z)V", "getInTangents$annotations", "getInTangents", "()Ljava/util/List;", "setInTangents", "(Ljava/util/List;)V", "getOutTangents$annotations", "getOutTangents", "setOutTangents", "getVertices$annotations", "getVertices", "value", "", "Lio/github/alexzhirkevich/compottie/internal/helpers/CubicCurveData;", "curves", "getCurves$annotations", "getCurves", "Landroidx/compose/ui/geometry/Offset;", "initialPoint", "getInitialPoint-F1C5BW0$annotations", "getInitialPoint-F1C5BW0", "()J", "J", "setIsClosed", "", "closed", "interpolateBetween", "a", "b", "percentage", "mapPath", "outPath", "Landroidx/compose/ui/graphics/Path;", "closeShape", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$compottie_release", "$serializer", "Companion", "compottie_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bezier.kt\nio/github/alexzhirkevich/compottie/internal/helpers/Bezier\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,170:1\n69#2,6:171\n33#2,6:177\n*S KotlinDebug\n*F\n+ 1 Bezier.kt\nio/github/alexzhirkevich/compottie/internal/helpers/Bezier\n*L\n105#1:171,6\n121#1:177,6\n*E\n"})
public final class Bezier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isClosed;
    @NotNull
    private List<? extends List<Float>> inTangents;
    @NotNull
    private List<? extends List<Float>> outTangents;
    @NotNull
    private final List<List<Float>> vertices;
    @NotNull
    private List<CubicCurveData> curves;
    private long initialPoint;
    public static final int $stable = 8;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public Bezier(boolean isClosed, @NotNull List<? extends List<Float>> inTangents, @NotNull List<? extends List<Float>> outTangents, @NotNull List<? extends List<Float>> vertices) {
        Intrinsics.checkNotNullParameter(inTangents, (String)"inTangents");
        Intrinsics.checkNotNullParameter(outTangents, (String)"outTangents");
        Intrinsics.checkNotNullParameter(vertices, (String)"vertices");
        this.isClosed = isClosed;
        this.inTangents = inTangents;
        this.outTangents = outTangents;
        this.vertices = vertices;
        this.curves = new ArrayList(this.vertices.size());
        this.initialPoint = Offset.Companion.getZero-F1C5BW0();
        if (!((Collection)this.vertices).isEmpty()) {
            this.initialPoint = MiscUtilKt.toOffset((List)CollectionsKt.first(this.vertices));
            int i = 1;
            int n = CollectionsKt.getLastIndex(this.vertices);
            if (i <= n) {
                while (true) {
                    List list;
                    List cp1;
                    List<Float> prevVertex = this.vertices.get(i - 1);
                    List list2 = (List)CollectionsKt.getOrNull(this.outTangents, (int)(i - 1));
                    if (list2 == null) {
                        list2 = cp1 = BezierKt.access$getEmptyTangent$p();
                    }
                    if ((list = (List)CollectionsKt.getOrNull(this.inTangents, (int)i)) == null) {
                        list = BezierKt.access$getEmptyTangent$p();
                    }
                    List cp2 = list;
                    List<Float> vertex = this.vertices.get(i);
                    long shapeCp1 = OffsetKt.Offset((float)(((Number)prevVertex.get(0)).floatValue() + ((Number)cp1.get(0)).floatValue()), (float)(((Number)prevVertex.get(1)).floatValue() + ((Number)cp1.get(1)).floatValue()));
                    long shapeCp2 = OffsetKt.Offset((float)(((Number)vertex.get(0)).floatValue() + ((Number)cp2.get(0)).floatValue()), (float)(((Number)vertex.get(1)).floatValue() + ((Number)cp2.get(1)).floatValue()));
                    this.curves.add(new CubicCurveData(shapeCp1, shapeCp2, MiscUtilKt.toOffset(vertex), null));
                    if (i == n) break;
                    ++i;
                }
            }
            if (this.isClosed) {
                this.closeShape();
            }
        }
    }

    public /* synthetic */ Bezier(boolean bl, List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        this(bl, list, list2, list3);
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    @SerialName(value="c")
    public static /* synthetic */ void isClosed$annotations() {
    }

    @NotNull
    public final List<List<Float>> getInTangents() {
        return this.inTangents;
    }

    public final void setInTangents(@NotNull List<? extends List<Float>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.inTangents = list;
    }

    @SerialName(value="i")
    public static /* synthetic */ void getInTangents$annotations() {
    }

    @NotNull
    public final List<List<Float>> getOutTangents() {
        return this.outTangents;
    }

    public final void setOutTangents(@NotNull List<? extends List<Float>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.outTangents = list;
    }

    @SerialName(value="o")
    public static /* synthetic */ void getOutTangents$annotations() {
    }

    @NotNull
    public final List<List<Float>> getVertices() {
        return this.vertices;
    }

    @SerialName(value="v")
    public static /* synthetic */ void getVertices$annotations() {
    }

    @NotNull
    public final List<CubicCurveData> getCurves() {
        return this.curves;
    }

    @Transient
    public static /* synthetic */ void getCurves$annotations() {
    }

    public final long getInitialPoint-F1C5BW0() {
        return this.initialPoint;
    }

    @Transient
    public static /* synthetic */ void getInitialPoint-F1C5BW0$annotations() {
    }

    public final void setIsClosed(boolean closed) {
        if (this.isClosed == closed) {
            return;
        }
        this.isClosed = closed;
        if (closed) {
            this.closeShape();
        } else {
            CollectionsKt.removeLast(this.curves);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void interpolateBetween(@NotNull Bezier a, @NotNull Bezier b, float percentage) {
        int it;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.isClosed = a.isClosed || b.isClosed;
        int points = Math.min(a.curves.size(), b.curves.size());
        if (this.curves.size() < points) {
            n2 = points - this.curves.size();
            n = 0;
            while (n < n2) {
                it = n++;
                boolean bl = false;
                this.curves.add(new CubicCurveData(0L, 0L, 0L, 7, null));
            }
        }
        if (this.curves.size() > points) {
            n2 = this.curves.size() - points;
            n = 0;
            while (n < n2) {
                it = n++;
                boolean bl = false;
                CollectionsKt.removeLast(this.curves);
            }
        }
        this.initialPoint = OffsetKt.lerp-Wko1d7g((long)a.initialPoint, (long)b.initialPoint, (float)percentage);
        List<CubicCurveData> $this$fastForEachIndexed$iv = this.curves;
        boolean $i$f$fastForEachIndexed = false;
        int index$iv = 0;
        int n3 = $this$fastForEachIndexed$iv.size();
        while (index$iv < n3) {
            void curve;
            CubicCurveData item$iv;
            CubicCurveData cubicCurveData = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int i = index$iv++;
            boolean bl = false;
            CubicCurveData curve1 = a.curves.get(i);
            CubicCurveData curve2 = b.curves.get(i);
            curve.setControlPoint1-k-4lQ0M(OffsetKt.lerp-Wko1d7g((long)curve1.getControlPoint1-F1C5BW0(), (long)curve2.getControlPoint1-F1C5BW0(), (float)percentage));
            curve.setControlPoint2-k-4lQ0M(OffsetKt.lerp-Wko1d7g((long)curve1.getControlPoint2-F1C5BW0(), (long)curve2.getControlPoint2-F1C5BW0(), (float)percentage));
            curve.setVertex-k-4lQ0M(OffsetKt.lerp-Wko1d7g((long)curve1.getVertex-F1C5BW0(), (long)curve2.getVertex-F1C5BW0(), (float)percentage));
        }
    }

    public final void mapPath(@NotNull Path outPath) {
        Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
        outPath.rewind();
        outPath.moveTo(Offset.getX-impl((long)this.initialPoint), Offset.getY-impl((long)this.initialPoint));
        long pathFromDataCurrentPoint = 0L;
        pathFromDataCurrentPoint = this.initialPoint;
        List<CubicCurveData> $this$fastForEach$iv = this.curves;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            CubicCurveData item$iv;
            CubicCurveData curve = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (Offset.equals-impl0((long)curve.getControlPoint1-F1C5BW0(), (long)pathFromDataCurrentPoint) && Offset.equals-impl0((long)curve.getControlPoint2-F1C5BW0(), (long)curve.getVertex-F1C5BW0())) {
                outPath.lineTo(Offset.getX-impl((long)curve.getVertex-F1C5BW0()), Offset.getY-impl((long)curve.getVertex-F1C5BW0()));
            } else {
                outPath.cubicTo(Offset.getX-impl((long)curve.getControlPoint1-F1C5BW0()), Offset.getY-impl((long)curve.getControlPoint1-F1C5BW0()), Offset.getX-impl((long)curve.getControlPoint2-F1C5BW0()), Offset.getY-impl((long)curve.getControlPoint2-F1C5BW0()), Offset.getX-impl((long)curve.getVertex-F1C5BW0()), Offset.getY-impl((long)curve.getVertex-F1C5BW0()));
            }
            pathFromDataCurrentPoint = curve.getVertex-F1C5BW0();
        }
        if (this.isClosed) {
            outPath.close();
        }
    }

    private final void closeShape() {
        List list;
        List cp1;
        List<Float> vertex = this.vertices.get(0);
        List prevVertex = (List)CollectionsKt.last(this.vertices);
        List list2 = (List)CollectionsKt.getOrNull(this.outTangents, (int)CollectionsKt.getLastIndex(this.vertices));
        if (list2 == null) {
            list2 = cp1 = BezierKt.access$getEmptyTangent$p();
        }
        if ((list = (List)CollectionsKt.getOrNull(this.inTangents, (int)0)) == null) {
            list = BezierKt.access$getEmptyTangent$p();
        }
        List cp2 = list;
        long shapeCp1 = OffsetKt.Offset((float)(((Number)prevVertex.get(0)).floatValue() + ((Number)cp1.get(0)).floatValue()), (float)(((Number)prevVertex.get(1)).floatValue() + ((Number)cp1.get(1)).floatValue()));
        long shapeCp2 = OffsetKt.Offset((float)(((Number)vertex.get(0)).floatValue() + ((Number)cp2.get(0)).floatValue()), (float)(((Number)vertex.get(1)).floatValue() + ((Number)cp2.get(1)).floatValue()));
        this.curves.add(new CubicCurveData(shapeCp1, shapeCp2, MiscUtilKt.toOffset(vertex), null));
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$compottie_release(Bezier self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.isClosed) {
            output.encodeBooleanElement(serialDesc, 0, self.isClosed);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : !Intrinsics.areEqual(self.inTangents, (Object)CollectionsKt.emptyList())) {
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], self.inTangents);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : !Intrinsics.areEqual(self.outTangents, (Object)CollectionsKt.emptyList())) {
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)kSerializerArray[2], self.outTangents);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : !Intrinsics.areEqual(self.vertices, (Object)CollectionsKt.emptyList())) {
            output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)kSerializerArray[3], self.vertices);
        }
    }

    public /* synthetic */ Bezier(int seen0, boolean isClosed, List inTangents, List outTangents, List vertices, SerializationConstructorMarker serializationConstructorMarker) {
        if ((0 & seen0) != 0) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.isClosed = (seen0 & 1) == 0 ? false : isClosed;
        this.inTangents = (seen0 & 2) == 0 ? CollectionsKt.emptyList() : inTangents;
        this.outTangents = (seen0 & 4) == 0 ? CollectionsKt.emptyList() : outTangents;
        this.vertices = (seen0 & 8) == 0 ? CollectionsKt.emptyList() : vertices;
        this.curves = new ArrayList(this.vertices.size());
        this.initialPoint = Offset.Companion.getZero-F1C5BW0();
        if (!((Collection)this.vertices).isEmpty()) {
            this.initialPoint = MiscUtilKt.toOffset((List)CollectionsKt.first(this.vertices));
            int i = 1;
            int n = CollectionsKt.getLastIndex(this.vertices);
            if (i <= n) {
                while (true) {
                    List list;
                    List cp1;
                    List<Float> prevVertex = this.vertices.get(i - 1);
                    List list2 = (List)CollectionsKt.getOrNull(this.outTangents, (int)(i - 1));
                    if (list2 == null) {
                        list2 = cp1 = BezierKt.access$getEmptyTangent$p();
                    }
                    if ((list = (List)CollectionsKt.getOrNull(this.inTangents, (int)i)) == null) {
                        list = BezierKt.access$getEmptyTangent$p();
                    }
                    List cp2 = list;
                    List<Float> vertex = this.vertices.get(i);
                    long shapeCp1 = OffsetKt.Offset((float)(((Number)prevVertex.get(0)).floatValue() + ((Number)cp1.get(0)).floatValue()), (float)(((Number)prevVertex.get(1)).floatValue() + ((Number)cp1.get(1)).floatValue()));
                    long shapeCp2 = OffsetKt.Offset((float)(((Number)vertex.get(0)).floatValue() + ((Number)cp2.get(0)).floatValue()), (float)(((Number)vertex.get(1)).floatValue() + ((Number)cp2.get(1)).floatValue()));
                    this.curves.add(new CubicCurveData(shapeCp1, shapeCp2, MiscUtilKt.toOffset(vertex), null));
                    if (i == n) break;
                    ++i;
                }
            }
            if (this.isClosed) {
                this.closeShape();
            }
        }
    }

    public Bezier() {
        this(false, null, null, null, 15, null);
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{null, new ArrayListSerializer((KSerializer)new ArrayListSerializer((KSerializer)FloatSerializer.INSTANCE)), new ArrayListSerializer((KSerializer)new ArrayListSerializer((KSerializer)FloatSerializer.INSTANCE)), new ArrayListSerializer((KSerializer)new ArrayListSerializer((KSerializer)FloatSerializer.INSTANCE))};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lio/github/alexzhirkevich/compottie/internal/helpers/Bezier$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lio/github/alexzhirkevich/compottie/internal/helpers/Bezier;", "compottie_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Bezier> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

