/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.helpers;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.util.MathHelpersKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0014\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003J\u001c\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\u0003J\u001e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/github/alexzhirkevich/compottie/internal/helpers/ColorsWithStops;", "", "size", "", "<init>", "(I)V", "colorStops", "", "", "getColorStops", "()Ljava/util/List;", "colors", "Landroidx/compose/ui/graphics/Color;", "getColors", "mColorStops", "", "mColors", "fill", "", "", "numberOfColors", "interpolateBetween", "a", "b", "progress", "resizeTo", "compottie_release"})
@StabilityInferred(parameters=0)
public final class ColorsWithStops {
    @NotNull
    private final List<Float> mColorStops;
    @NotNull
    private final List<Color> mColors;
    public static final int $stable = 8;

    public ColorsWithStops(int size) {
        this.mColorStops = new ArrayList(size);
        this.mColors = new ArrayList(size);
    }

    @NotNull
    public final List<Float> getColorStops() {
        return this.mColorStops;
    }

    @NotNull
    public final List<Color> getColors() {
        return this.mColors;
    }

    public final void fill(@NotNull float[] colors, int numberOfColors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.resizeTo(numberOfColors);
        for (int i = 0; i < numberOfColors; ++i) {
            int it = i;
            boolean bl = false;
            this.mColorStops.set(it, Float.valueOf(colors[it * 4]));
            float alpha = colors.length == numberOfColors * 6 ? colors[ArraysKt.getLastIndex((float[])colors) - numberOfColors * 2 + (it + 1) * 2] : 1.0f;
            this.mColors.set(it, Color.box-impl((long)ColorKt.Color$default((float)colors[it * 4 + 1], (float)colors[it * 4 + 2], (float)colors[it * 4 + 3], (float)alpha, null, (int)16, null)));
        }
    }

    public final void fill(@NotNull List<Float> colors, int numberOfColors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.resizeTo(numberOfColors);
        for (int i = 0; i < numberOfColors; ++i) {
            int it = i;
            boolean bl = false;
            this.mColorStops.set(it, colors.get(it * 4));
            float alpha = colors.size() == numberOfColors * 6 ? ((Number)colors.get(CollectionsKt.getLastIndex(colors) - numberOfColors * 2 + (it + 1) * 2)).floatValue() : 1.0f;
            this.mColors.set(it, Color.box-impl((long)ColorKt.Color$default((float)((Number)colors.get(it * 4 + 1)).floatValue(), (float)((Number)colors.get(it * 4 + 2)).floatValue(), (float)((Number)colors.get(it * 4 + 3)).floatValue(), (float)alpha, null, (int)16, null)));
        }
    }

    public final void interpolateBetween(@NotNull ColorsWithStops a, @NotNull ColorsWithStops b, float progress2) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int n = Math.min(a.getColors().size(), b.getColors().size());
        this.resizeTo(n);
        int n2 = 0;
        while (n2 < n) {
            int i = n2++;
            boolean bl = false;
            this.mColors.set(i, Color.box-impl((long)ColorKt.lerp-jxsXWHM((long)a.getColors().get(i).unbox-impl(), (long)b.getColors().get(i).unbox-impl(), (float)progress2)));
            this.mColorStops.set(i, Float.valueOf(MathHelpersKt.lerp((float)((Number)a.getColorStops().get(i)).floatValue(), (float)((Number)b.getColorStops().get(i)).floatValue(), (float)progress2)));
        }
    }

    private final void resizeTo(int size) {
        while (this.getColorStops().size() < size) {
            this.mColorStops.add(Float.valueOf(0.0f));
            this.mColors.add(Color.box-impl((long)Color.Companion.getTransparent-0d7_KjU()));
        }
        while (this.getColorStops().size() > size) {
            CollectionsKt.removeLast(this.mColorStops);
            CollectionsKt.removeLast(this.mColors);
        }
    }
}

