/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.effects;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Paint;
import io.github.alexzhirkevich.compottie.internal.AnimationState;
import io.github.alexzhirkevich.compottie.internal.effects.BlurEffect;
import io.github.alexzhirkevich.compottie.internal.effects.DropShadowEffect;
import io.github.alexzhirkevich.compottie.internal.effects.FillEffect;
import io.github.alexzhirkevich.compottie.internal.effects.LayerEffect;
import io.github.alexzhirkevich.compottie.internal.effects.LayerEffectsApplierKt;
import io.github.alexzhirkevich.compottie.internal.effects.LayerEffectsState;
import io.github.alexzhirkevich.compottie.internal.effects.TintEffect;
import io.github.alexzhirkevich.compottie.internal.layers.BaseLayer;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/github/alexzhirkevich/compottie/internal/effects/LayerEffectsApplier;", "", "layer", "Lio/github/alexzhirkevich/compottie/internal/layers/BaseLayer;", "<init>", "(Lio/github/alexzhirkevich/compottie/internal/layers/BaseLayer;)V", "applyTo", "", "paint", "Landroidx/compose/ui/graphics/Paint;", "animationState", "Lio/github/alexzhirkevich/compottie/internal/AnimationState;", "effectState", "Lio/github/alexzhirkevich/compottie/internal/effects/LayerEffectsState;", "compottie"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLayerEffectsApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerEffectsApplier.kt\nio/github/alexzhirkevich/compottie/internal/effects/LayerEffectsApplier\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,163:1\n51#2,6:164\n*S KotlinDebug\n*F\n+ 1 LayerEffectsApplier.kt\nio/github/alexzhirkevich/compottie/internal/effects/LayerEffectsApplier\n*L\n29#1:164,6\n*E\n"})
public final class LayerEffectsApplier {
    @NotNull
    private final BaseLayer layer;
    public static final int $stable = 8;

    public LayerEffectsApplier(@NotNull BaseLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.layer = layer;
    }

    public final void applyTo(@NotNull Paint paint, @NotNull AnimationState animationState, @NotNull LayerEffectsState effectState) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)animationState, (String)"animationState");
        Intrinsics.checkNotNullParameter((Object)effectState, (String)"effectState");
        List<LayerEffect> $this$fastForEachReversed$iv = this.layer.getEffects();
        boolean $i$f$fastForEachReversed = false;
        int n = $this$fastForEachReversed$iv.size() + -1;
        if (0 <= n) {
            do {
                LayerEffect item$iv;
                int index$iv = n--;
                LayerEffect it = item$iv = $this$fastForEachReversed$iv.get(index$iv);
                boolean bl = false;
                LayerEffect layerEffect = it;
                if (layerEffect instanceof BlurEffect) {
                    LayerEffectsApplierKt.access$applyBlurEffect(paint, (BlurEffect)it, animationState, effectState);
                    continue;
                }
                if (layerEffect instanceof FillEffect) {
                    LayerEffectsApplierKt.access$applyFillEffect(paint, (FillEffect)it, animationState, effectState);
                    continue;
                }
                if (layerEffect instanceof TintEffect) {
                    LayerEffectsApplierKt.access$applyTintEffect(paint, (TintEffect)it, animationState, effectState);
                    continue;
                }
                if (layerEffect instanceof DropShadowEffect || layerEffect instanceof LayerEffect.UnsupportedEffect) continue;
                throw new NoWhenBranchMatchedException();
            } while (0 <= n);
        }
        effectState.setLastPaint(paint);
    }
}

