/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.animation;

import androidx.compose.animation.core.Easing;
import kotlin.Metadata;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/alexzhirkevich/compottie/internal/animation/PreciseCubicBezier;", "Landroidx/compose/animation/core/Easing;", "a", "", "b", "c", "d", "<init>", "(FFFF)V", "isLinear", "", "evaluateCubic", "m", "transform", "fraction", "compottie"})
final class PreciseCubicBezier
implements Easing {
    private final float a;
    private final float b;
    private final float c;
    private final float d;
    private final boolean isLinear;

    public PreciseCubicBezier(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.isLinear = Math.abs(this.a - this.b) < 1.0E-4f && Math.abs(this.c - this.d) < 1.0E-4f;
    }

    private final float evaluateCubic(float a, float b, float m) {
        return (float)3 * a * (1.0f - m) * (1.0f - m) * m + (float)3 * b * (1.0f - m) * m * m + m * m * m;
    }

    public float transform(float fraction) {
        if (this.isLinear) {
            return fraction;
        }
        if (fraction > 0.0f && fraction < 1.0f) {
            float start = 0.0f;
            float end = 1.0f;
            while (true) {
                float midpoint;
                float estimate;
                if (Math.abs(fraction - (estimate = this.evaluateCubic(this.a, this.c, midpoint = (start + end) / (float)2))) < 1.0E-4f) {
                    return this.evaluateCubic(this.b, this.d, midpoint);
                }
                if (estimate < fraction) {
                    start = midpoint;
                    continue;
                }
                end = midpoint;
            }
        }
        return fraction;
    }
}

