/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.helpers;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.util.MathHelpersKt;
import io.github.alexzhirkevich.compottie.internal.helpers.ColorsWithStopsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0013\u001a\u00020\u0003J\u001e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\bJ\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001b\u001a\u00020\u0003H\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/alexzhirkevich/compottie/internal/helpers/ColorsWithStops;", "", "size", "", "<init>", "(I)V", "colorStops", "", "", "getColorStops", "()Ljava/util/List;", "colors", "Landroidx/compose/ui/graphics/Color;", "getColors", "mColorStops", "", "mColors", "fill", "", "numberOfColors", "interpolateBetween", "a", "b", "progress", "resizeTo", "addOpacityStopsToGradientIfNeeded", "array", "colorPoints", "compottie"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nColorsWithStops.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorsWithStops.kt\nio/github/alexzhirkevich/compottie/internal/helpers/ColorsWithStops\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1#2:237\n*E\n"})
public final class ColorsWithStops {
    @NotNull
    private final List<Float> mColorStops;
    @NotNull
    private final List<Color> mColors;
    public static final int $stable = 8;

    public ColorsWithStops(int size) {
        this.mColorStops = new ArrayList(size);
        this.mColors = new ArrayList(size);
    }

    @NotNull
    public final List<Float> getColorStops() {
        return this.mColorStops;
    }

    @NotNull
    public final List<Color> getColors() {
        return this.mColors;
    }

    public final void fill(@NotNull List<Float> colors, int numberOfColors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.resizeTo(numberOfColors);
        int n = 0;
        while (n < numberOfColors) {
            int it = n++;
            boolean bl = false;
            this.mColorStops.set(it, colors.get(it * 4));
            this.mColors.set(it, Color.box-impl((long)ColorKt.Color$default((float)((Number)colors.get(it * 4 + 1)).floatValue(), (float)((Number)colors.get(it * 4 + 2)).floatValue(), (float)((Number)colors.get(it * 4 + 3)).floatValue(), (float)0.0f, null, (int)24, null)));
        }
        this.addOpacityStopsToGradientIfNeeded(colors, numberOfColors);
    }

    public final void interpolateBetween(@NotNull ColorsWithStops a, @NotNull ColorsWithStops b, float progress2) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int n = Math.min(a.getColors().size(), b.getColors().size());
        this.resizeTo(n);
        int n2 = 0;
        while (n2 < n) {
            int i = n2++;
            boolean bl = false;
            this.mColors.set(i, Color.box-impl((long)ColorKt.lerp-jxsXWHM((long)a.getColors().get(i).unbox-impl(), (long)b.getColors().get(i).unbox-impl(), (float)progress2)));
            this.mColorStops.set(i, Float.valueOf(MathHelpersKt.lerp((float)((Number)a.getColorStops().get(i)).floatValue(), (float)((Number)b.getColorStops().get(i)).floatValue(), (float)progress2)));
        }
    }

    private final void resizeTo(int size) {
        while (this.getColorStops().size() < size) {
            this.mColorStops.add(Float.valueOf(0.0f));
            this.mColors.add(Color.box-impl((long)Color.Companion.getTransparent-0d7_KjU()));
        }
        while (this.getColorStops().size() > size) {
            CollectionsKt.removeLast(this.mColorStops);
            CollectionsKt.removeLast(this.mColors);
        }
    }

    private final void addOpacityStopsToGradientIfNeeded(List<Float> array, int colorPoints) {
        int n;
        ArrayList<Float> arrayList;
        int n2;
        int startIndex = colorPoints * 4;
        if (array.size() <= startIndex) {
            return;
        }
        int opacityStops = (array.size() - startIndex) / 2;
        ArrayList<Float> arrayList2 = new ArrayList<Float>(opacityStops);
        int n3 = 0;
        while (n3 < opacityStops) {
            int n4 = n2 = n3++;
            arrayList = arrayList2;
            n = 0;
            arrayList.add(Float.valueOf(0.0f));
        }
        List opacityStopPositions = arrayList2;
        ArrayList arrayList3 = new ArrayList(opacityStops);
        n2 = 0;
        while (n2 < opacityStops) {
            int it;
            n = it = n2++;
            arrayList = arrayList3;
            boolean bl = false;
            arrayList.add(Float.valueOf(0.0f));
        }
        List opacityStopOpacities = arrayList3;
        ColorsWithStops $this$addOpacityStopsToGradientIfNeeded_u24lambda_u244 = this;
        boolean bl = false;
        int j = 0;
        for (int i = startIndex; i < array.size(); ++i) {
            if (i % 2 == 0) {
                opacityStopPositions.set(j, array.get(i));
                continue;
            }
            opacityStopOpacities.set(j, array.get(i));
            ++j;
        }
        List newPositions = ColorsWithStopsKt.access$mergeUniqueElements(this.mColorStops, opacityStopPositions);
        int newColorPoints = newPositions.size();
        ArrayList i = new ArrayList(newColorPoints);
        j = 0;
        while (j < newColorPoints) {
            int n5;
            int n6 = n5 = j++;
            arrayList = i;
            boolean bl2 = false;
            arrayList.add((Float)Color.box-impl((long)Color.Companion.getTransparent-0d7_KjU()));
        }
        List newColors = i;
        for (int i2 = 0; i2 < newColorPoints; ++i2) {
            float position = ((Number)newPositions.get(i2)).floatValue();
            int colorStopIndex = CollectionsKt.binarySearch$default(this.mColorStops, (Comparable)Float.valueOf(position), (int)0, (int)0, (int)6, null);
            int opacityIndex = CollectionsKt.binarySearch$default((List)opacityStopPositions, (Comparable)Float.valueOf(position), (int)0, (int)0, (int)6, null);
            if (colorStopIndex < 0 || opacityIndex > 0) {
                if (opacityIndex < 0) {
                    opacityIndex = -(opacityIndex + 1);
                }
                newColors.set(i2, Color.box-impl((long)ColorsWithStopsKt.access$getColorInBetweenColorStops(position, ((Number)opacityStopOpacities.get(opacityIndex)).floatValue(), this.mColorStops, this.mColors)));
                continue;
            }
            newColors.set(i2, Color.box-impl((long)ColorsWithStopsKt.access$getColorInBetweenOpacityStops-RPmYEkk(position, this.mColors.get(colorStopIndex).unbox-impl(), opacityStopPositions, opacityStopOpacities)));
        }
        this.resizeTo(newColors.size());
        int n7 = newColors.size();
        int n8 = 0;
        while (n8 < n7) {
            int it = n8++;
            boolean bl3 = false;
            this.mColors.set(it, (Color)newColors.get(it));
            this.mColorStops.set(it, (Float)newPositions.get(it));
        }
    }
}

