/*
 * Decompiled with CFR 0.152.
 */
package io.github.aliasbretaud.mojibox.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.aliasbretaud.mojibox.enums.MeaningLanguage;
import io.github.aliasbretaud.mojibox.enums.ReadingType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KanjiEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String literal;
    private Misc misc;
    @JsonDeserialize(as=HashMap.class)
    private Map<ReadingType, List<String>> readings;
    @JsonDeserialize(as=HashMap.class)
    private Map<MeaningLanguage, List<String>> meanings;
    private List<String> nanori;

    public List<String> getReading(ReadingType type) {
        return this.readings.get((Object)type);
    }

    public List<String> getMeaning(MeaningLanguage lang) {
        return this.meanings.get((Object)lang);
    }

    public String getLiteral() {
        return this.literal;
    }

    public Misc getMisc() {
        return this.misc;
    }

    public Map<ReadingType, List<String>> getReadings() {
        return this.readings;
    }

    public Map<MeaningLanguage, List<String>> getMeanings() {
        return this.meanings;
    }

    public List<String> getNanori() {
        return this.nanori;
    }

    public void setLiteral(String literal) {
        this.literal = literal;
    }

    public void setMisc(Misc misc) {
        this.misc = misc;
    }

    @JsonDeserialize(as=HashMap.class)
    public void setReadings(Map<ReadingType, List<String>> readings) {
        this.readings = readings;
    }

    @JsonDeserialize(as=HashMap.class)
    public void setMeanings(Map<MeaningLanguage, List<String>> meanings) {
        this.meanings = meanings;
    }

    public void setNanori(List<String> nanori) {
        this.nanori = nanori;
    }

    public KanjiEntry() {
    }

    public KanjiEntry(String literal, Misc misc, Map<ReadingType, List<String>> readings, Map<MeaningLanguage, List<String>> meanings, List<String> nanori) {
        this.literal = literal;
        this.misc = misc;
        this.readings = readings;
        this.meanings = meanings;
        this.nanori = nanori;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KanjiEntry)) {
            return false;
        }
        KanjiEntry other = (KanjiEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$literal = this.getLiteral();
        String other$literal = other.getLiteral();
        if (this$literal == null ? other$literal != null : !this$literal.equals(other$literal)) {
            return false;
        }
        Misc this$misc = this.getMisc();
        Misc other$misc = other.getMisc();
        if (this$misc == null ? other$misc != null : !((Object)this$misc).equals(other$misc)) {
            return false;
        }
        Map<ReadingType, List<String>> this$readings = this.getReadings();
        Map<ReadingType, List<String>> other$readings = other.getReadings();
        if (this$readings == null ? other$readings != null : !((Object)this$readings).equals(other$readings)) {
            return false;
        }
        Map<MeaningLanguage, List<String>> this$meanings = this.getMeanings();
        Map<MeaningLanguage, List<String>> other$meanings = other.getMeanings();
        if (this$meanings == null ? other$meanings != null : !((Object)this$meanings).equals(other$meanings)) {
            return false;
        }
        List<String> this$nanori = this.getNanori();
        List<String> other$nanori = other.getNanori();
        return !(this$nanori == null ? other$nanori != null : !((Object)this$nanori).equals(other$nanori));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KanjiEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $literal = this.getLiteral();
        result = result * 59 + ($literal == null ? 43 : $literal.hashCode());
        Misc $misc = this.getMisc();
        result = result * 59 + ($misc == null ? 43 : ((Object)$misc).hashCode());
        Map<ReadingType, List<String>> $readings = this.getReadings();
        result = result * 59 + ($readings == null ? 43 : ((Object)$readings).hashCode());
        Map<MeaningLanguage, List<String>> $meanings = this.getMeanings();
        result = result * 59 + ($meanings == null ? 43 : ((Object)$meanings).hashCode());
        List<String> $nanori = this.getNanori();
        result = result * 59 + ($nanori == null ? 43 : ((Object)$nanori).hashCode());
        return result;
    }

    public String toString() {
        return "KanjiEntry(literal=" + this.getLiteral() + ", misc=" + String.valueOf(this.getMisc()) + ", readings=" + String.valueOf(this.getReadings()) + ", meanings=" + String.valueOf(this.getMeanings()) + ", nanori=" + String.valueOf(this.getNanori()) + ")";
    }

    public static class Misc
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Integer grade;
        private Integer strokeCount;
        private Integer freq;
        private Integer jlpt;

        public Integer getGrade() {
            return this.grade;
        }

        public Integer getStrokeCount() {
            return this.strokeCount;
        }

        public Integer getFreq() {
            return this.freq;
        }

        public Integer getJlpt() {
            return this.jlpt;
        }

        public void setGrade(Integer grade) {
            this.grade = grade;
        }

        public void setStrokeCount(Integer strokeCount) {
            this.strokeCount = strokeCount;
        }

        public void setFreq(Integer freq) {
            this.freq = freq;
        }

        public void setJlpt(Integer jlpt) {
            this.jlpt = jlpt;
        }

        public Misc(Integer grade, Integer strokeCount, Integer freq, Integer jlpt) {
            this.grade = grade;
            this.strokeCount = strokeCount;
            this.freq = freq;
            this.jlpt = jlpt;
        }

        public Misc() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Misc)) {
                return false;
            }
            Misc other = (Misc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$grade = this.getGrade();
            Integer other$grade = other.getGrade();
            if (this$grade == null ? other$grade != null : !((Object)this$grade).equals(other$grade)) {
                return false;
            }
            Integer this$strokeCount = this.getStrokeCount();
            Integer other$strokeCount = other.getStrokeCount();
            if (this$strokeCount == null ? other$strokeCount != null : !((Object)this$strokeCount).equals(other$strokeCount)) {
                return false;
            }
            Integer this$freq = this.getFreq();
            Integer other$freq = other.getFreq();
            if (this$freq == null ? other$freq != null : !((Object)this$freq).equals(other$freq)) {
                return false;
            }
            Integer this$jlpt = this.getJlpt();
            Integer other$jlpt = other.getJlpt();
            return !(this$jlpt == null ? other$jlpt != null : !((Object)this$jlpt).equals(other$jlpt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Misc;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $grade = this.getGrade();
            result = result * 59 + ($grade == null ? 43 : ((Object)$grade).hashCode());
            Integer $strokeCount = this.getStrokeCount();
            result = result * 59 + ($strokeCount == null ? 43 : ((Object)$strokeCount).hashCode());
            Integer $freq = this.getFreq();
            result = result * 59 + ($freq == null ? 43 : ((Object)$freq).hashCode());
            Integer $jlpt = this.getJlpt();
            result = result * 59 + ($jlpt == null ? 43 : ((Object)$jlpt).hashCode());
            return result;
        }

        public String toString() {
            return "KanjiEntry.Misc(grade=" + this.getGrade() + ", strokeCount=" + this.getStrokeCount() + ", freq=" + this.getFreq() + ", jlpt=" + this.getJlpt() + ")";
        }
    }
}

