/*
 * Decompiled with CFR 0.152.
 */
package io.github.aliasbretaud.mojibox.dictionary;

import io.github.aliasbretaud.mojibox.builder.DictionaryBuilder;
import io.github.aliasbretaud.mojibox.data.DictionaryData;
import io.github.aliasbretaud.mojibox.data.KanjiEntry;
import io.github.aliasbretaud.mojibox.data.Metadata;
import java.io.IOException;
import java.net.URL;

public class KanjiDictionary {
    private final DictionaryData data;

    public KanjiDictionary() {
        URL dictionaryUrl = this.getClass().getClassLoader().getResource("kanji_dictionary.json");
        try {
            this.data = new DictionaryBuilder(dictionaryUrl).generateData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public KanjiEntry searchKanji(String search) {
        if (search == null) {
            return null;
        }
        return this.data.getKanjis().get(search);
    }

    public Metadata getMetadata() {
        return this.data.getMetadata();
    }

    public int getSize() {
        return this.data.getKanjis().size();
    }
}

