/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.producer;

import android.text.TextUtils;
import com.aliyun.sls.android.producer.utils.TimeUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Log {
    private long logTime;
    private final Map<String, String> content = new LinkedHashMap<String, String>();
    private final Object lock = new Object();

    public Log() {
        this.logTime = TimeUtils.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContents(Map<String, String> contents) {
        if (null == contents || contents.isEmpty()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.content.putAll(new LinkedHashMap<String, String>(contents));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(String key, String value) {
        Object object = this.lock;
        synchronized (object) {
            this.content.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(String key, int value) {
        Object object = this.lock;
        synchronized (object) {
            this.content.put(key, String.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(String key, long value) {
        Object object = this.lock;
        synchronized (object) {
            this.content.put(key, String.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(String key, boolean value) {
        Object object = this.lock;
        synchronized (object) {
            this.content.put(key, String.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(String key, float value) {
        Object object = this.lock;
        synchronized (object) {
            this.content.put(key, String.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(String key, double value) {
        Object object = this.lock;
        synchronized (object) {
            this.content.put(key, String.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(String key, JSONObject object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (null != object) {
                this.content.put(key, object.toString());
            } else {
                this.content.put(key, "null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(String key, JSONArray array) {
        Object object = this.lock;
        synchronized (object) {
            if (null != array) {
                this.content.put(key, array.toString());
            } else {
                this.content.put(key, "null");
            }
        }
    }

    public void putContent(JSONObject jsonObject) {
        JSONObject tmp;
        if (null == jsonObject || jsonObject.length() == 0) {
            return;
        }
        try {
            tmp = new JSONObject(jsonObject.toString());
        }
        catch (JSONException e) {
            tmp = null;
        }
        if (null == tmp) {
            return;
        }
        Iterator it = tmp.keys();
        LinkedHashMap<String, String> kvMap = new LinkedHashMap<String, String>();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (TextUtils.isEmpty((CharSequence)key)) continue;
            Object value = tmp.opt(key);
            if (null == value || JSONObject.NULL == value || value instanceof Boolean) {
                kvMap.put(key, String.valueOf(value));
                continue;
            }
            if (value instanceof JSONObject) {
                kvMap.put(key, ((JSONObject)value).toString());
                continue;
            }
            if (value instanceof JSONArray) {
                kvMap.put(key, ((JSONArray)value).toString());
                continue;
            }
            if (value instanceof Number) {
                kvMap.put(key, this.numberToString((Number)value));
                continue;
            }
            kvMap.put(key, value.toString());
        }
        this.putContents(kvMap);
    }

    private String numberToString(Number value) {
        try {
            return JSONObject.numberToString((Number)value);
        }
        catch (JSONException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getContent() {
        Object object = this.lock;
        synchronized (object) {
            return this.content;
        }
    }

    public long getLogTime() {
        return this.logTime;
    }

    @Deprecated
    public void setLogTime(long logTime) {
        this.logTime = logTime;
    }
}

