/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.producer;

import android.text.TextUtils;
import com.aliyun.sls.android.producer.Log;
import com.aliyun.sls.android.producer.LogProducerCallback;
import com.aliyun.sls.android.producer.LogProducerConfig;
import com.aliyun.sls.android.producer.LogProducerException;
import com.aliyun.sls.android.producer.LogProducerResult;
import com.aliyun.sls.android.producer.utils.ThreadUtils;
import com.aliyun.sls.android.producer.utils.TimeUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class LogProducerClient {
    private final LogProducerConfig config;
    private final long producer;
    private final long client;
    private boolean enable;

    public LogProducerClient(LogProducerConfig logProducerConfig) throws LogProducerException {
        this(logProducerConfig, null);
    }

    public LogProducerClient(LogProducerConfig logProducerConfig, LogProducerCallback callback) throws LogProducerException {
        this.config = logProducerConfig;
        this.producer = LogProducerClient.create_log_producer(logProducerConfig.getConfig(), callback);
        if (this.producer == 0L) {
            throw new LogProducerException("Can not create log producer");
        }
        this.client = LogProducerClient.get_log_producer_client(this.producer);
        if (this.client == 0L) {
            throw new LogProducerException("Can not create log producer client");
        }
        String endpoint = logProducerConfig.getEndpoint();
        String project = logProducerConfig.getProject();
        if (!TextUtils.isEmpty((CharSequence)endpoint) && !TextUtils.isEmpty((CharSequence)project)) {
            TimeUtils.startUpdateServerTime(logProducerConfig.getContext(), endpoint, project);
        }
        this.enable = true;
    }

    public LogProducerResult addLog(Log log) {
        return this.addLog(log, 0);
    }

    public LogProducerResult addLog(Log log, int flush) {
        if (!this.enable || this.client == 0L || log == null) {
            return LogProducerResult.LOG_PRODUCER_INVALID;
        }
        LinkedHashMap<String, String> contents = new LinkedHashMap<String, String>(log.getContent());
        int pairCount = contents.size();
        String[] keyArray = new String[pairCount];
        String[] valueArray = new String[pairCount];
        int i = 0;
        for (Map.Entry entry : contents.entrySet()) {
            String key = (String)entry.getKey();
            keyArray[i] = key = key == null ? "" : key;
            String value = (String)entry.getValue();
            valueArray[i] = value = value == null ? "" : value;
            ++i;
        }
        long logTime = log.getLogTime();
        int res = LogProducerClient.log_producer_client_add_log_with_len(this.client, logTime, pairCount, keyArray, valueArray, flush);
        return LogProducerResult.fromInt(res);
    }

    public LogProducerResult addLogRaw(byte[][] keys, byte[][] values) {
        if (!this.enable || this.client == 0L || null == keys || null == values) {
            return LogProducerResult.LOG_PRODUCER_INVALID;
        }
        long logTime = new Log().getLogTime();
        int res = LogProducerClient.log_producer_client_add_log_with_len_time_int32(this.client, logTime, keys.length, keys, values);
        return LogProducerResult.fromInt(res);
    }

    public void destroyLogProducer() {
        if (!this.enable) {
            return;
        }
        this.enable = false;
        ThreadUtils.exec(new Runnable(){

            @Override
            public void run() {
                LogProducerClient.destroy_log_producer(LogProducerClient.this.producer);
            }
        });
    }

    private static native long create_log_producer(long var0, LogProducerCallback var2);

    private static native long get_log_producer_client(long var0);

    private static native int log_producer_client_add_log_with_len(long var0, long var2, int var4, String[] var5, String[] var6, int var7);

    private static native int log_producer_client_add_log_with_len_time_int32(long var0, long var2, int var4, byte[][] var5, byte[][] var6);

    private static native void destroy_log_producer(long var0);
}

