/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.producer;

import android.text.TextUtils;
import android.util.Log;
import com.aliyun.sls.android.producer.utils.TimeUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class LogProducerHttpTool {
    private static final String TAG = "LogProducerHttpTool";

    public static int android_http_post(String urlString, String[] header, byte[] body) {
        return LogProducerHttpTool.android_http_post(urlString, "POST", header, body);
    }

    public static int android_http_post(String urlString, String method, String[] header, byte[] body) {
        try {
            String inputLine;
            int responseCode;
            long serverTime;
            String timeVal;
            URL url = new URL(urlString);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            if ("post".equalsIgnoreCase(method)) {
                httpConn.setDoOutput(true);
            }
            httpConn.setRequestMethod(method);
            if (header != null) {
                int pairs = header.length / 2;
                for (int i = 0; i < pairs; ++i) {
                    String key = header[2 * i];
                    String val = header[2 * i + 1];
                    httpConn.setRequestProperty(key, val);
                }
            }
            if ("post".equalsIgnoreCase(method)) {
                DataOutputStream out = new DataOutputStream(httpConn.getOutputStream());
                out.write(body);
                out.flush();
                out.close();
            }
            if ((timeVal = httpConn.getHeaderField("x-log-time")) != null && !"".equals(timeVal) && (serverTime = LogProducerHttpTool.toLong(timeVal)) > 1500000000L && serverTime < 0xFFFFFFFEL) {
                TimeUtils.updateServerTime(serverTime);
            }
            if ((responseCode = httpConn.getResponseCode()) / 100 == 2) {
                return responseCode;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConn.getErrorStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            if (400 == responseCode && TextUtils.isEmpty((CharSequence)httpConn.getHeaderField("x-log-requestid"))) {
                Log.w((String)TAG, (String)("request may have been blocked. it will be retried. errorCode: " + response));
                return -1;
            }
            Log.w((String)TAG, (String)("code: " + responseCode + ", response: " + response));
            return responseCode;
        }
        catch (Exception ex) {
            Log.w((String)TAG, (String)("exception: " + ex.getLocalizedMessage()));
            return -1;
        }
    }

    private static long toLong(String time) {
        try {
            return Long.parseLong(time);
        }
        catch (Throwable t) {
            return 0L;
        }
    }
}

