/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.producer.utils;

import android.annotation.SuppressLint;
import android.app.Application;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import java.lang.reflect.Method;

@SuppressLint(value={"PrivateApi"})
public final class ContextUtils {
    private static Class<?> sActivityThread = null;
    private static Application sApplication;

    private ContextUtils() {
    }

    public static synchronized Application getApplication() {
        if (null != sApplication) {
            return sApplication;
        }
        if (null == sActivityThread) {
            return null;
        }
        Object activityThreadObjc = ContextUtils.getActivityThread();
        if (null == activityThreadObjc) {
            return null;
        }
        try {
            Method getApplicationMethod = activityThreadObjc.getClass().getMethod("getApplication", new Class[0]);
            getApplicationMethod.setAccessible(true);
            sApplication = (Application)getApplicationMethod.invoke(activityThreadObjc, (Object[])null);
            return sApplication;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"PrivateApi"})
    public static synchronized Object getActivityThread() {
        try {
            if (null == sActivityThread) {
                return null;
            }
            Method currentActivityThreadMethod = sActivityThread.getMethod("currentActivityThread", new Class[0]);
            currentActivityThreadMethod.setAccessible(true);
            if (Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId() || Build.VERSION.SDK_INT >= 18) {
                return currentActivityThreadMethod.invoke(null, new Object[0]);
            }
            Object lock = new Object();
            Object[] output = new Object[1];
            Object object = lock;
            synchronized (object) {
                new Handler(Looper.getMainLooper()).post(() -> {
                    try {
                        output[0] = currentActivityThreadMethod.invoke(null, new Object[0]);
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        try {
                            lock.notify();
                        }
                        catch (Throwable throwable) {}
                    }
                });
            }
            try {
                lock.wait();
            }
            catch (Throwable ignored) {
                return null;
            }
            return output[0];
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            sActivityThread = Class.forName("android.app.ActivityThread");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

