/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.producer.utils;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;

public final class ProcessUtils {
    private static String sProcessName;

    public static String getCurrentProcessName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sProcessName)) {
            return sProcessName;
        }
        String processName = ProcessUtils.getProcessNameByApplication();
        if (!TextUtils.isEmpty((CharSequence)processName)) {
            sProcessName = processName;
            return sProcessName;
        }
        processName = ProcessUtils.getProcessNameViaLinuxFile();
        if (!TextUtils.isEmpty((CharSequence)processName)) {
            sProcessName = processName;
            return sProcessName;
        }
        processName = ProcessUtils.getProcessNameViaActivityManager(context);
        if (!TextUtils.isEmpty((CharSequence)processName)) {
            sProcessName = processName;
            return sProcessName;
        }
        return sProcessName;
    }

    public static boolean isMainProcess(Context context) {
        return ProcessUtils.isInProcess(context, context.getPackageName());
    }

    public static boolean isInProcess(Context context, String processName) {
        String currentProcessName = ProcessUtils.getCurrentProcessName(context);
        return processName != null && processName.equalsIgnoreCase(currentProcessName);
    }

    private static String getProcessNameByApplication() {
        if (Build.VERSION.SDK_INT >= 28) {
            return Application.getProcessName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessNameViaLinuxFile() {
        int pid = Process.myPid();
        String line = "/proc/" + pid + "/cmdline";
        FileInputStream fis = null;
        String processName = null;
        byte[] bytes = new byte[1024];
        int read = 0;
        try {
            fis = new FileInputStream(line);
            read = fis.read(bytes);
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (read > 0) {
            processName = new String(bytes, 0, read);
            processName = processName.trim();
        }
        return processName;
    }

    private static String getProcessNameViaActivityManager(Context context) {
        if (context == null) {
            return null;
        }
        int pid = Process.myPid();
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        if (mActivityManager == null) {
            return null;
        }
        List processes = mActivityManager.getRunningAppProcesses();
        if (processes == null) {
            return null;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : processes) {
            if (appProcess == null || appProcess.pid != pid) continue;
            return appProcess.processName;
        }
        return null;
    }
}

