/*
 * Decompiled with CFR 0.152.
 */
package io.github.almightysatan.jaskl.hocon;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.github.almightysatan.jaskl.Config;
import io.github.almightysatan.jaskl.ConfigEntry;
import io.github.almightysatan.jaskl.ExceptionHandler;
import io.github.almightysatan.jaskl.Resource;
import io.github.almightysatan.jaskl.hocon.NopIncluder;
import io.github.almightysatan.jaskl.impl.ConfigImpl;
import io.github.almightysatan.jaskl.impl.WritableConfigEntry;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class HoconConfig
extends ConfigImpl {
    private static final ConfigParseOptions PARSE_OPTIONS = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF).setAllowMissing(false).setIncluder((ConfigIncluder)new NopIncluder());
    private static final ConfigRenderOptions RENDER_OPTIONS = ConfigRenderOptions.defaults().setJson(false).setOriginComments(false);
    private final Resource resource;
    private com.typesafe.config.Config config;

    private HoconConfig(@NotNull Resource resource, @Nullable String description, @Nullable ExceptionHandler exceptionHandler) {
        super(description, exceptionHandler);
        this.resource = Objects.requireNonNull(resource);
    }

    public void load() throws IllegalStateException, IOException {
        if (this.config != null) {
            throw new IllegalStateException();
        }
        if (!this.resource.exists()) {
            this.config = ConfigFactory.empty();
            return;
        }
        this.config = ConfigFactory.parseReader((Reader)this.resource.getReader(), (ConfigParseOptions)PARSE_OPTIONS);
        this.reload();
    }

    public void reload() throws IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException();
        }
        for (ConfigEntry uncastedConfigEntry : this.getValues()) {
            WritableConfigEntry configEntry = (WritableConfigEntry)uncastedConfigEntry;
            try {
                Object value = this.config.getValue(configEntry.getPath()).unwrapped();
                configEntry.putValue(value, this.getExceptionHandler());
            }
            catch (ConfigException.Missing missing) {}
        }
    }

    public void write() throws IOException {
        com.typesafe.config.Config config = this.config;
        if (config == null) {
            throw new IllegalStateException();
        }
        this.resource.createIfNotExists();
        for (WritableConfigEntry configEntry : this.getCastedValues()) {
            if (!configEntry.isModified()) continue;
            Object entryValue = configEntry.getValueToWrite(Object::toString);
            if (entryValue instanceof BigInteger) {
                entryValue = entryValue.toString();
            }
            if (entryValue instanceof BigDecimal) {
                entryValue = entryValue.toString();
            }
            ConfigValue value = ConfigValueFactory.fromAnyRef((Object)entryValue);
            if (configEntry.getDescription() != null) {
                value = value.withOrigin(value.origin().withComments(this.toCommentList(configEntry.getDescription())));
            }
            config = config.withValue(configEntry.getPath(), value);
        }
        this.writeIfNecessary(config, true);
    }

    @NotNull
    public @Unmodifiable @NotNull Set<@NotNull String> prune() throws IOException {
        com.typesafe.config.Config config = this.config;
        if (config == null) {
            throw new IllegalStateException();
        }
        if (!this.resource.exists()) {
            return Collections.emptySet();
        }
        HashSet<String> pathsToRemove = new HashSet<String>();
        HashSet<String> valuePathsRemoved = new HashSet<String>();
        this.resolvePathsToStrip("", config.root(), this.getPaths(), pathsToRemove, valuePathsRemoved);
        for (String path : pathsToRemove) {
            config = config.withoutPath(path);
        }
        this.writeIfNecessary(config, false);
        return Collections.unmodifiableSet(valuePathsRemoved);
    }

    public void close() {
        if (this.config != null) {
            this.config = null;
        }
    }

    protected void writeIfNecessary(@NotNull com.typesafe.config.Config config, boolean setDescription) throws IOException {
        if (config != this.config) {
            ConfigObject root = setDescription ? config.root().withOrigin(this.config.root().origin().withComments(this.toCommentList(this.getDescription()))) : config.root();
            String output = root.render(RENDER_OPTIONS);
            try (Writer fileWriter = this.resource.getWriter();){
                fileWriter.write(output);
            }
            this.config = config;
        }
    }

    protected void resolvePathsToStrip(@NotNull String path, @NotNull ConfigObject node, @NotNull Set<String> paths, @NotNull Set<String> toRemove, @NotNull Set<String> valuePathsRemoved) {
        for (Map.Entry entry : node.entrySet()) {
            String fieldPath = (path.isEmpty() ? "" : path + ".") + (String)entry.getKey();
            if (entry.getValue() instanceof ConfigObject) {
                if (paths.contains(fieldPath)) continue;
                ConfigObject child = (ConfigObject)entry.getValue();
                int numRemoved = toRemove.size();
                this.resolvePathsToStrip(fieldPath, child, paths, toRemove, valuePathsRemoved);
                int numChildren = child.size();
                if (numChildren != 0 && numChildren != toRemove.size() - numRemoved) continue;
                toRemove.add(fieldPath);
                continue;
            }
            if (paths.contains(fieldPath)) continue;
            toRemove.add(fieldPath);
            valuePathsRemoved.add(fieldPath);
        }
    }

    @Nullable
    protected List<String> toCommentList(String description) {
        if (description == null) {
            return null;
        }
        return Arrays.asList(description.split("\n"));
    }

    public static Config of(@NotNull Resource resource, @Nullable String description, @Nullable ExceptionHandler exceptionHandler) {
        return new HoconConfig(resource, description, exceptionHandler);
    }

    public static Config of(@NotNull Resource resource, @Nullable String description) {
        return HoconConfig.of(resource, description, null);
    }

    public static Config of(@NotNull Resource resource) {
        return HoconConfig.of(resource, null);
    }

    public static Config of(@NotNull File file, @Nullable String description, @Nullable ExceptionHandler exceptionHandler) {
        return HoconConfig.of(Resource.of((File)file), description, exceptionHandler);
    }

    public static Config of(@NotNull File file, @Nullable String description) {
        return HoconConfig.of(Resource.of((File)file), description);
    }

    public static Config of(@NotNull File file) {
        return HoconConfig.of(file, null);
    }
}

