/*
 * Decompiled with CFR 0.152.
 */
package io.github.almightysatan.jaskl.yaml;

import io.github.almightysatan.jaskl.ExceptionHandler;
import io.github.almightysatan.jaskl.Resource;
import io.github.almightysatan.jaskl.impl.ConfigImpl;
import io.github.almightysatan.jaskl.impl.WritableConfigEntry;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.comments.CommentLine;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class YamlConfig
extends ConfigImpl {
    private static final CustomConstructor CONSTRUCTOR = new CustomConstructor();
    private final Resource resource;
    private final DumperOptions dumperOptions;
    private final Representer representer;
    private final Representer valueRepresenter;
    private Yaml yaml;
    private MappingNode root;

    private YamlConfig(@NotNull Resource resource, @Nullable String description, @Nullable ExceptionHandler exceptionHandler, @NotNull DumperOptions dumperOptions) {
        super(description, exceptionHandler);
        this.dumperOptions = Objects.requireNonNull(dumperOptions);
        this.representer = new Representer(dumperOptions);
        this.valueRepresenter = new ValueRepresenter(dumperOptions);
        this.resource = Objects.requireNonNull(resource);
    }

    public void load() throws IOException, IllegalStateException {
        if (this.yaml != null) {
            throw new IllegalStateException();
        }
        this.yaml = new Yaml((BaseConstructor)CONSTRUCTOR, this.representer, this.dumperOptions);
        this.reload();
    }

    public void reload() throws IOException, IllegalStateException {
        if (this.yaml == null) {
            throw new IllegalStateException();
        }
        if (!this.resource.exists()) {
            this.createRoot();
            return;
        }
        try (Reader reader = this.resource.getReader();){
            this.root = (MappingNode)this.yaml.compose(reader);
            if (this.root == null) {
                this.createRoot();
            }
            this.loadValues("", this.root);
        }
    }

    public void write() throws IOException {
        if (this.yaml == null) {
            throw new IllegalStateException();
        }
        this.resource.createIfNotExists();
        this.setComment((Node)this.root, this.getDescription());
        boolean shouldWrite = false;
        for (WritableConfigEntry configEntry : this.getCastedValues()) {
            if (!configEntry.isModified()) continue;
            this.putNode(configEntry);
            shouldWrite = true;
        }
        if (shouldWrite) {
            try (Writer writer = this.resource.getWriter();){
                this.yaml.serialize((Node)this.root, writer);
            }
        }
    }

    @NotNull
    public @Unmodifiable @NotNull Set<@NotNull String> prune() throws IOException {
        if (this.yaml == null) {
            throw new IllegalStateException();
        }
        if (!this.resource.exists()) {
            return Collections.emptySet();
        }
        HashSet<String> removedPaths = new HashSet<String>();
        if (this.stripNodes("", this.root, this.getPaths(), removedPaths)) {
            try (Writer writer = this.resource.getWriter();){
                this.yaml.serialize((Node)this.root, writer);
            }
        }
        return Collections.unmodifiableSet(removedPaths);
    }

    public void close() {
        this.yaml = null;
        this.root = null;
    }

    public boolean isReadOnly() throws IOException {
        return this.resource.isReadOnly();
    }

    protected void createRoot() {
        this.root = new MappingNode(Tag.MAP, new ArrayList(), DumperOptions.FlowStyle.BLOCK);
    }

    protected void loadValues(@NotNull String path, @NotNull MappingNode node) {
        for (NodeTuple tuple : node.getValue()) {
            Node valueNode = tuple.getValueNode();
            String fieldPath = (path.isEmpty() ? "" : path + ".") + ((ScalarNode)tuple.getKeyNode()).getValue();
            if (valueNode instanceof MappingNode) {
                if (this.loadValueIfEntryExists(fieldPath, valueNode)) continue;
                this.loadValues(fieldPath, (MappingNode)valueNode);
                continue;
            }
            if (!(valueNode instanceof ScalarNode) && !(valueNode instanceof SequenceNode)) continue;
            this.loadValueIfEntryExists(fieldPath, valueNode);
        }
    }

    protected boolean loadValueIfEntryExists(String path, Node node) {
        WritableConfigEntry entry = (WritableConfigEntry)this.getEntries().get(path);
        if (entry == null) {
            return false;
        }
        Object value = CONSTRUCTOR.constructObject(node);
        if (value != null) {
            entry.putValue(value, this.getExceptionHandler());
        }
        return true;
    }

    protected void putNode(@NotNull WritableConfigEntry<?> entry) {
        String[] pathSplit = entry.getPath().split("\\.");
        MappingNode node = this.root;
        block0: for (int i = 0; i < pathSplit.length; ++i) {
            for (NodeTuple tuple : node.getValue()) {
                if (!((ScalarNode)tuple.getKeyNode()).getValue().equals(pathSplit[i])) continue;
                if (i != pathSplit.length - 1) {
                    node = (MappingNode)tuple.getValueNode();
                    continue block0;
                }
                node.getValue().replaceAll(nodeTuple -> {
                    if (nodeTuple != tuple) {
                        return nodeTuple;
                    }
                    return this.newNodeTuple(pathSplit[pathSplit.length - 1], entry.getDescription(), entry.getValueToWrite());
                });
                return;
            }
            if (i != pathSplit.length - 1) {
                MappingNode newNode = new MappingNode(Tag.MAP, new ArrayList(), DumperOptions.FlowStyle.BLOCK);
                node.getValue().add(new NodeTuple(this.yaml.represent((Object)pathSplit[i]), (Node)newNode));
                node = newNode;
                continue;
            }
            node.getValue().add(this.newNodeTuple(pathSplit[pathSplit.length - 1], entry.getDescription(), entry.getValueToWrite()));
            return;
        }
    }

    @NotNull
    protected NodeTuple newNodeTuple(@NotNull String path, @Nullable String comment, @NotNull Object value) {
        Node keyNode = this.yaml.represent((Object)path);
        this.setComment(keyNode, comment);
        Node valueNode = this.valueRepresenter.represent(value);
        return new NodeTuple(keyNode, valueNode);
    }

    protected void setComment(@NotNull Node node, @Nullable String comment) {
        if (comment != null) {
            node.setBlockComments(Arrays.stream(comment.split("\n")).map(line -> new CommentLine(null, null, " " + line, CommentType.BLOCK)).collect(Collectors.toList()));
        } else {
            node.setBlockComments(Collections.emptyList());
        }
    }

    protected boolean stripNodes(@NotNull String path, @NotNull MappingNode node, @NotNull Set<String> paths, @NotNull Set<String> removedPaths) {
        boolean changed = false;
        ArrayList<NodeTuple> toRemove = new ArrayList<NodeTuple>();
        for (NodeTuple tuple : node.getValue()) {
            Node valueNode = tuple.getValueNode();
            String fieldPath = (path.isEmpty() ? "" : path + ".") + ((ScalarNode)tuple.getKeyNode()).getValue();
            if (valueNode instanceof MappingNode) {
                if (paths.contains(fieldPath)) continue;
                MappingNode child = (MappingNode)valueNode;
                changed |= this.stripNodes(fieldPath, child, paths, removedPaths);
                if (!child.getValue().isEmpty()) continue;
                toRemove.add(tuple);
                continue;
            }
            if (!(valueNode instanceof ScalarNode) && !(valueNode instanceof SequenceNode) || paths.contains(fieldPath)) continue;
            toRemove.add(tuple);
            removedPaths.add(fieldPath);
        }
        if (!toRemove.isEmpty()) {
            changed = true;
            for (NodeTuple tuple : toRemove) {
                node.getValue().remove(tuple);
            }
        }
        return changed;
    }

    @NotNull
    public static YamlConfig of(@NotNull Resource resource, @Nullable String description, @Nullable ExceptionHandler exceptionHandler, @NotNull DumperOptions dumperOptions) {
        return new YamlConfig(resource, description, exceptionHandler, dumperOptions);
    }

    @NotNull
    public static YamlConfig of(@NotNull Resource resource, @Nullable String description, @Nullable ExceptionHandler exceptionHandler) {
        return YamlConfig.of(resource, description, exceptionHandler, YamlConfig.getDefaultDumperOptions());
    }

    @NotNull
    public static YamlConfig of(@NotNull Resource resource, @Nullable String description) {
        return YamlConfig.of(resource, description, null);
    }

    @NotNull
    public static YamlConfig of(@NotNull Resource resource) {
        return YamlConfig.of(resource, null);
    }

    @NotNull
    public static YamlConfig of(@NotNull File file, @Nullable String description, @Nullable ExceptionHandler exceptionHandler) {
        return YamlConfig.of(Resource.of((File)file), description, exceptionHandler);
    }

    @NotNull
    public static YamlConfig of(@NotNull File file, @Nullable String description) {
        return YamlConfig.of(Resource.of((File)file), description);
    }

    @NotNull
    public static YamlConfig of(@NotNull File file) {
        return YamlConfig.of(file, null);
    }

    public static DumperOptions getDefaultDumperOptions() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setProcessComments(true);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setSplitLines(false);
        return dumperOptions;
    }

    private static class CustomConstructor
    extends SafeConstructor {
        public CustomConstructor() {
            super(new LoaderOptions().setProcessComments(true));
            this.yamlConstructors.put(Tag.FLOAT, new ConstructYamlFloat());
        }

        protected Object constructObject(Node node) {
            return super.constructObject(node);
        }

        private static class JasklConstructorException
        extends ConstructorException {
            protected JasklConstructorException(String context, Mark contextMark, String problem, Mark problemMark) {
                super(context, contextMark, problem, problemMark);
            }
        }

        private class ConstructYamlFloat
        extends AbstractConstruct {
            private ConstructYamlFloat() {
            }

            public Object construct(Node node) {
                String value = CustomConstructor.this.constructScalar((ScalarNode)node).replace("_", "").toLowerCase();
                if (value.isEmpty()) {
                    throw new JasklConstructorException("while constructing a BigDecimal", node.getStartMark(), "found empty value", node.getStartMark());
                }
                switch (value) {
                    case ".inf": 
                    case "+.inf": {
                        return Double.POSITIVE_INFINITY;
                    }
                    case "-.inf": {
                        return Double.NEGATIVE_INFINITY;
                    }
                    case ".nan": 
                    case "+.nan": 
                    case "-.nan": {
                        return Double.NaN;
                    }
                }
                return new BigDecimal(value);
            }
        }
    }

    private static class ValueRepresenter
    extends Representer {
        public ValueRepresenter(DumperOptions options) {
            super(options);
            this.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        }

        protected Node representScalar(Tag tag, String value, DumperOptions.ScalarStyle style) {
            return super.representScalar(tag, value, tag == Tag.STR && (style == null || style == DumperOptions.ScalarStyle.PLAIN || style == DumperOptions.ScalarStyle.SINGLE_QUOTED) ? DumperOptions.ScalarStyle.DOUBLE_QUOTED : style);
        }
    }
}

