/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerousful.kafka.protocol;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.CoreComponents;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.protocol.Protocol;
import io.gatling.core.protocol.ProtocolKey;
import io.github.amerousful.kafka.client.KafkaTrackerPoll;
import io.github.amerousful.kafka.protocol.KafkaComponents;
import io.github.amerousful.kafka.protocol.KafkaKeyMatcher$;
import io.github.amerousful.kafka.protocol.KafkaMatcher;
import io.github.amerousful.kafka.protocol.KafkaProtocol;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.kafka.clients.producer.KafkaProducer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;

public final class KafkaProtocol$
implements StrictLogging,
Serializable {
    public static final KafkaProtocol$ MODULE$ = new KafkaProtocol$();
    private static final ProtocolKey<KafkaProtocol, KafkaComponents> kafkaProtocolKey;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        kafkaProtocolKey = new ProtocolKey<KafkaProtocol, KafkaComponents>(){

            public Class<Protocol> protocolClass() {
                return KafkaProtocol.class;
            }

            public KafkaProtocol defaultProtocolValue(GatlingConfiguration configuration) {
                throw new IllegalStateException("Can't provide a default value for KafkaProtocol");
            }

            public Function1<KafkaProtocol, KafkaComponents> newComponents(CoreComponents coreComponents) {
                return (Function1 & Serializable)kafkaProtocol -> {
                    BoxedUnit boxedUnit;
                    java.util.Map producerProperties = CollectionConverters$.MODULE$.MapHasAsJava(kafkaProtocol.producerProperties()).asJava();
                    Map<String, Object> consumerProperties = kafkaProtocol.consumerProperties();
                    if (KafkaProtocol$.MODULE$.logger().underlying().isDebugEnabled()) {
                        String prodProps = ((IterableOnceOps)kafkaProtocol.producerProperties().map((Function1 & Serializable)i -> new StringBuilder(2).append(i._1()).append(": ").append(i._2()).toString())).mkString("\n");
                        if (KafkaProtocol$.MODULE$.logger().underlying().isDebugEnabled()) {
                            KafkaProtocol$.MODULE$.logger().underlying().debug("Producer properties:\n{}\n", (Object)prodProps);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    KafkaProducer producer = new KafkaProducer(producerProperties);
                    KafkaTrackerPoll trackerPoller = new KafkaTrackerPoll(consumerProperties, coreComponents.actorSystem(), coreComponents.statsEngine(), coreComponents.clock());
                    coreComponents.actorSystem().registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        BoxedUnit boxedUnit;
                        if (KafkaProtocol$.MODULE$.logger().underlying().isDebugEnabled()) {
                            KafkaProtocol$.MODULE$.logger().underlying().debug("Termination was registered. Producer and poller gonna close");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        producer.close();
                        trackerPoller.close();
                    });
                    return new KafkaComponents((KafkaProtocol)kafkaProtocol, (KafkaProducer<String, String>)producer, trackerPoller);
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$newComponents$1(io.gatling.core.CoreComponents io.github.amerousful.kafka.protocol.KafkaProtocol ), $anonfun$newComponents$2(scala.Tuple2 ), $anonfun$newComponents$3(org.apache.kafka.clients.producer.KafkaProducer io.github.amerousful.kafka.client.KafkaTrackerPoll )}, serializedLambda);
            }
        };
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public ProtocolKey<KafkaProtocol, KafkaComponents> kafkaProtocolKey() {
        return kafkaProtocolKey;
    }

    public KafkaProtocol apply() {
        return new KafkaProtocol((Map<String, Object>)Predef$.MODULE$.Map().empty(), (Map<String, Object>)Predef$.MODULE$.Map().empty(), KafkaKeyMatcher$.MODULE$, (Option<FiniteDuration>)None$.MODULE$);
    }

    public KafkaProtocol apply(Map<String, Object> producerProperties, Map<String, Object> consumerProperties, KafkaMatcher messageMatcher, Option<FiniteDuration> replyTimeout) {
        return new KafkaProtocol(producerProperties, consumerProperties, messageMatcher, replyTimeout);
    }

    public Option<Tuple4<Map<String, Object>, Map<String, Object>, KafkaMatcher, Option<FiniteDuration>>> unapply(KafkaProtocol x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4(x$0.producerProperties(), x$0.consumerProperties(), (Object)x$0.messageMatcher(), x$0.replyTimeout()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(KafkaProtocol$.class);
    }

    private KafkaProtocol$() {
    }
}

