/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerousful.kafka.action;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.stats.StatsEngine;
import io.github.amerousful.kafka.action.Around;
import io.github.amerousful.kafka.action.KafkaAction;
import io.github.amerousful.kafka.client.KafkaTracker;
import io.github.amerousful.kafka.client.KafkaTrackerPoll;
import io.github.amerousful.kafka.protocol.KafkaMatcher;
import io.github.amerousful.kafka.protocol.KafkaProtocol;
import io.github.amerousful.kafka.request.KafkaAttributes;
import java.io.Serializable;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!\u0011\u0007A!A!\u0002\u0013\u0019\u0007\u0002C5\u0001\u0005\u000b\u0007I\u0011\u00016\t\u0011E\u0004!\u0011!Q\u0001\n-D\u0001B\u001d\u0001\u0003\u0006\u0004%\ta\u001d\u0005\ty\u0002\u0011\t\u0011)A\u0005i\"AQ\u0010\u0001BC\u0002\u0013\u0005a\u0010C\u0005\u0002\n\u0001\u0011\t\u0011)A\u0005\u007f\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001\"CA\u0011\u0001\t\u0007I\u0011IA\u0012\u0011\u001d\t)\u0003\u0001Q\u0001\n\u0015C\u0011\"a\n\u0001\u0005\u0004%I!!\u000b\t\u0011\u0005E\u0002\u0001)A\u0005\u0003WA\u0011\"a\r\u0001\u0005\u0004%I!!\u000e\t\u0011\u0005}\u0002\u0001)A\u0005\u0003oAq!!\u0011\u0001\t#\n\u0019E\u0001\u0007SKF,Xm\u001d;SKBd\u0017P\u0003\u0002\u0017/\u00051\u0011m\u0019;j_:T!\u0001G\r\u0002\u000b-\fgm[1\u000b\u0005iY\u0012AC1nKJ|Wo\u001d4vY*\u0011A$H\u0001\u0007O&$\b.\u001e2\u000b\u0003y\t!![8\u0004\u0001M\u0011\u0001!\t\t\u0003E\rj\u0011!F\u0005\u0003IU\u00111bS1gW\u0006\f5\r^5p]\u0006Q\u0011\r\u001e;sS\n,H/Z:\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%:\u0012a\u0002:fcV,7\u000f^\u0005\u0003W!\u0012qbS1gW\u0006\fE\u000f\u001e:jEV$Xm]\u0001\u000be\u0016\u0004H.\u001f+pa&\u001c\u0007c\u0001\u0018C\u000b:\u0011qf\u0010\b\u0003aqr!!M\u001d\u000f\u0005I:dBA\u001a7\u001b\u0005!$BA\u001b \u0003\u0019a$o\\8u}%\ta$\u0003\u00029;\u00059q-\u0019;mS:<\u0017B\u0001\u001e<\u0003\u0011\u0019wN]3\u000b\u0005aj\u0012BA\u001f?\u0003\u001d\u0019Xm]:j_:T!AO\u001e\n\u0005\u0001\u000b\u0015a\u00029bG.\fw-\u001a\u0006\u0003{yJ!a\u0011#\u0003\u0015\u0015C\bO]3tg&|gN\u0003\u0002A\u0003B\u0011a\t\u0014\b\u0003\u000f*\u0003\"a\r%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0002\rA\u0013X\rZ3g\u0013\tieJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0017\"\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0003#Nk\u0011A\u0015\u0006\u0003\u001f^I!\u0001\u0016*\u0003\u001b-\u000bgm[1Qe>$xnY8m\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003B,a\u000b\u0016k\u0011\u0001\u0017\u0006\u0003+fS!AW.\u0002\u000f\rd\u0017.\u001a8ug*\u0011\u0001\u0004\u0018\u0006\u0003;z\u000ba!\u00199bG\",'\"A0\u0002\u0007=\u0014x-\u0003\u0002b1\ni1*\u00194lCB\u0013x\u000eZ;dKJ\f\u0001c[1gW\u0006$&/Y2lKJ\u0004v\u000e\u001c7\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019<\u0012AB2mS\u0016tG/\u0003\u0002iK\n\u00012*\u00194lCR\u0013\u0018mY6feB{G\u000e\\\u0001\fgR\fGo]#oO&tW-F\u0001l!\taw.D\u0001n\u0015\tqg(A\u0003ti\u0006$8/\u0003\u0002q[\nY1\u000b^1ug\u0016sw-\u001b8f\u00031\u0019H/\u0019;t\u000b:<\u0017N\\3!\u0003\u0015\u0019Gn\\2l+\u0005!\bCA;{\u001b\u00051(BA<y\u0003\u0011)H/\u001b7\u000b\u0005e\\\u0014aB2p[6|gn]\u0005\u0003wZ\u0014Qa\u00117pG.\faa\u00197pG.\u0004\u0013\u0001\u00028fqR,\u0012a \t\u0005\u0003\u0003\t)!\u0004\u0002\u0002\u0004)\u0011aCP\u0005\u0005\u0003\u000f\t\u0019A\u0001\u0004BGRLwN\\\u0001\u0006]\u0016DH\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u0005=\u0011\u0011CA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0011q\u0004\t\u0003E\u0001AQ!\n\u0007A\u0002\u0019BQ\u0001\f\u0007A\u00025BQa\u0014\u0007A\u0002ACQ!\u0016\u0007A\u0002YCQA\u0019\u0007A\u0002\rDQ!\u001b\u0007A\u0002-DQA\u001d\u0007A\u0002QDQ! \u0007A\u0002}\fAA\\1nKV\tQ)A\u0003oC6,\u0007%\u0001\bnKN\u001c\u0018mZ3NCR\u001c\u0007.\u001a:\u0016\u0005\u0005-\u0002cA)\u0002.%\u0019\u0011q\u0006*\u0003\u0019-\u000bgm[1NCR\u001c\u0007.\u001a:\u0002\u001f5,7o]1hK6\u000bGo\u00195fe\u0002\n\u0001C]3qYf$\u0016.\\3pkRLe.T:\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003wi\u0011\u0001S\u0005\u0004\u0003{A%\u0001\u0002'p]\u001e\f\u0011C]3qYf$\u0016.\\3pkRLe.T:!\u0003)\t'o\\;oIN+g\u000e\u001a\u000b\u000b\u0003\u000b\n9&a\u0017\u0002f\u0005=\u0004CBA$\u0003\u001b\n\t&\u0004\u0002\u0002J)\u0019\u00111\n=\u0002\u0015Y\fG.\u001b3bi&|g.\u0003\u0003\u0002P\u0005%#A\u0003,bY&$\u0017\r^5p]B\u0019!%a\u0015\n\u0007\u0005USC\u0001\u0004Be>,h\u000e\u001a\u0005\u0007\u00033\u001a\u0002\u0019A#\u0002\u0017I,\u0017/^3ti:\u000bW.\u001a\u0005\u0007{M\u0001\r!!\u0018\u0011\t\u0005}\u0013\u0011M\u0007\u0002\u0003&\u0019\u00111M!\u0003\u000fM+7o]5p]\"9\u0011qM\nA\u0002\u0005%\u0014A\u00049s_\u0012,8-\u001a:SK\u000e|'\u000f\u001a\t\u0006/\u0006-T)R\u0005\u0004\u0003[B&A\u0004)s_\u0012,8-\u001a:SK\u000e|'\u000f\u001a\u0005\u0007\u0003c\u001a\u0002\u0019A#\u0002\u000bQ|\u0007/[2")
public class RequestReply
extends KafkaAction {
    private final KafkaAttributes attributes;
    private final Function1<Session, Validation<String>> replyTopic;
    private final KafkaTrackerPoll kafkaTrackerPoll;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private final Action next;
    private final String name;
    private final KafkaMatcher messageMatcher;
    private final long replyTimeoutInMs;

    public StatsEngine statsEngine() {
        return this.statsEngine;
    }

    public Clock clock() {
        return this.clock;
    }

    public Action next() {
        return this.next;
    }

    public String name() {
        return this.name;
    }

    private KafkaMatcher messageMatcher() {
        return this.messageMatcher;
    }

    private long replyTimeoutInMs() {
        return this.replyTimeoutInMs;
    }

    @Override
    public Validation<Around> aroundSend(String requestName, Session session, ProducerRecord<String, String> producerRecord, String topic) {
        return ((Validation)this.replyTopic.apply((Object)session)).map((Function1 & Serializable)resolvedReadTopic -> {
            String matchId = this.messageMatcher().requestMatchId(producerRecord);
            KafkaTracker tracker = $this.kafkaTrackerPoll.tracker((String)resolvedReadTopic, this.messageMatcher());
            return new Around((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Sent Kafka message. Topic: {} Key: {} Payload: {}", new Object[]{topic, producerRecord.key(), producerRecord.value()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (matchId != null) {
                    tracker.track(matchId, this.clock().nowMillis(), this.replyTimeoutInMs(), $this.attributes.checks(), session, this.next(), requestName);
                    return;
                }
            }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                if (matchId == null) {
                    String updatedMatchId = this.messageMatcher().requestMatchId(producerRecord);
                    if (updatedMatchId != null) {
                        tracker.track(updatedMatchId, this.clock().nowMillis(), this.replyTimeoutInMs(), $this.attributes.checks(), session, this.next(), requestName);
                        return;
                    }
                    long now = this.clock().nowMillis();
                    this.statsEngine().logResponse(session.scenario(), session.groups(), requestName, now, now, (Status)KO$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"Failed to get a matchId to track"));
                    this.next().$bang(session.markAsFailed());
                    return;
                }
            });
        });
    }

    public RequestReply(KafkaAttributes attributes, Function1<Session, Validation<String>> replyTopic, KafkaProtocol protocol, KafkaProducer<String, String> producer, KafkaTrackerPoll kafkaTrackerPoll, StatsEngine statsEngine, Clock clock, Action next) {
        this.attributes = attributes;
        this.replyTopic = replyTopic;
        this.kafkaTrackerPoll = kafkaTrackerPoll;
        this.statsEngine = statsEngine;
        this.clock = clock;
        this.next = next;
        super(attributes, protocol, producer, kafkaTrackerPoll);
        this.name = this.genName("kafkaRequestReply");
        this.messageMatcher = protocol.messageMatcher();
        this.replyTimeoutInMs = BoxesRunTime.unboxToLong((Object)protocol.replyTimeout().fold((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.toMillis())));
    }
}

