/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerousful.kafka.check;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.check.Check;
import io.gatling.core.check.CheckMaterializer;
import io.gatling.core.check.bytes.BodyBytesCheckType;
import io.gatling.core.check.jmespath.JmesPathCheckType;
import io.gatling.core.check.jsonpath.JsonPathCheckType;
import io.gatling.core.check.regex.RegexCheckType;
import io.gatling.core.check.string.BodyStringCheckType;
import io.gatling.core.check.substring.SubstringCheckType;
import io.gatling.core.check.xpath.XPathCheckType;
import io.gatling.core.check.xpath.XmlParsers$;
import io.gatling.core.json.JsonParsers;
import io.github.amerousful.kafka.check.KafkaCheckMaterializer;
import java.io.Serializable;
import java.nio.charset.Charset;
import net.sf.saxon.s9api.XdmNode;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxesRunTime;

public final class KafkaCheckMaterializer$ {
    public static final KafkaCheckMaterializer$ MODULE$ = new KafkaCheckMaterializer$();
    private static final Function1<String, String> JsonPreparerErrorMapper = (Function1 & Serializable)x$1 -> new StringBuilder(38).append("Could not parse response into a JSON: ").append((String)x$1).toString();
    private static final CheckMaterializer<XPathCheckType, Check<ConsumerRecord<String, String>>, ConsumerRecord<String, String>, XdmNode> Xpath;
    private static final CheckMaterializer<RegexCheckType, Check<ConsumerRecord<String, String>>, ConsumerRecord<String, String>, String> Regex;

    static {
        Function1 & Serializable errorMapper = (Function1 & Serializable)x$2 -> new StringBuilder(46).append("Could not parse response into a DOM Document: ").append((String)x$2).toString();
        Function1 & Serializable preparer = (Function1 & Serializable)message -> package$.MODULE$.safely(errorMapper, (Function0 & Serializable)() -> package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)XmlParsers$.MODULE$.parse((String)message.value()))));
        Xpath = new KafkaCheckMaterializer<XPathCheckType, XdmNode>(preparer);
        Regex = new KafkaCheckMaterializer<RegexCheckType, String>(MODULE$.stringBodyPreparer());
    }

    private Function1<ConsumerRecord<String, String>, Validation<String>> stringBodyPreparer() {
        return (Function1 & Serializable)message -> package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(message.value()));
    }

    private Function1<ConsumerRecord<String, String>, Validation<Object>> bodyLengthPreparer() {
        return (Function1 & Serializable)message -> package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)BoxesRunTime.boxToInteger((int)((String)message.value()).length())));
    }

    private Function1<ConsumerRecord<String, String>, Validation<byte[]>> bodyBytesPreparer(Charset charset) {
        return (Function1 & Serializable)message -> package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)((String)message.value()).getBytes(charset)));
    }

    private Function1<String, String> JsonPreparerErrorMapper() {
        return JsonPreparerErrorMapper;
    }

    private Function1<ConsumerRecord<String, String>, Validation<JsonNode>> jsonPreparer(JsonParsers jsonParsers) {
        return (Function1 & Serializable)message -> package$.MODULE$.safely(MODULE$.JsonPreparerErrorMapper(), (Function0 & Serializable)() -> jsonParsers.safeParse((String)message.value()));
    }

    public CheckMaterializer<BodyStringCheckType, Check<ConsumerRecord<String, String>>, ConsumerRecord<String, String>, String> bodyString() {
        return new KafkaCheckMaterializer<BodyStringCheckType, String>(this.stringBodyPreparer());
    }

    public CheckMaterializer<SubstringCheckType, Check<ConsumerRecord<String, String>>, ConsumerRecord<String, String>, String> substring() {
        return new KafkaCheckMaterializer<SubstringCheckType, String>(this.stringBodyPreparer());
    }

    public CheckMaterializer<BodyBytesCheckType, Check<ConsumerRecord<String, String>>, ConsumerRecord<String, String>, Object> bodyLength() {
        return new KafkaCheckMaterializer<BodyBytesCheckType, Object>(this.bodyLengthPreparer());
    }

    public CheckMaterializer<BodyBytesCheckType, Check<ConsumerRecord<String, String>>, ConsumerRecord<String, String>, byte[]> bodyBytes(Charset charset) {
        return new KafkaCheckMaterializer<BodyBytesCheckType, byte[]>(this.bodyBytesPreparer(charset));
    }

    public CheckMaterializer<JmesPathCheckType, Check<ConsumerRecord<String, String>>, ConsumerRecord<String, String>, JsonNode> jmesPath(JsonParsers jsonParsers) {
        return new KafkaCheckMaterializer<JmesPathCheckType, JsonNode>(this.jsonPreparer(jsonParsers));
    }

    public CheckMaterializer<JsonPathCheckType, Check<ConsumerRecord<String, String>>, ConsumerRecord<String, String>, JsonNode> jsonPath(JsonParsers jsonParsers) {
        return new KafkaCheckMaterializer<JsonPathCheckType, JsonNode>(this.jsonPreparer(jsonParsers));
    }

    public CheckMaterializer<XPathCheckType, Check<ConsumerRecord<String, String>>, ConsumerRecord<String, String>, XdmNode> Xpath() {
        return Xpath;
    }

    public CheckMaterializer<RegexCheckType, Check<ConsumerRecord<String, String>>, ConsumerRecord<String, String>, String> Regex() {
        return Regex;
    }

    private KafkaCheckMaterializer$() {
    }
}

