/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerousful.kafka.javaapi;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.core.protocol.Protocol;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.internal.Converters;
import io.github.amerousful.kafka.javaapi.KafkaBroker;
import io.github.amerousful.kafka.javaapi.KafkaMessageMatcher;
import io.github.amerousful.kafka.protocol.javaapi.KafkaMessageMatchers;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import scala.Enumeration;
import scala.collection.immutable.Seq;

public final class KafkaProtocolBuilder
implements ProtocolBuilder {
    private final io.github.amerousful.kafka.protocol.KafkaProtocolBuilder wrapped;

    KafkaProtocolBuilder(io.github.amerousful.kafka.protocol.KafkaProtocolBuilder kafkaProtocolBuilder) {
        this.wrapped = kafkaProtocolBuilder;
    }

    @NonNull
    public KafkaProtocolBuilder broker(KafkaBroker kafkaBroker) {
        return new KafkaProtocolBuilder(this.wrapped.broker(kafkaBroker.asScala()));
    }

    @NonNull
    public KafkaProtocolBuilder brokers(KafkaBroker ... kafkaBrokerArray) {
        List list = Arrays.stream(kafkaBrokerArray).map(KafkaBroker::asScala).collect(Collectors.toList());
        return new KafkaProtocolBuilder(this.wrapped.brokers((Seq<io.github.amerousful.kafka.protocol.KafkaBroker>)Converters.toScalaSeq(list)));
    }

    @NonNull
    public KafkaProtocolBuilder acks(@NonNull String string) {
        return new KafkaProtocolBuilder(this.wrapped.acks(string));
    }

    @NonNull
    public KafkaProtocolBuilder producerKeySerializer(@NonNull String string) {
        return new KafkaProtocolBuilder(this.wrapped.producerKeySerializer(string));
    }

    @NonNull
    public KafkaProtocolBuilder producerValueSerializer(@NonNull String string) {
        return new KafkaProtocolBuilder(this.wrapped.producerValueSerializer(string));
    }

    @NonNull
    public KafkaProtocolBuilder consumerKeyDeserializer(@NonNull String string) {
        return new KafkaProtocolBuilder(this.wrapped.consumerKeyDeserializer(string));
    }

    @NonNull
    public KafkaProtocolBuilder consumerValueDeserializer(@NonNull String string) {
        return new KafkaProtocolBuilder(this.wrapped.consumerValueDeserializer(string));
    }

    @NonNull
    public KafkaProtocolBuilder consumerIdenticalDeserializer(@NonNull String string) {
        return this.consumerKeyDeserializer(string).consumerValueDeserializer(string);
    }

    @NonNull
    public KafkaProtocolBuilder producerIdenticalSerializer(@NonNull String string) {
        return new KafkaProtocolBuilder(this.wrapped.producerIdenticalSerializer(string));
    }

    @NonNull
    public KafkaProtocolBuilder addProducerProperty(@NonNull String string, @NonNull String string2) {
        return new KafkaProtocolBuilder(this.wrapped.addProducerProperty(string, string2));
    }

    @NonNull
    public KafkaProtocolBuilder addConsumerProperty(@NonNull String string, @NonNull String string2) {
        return new KafkaProtocolBuilder(this.wrapped.addConsumerProperty(string, string2));
    }

    @NonNull
    public KafkaProtocolBuilder credentials(@NonNull String string, @NonNull String string2, boolean bl, @NonNull Enumeration.Value value) {
        return new KafkaProtocolBuilder(this.wrapped.credentials(string, string2, bl, value));
    }

    @NonNull
    public KafkaProtocolBuilder replyTimeout(long l) {
        return this.replyTimeout(Duration.ofSeconds(l));
    }

    @NonNull
    public KafkaProtocolBuilder replyTimeout(@NonNull Duration duration) {
        return new KafkaProtocolBuilder(this.wrapped.replyTimeout(Converters.toScalaDuration((Duration)duration)));
    }

    @NonNull
    public KafkaProtocolBuilder messageMatcher(@NonNull KafkaMessageMatcher kafkaMessageMatcher) {
        return new KafkaProtocolBuilder(this.wrapped.messageMatcher(KafkaMessageMatchers.toScala(kafkaMessageMatcher)));
    }

    @NonNull
    public KafkaProtocolBuilder matchByKey() {
        return new KafkaProtocolBuilder(this.wrapped.matchByKey());
    }

    @NonNull
    public KafkaProtocolBuilder matchByValue() {
        return new KafkaProtocolBuilder(this.wrapped.matchByValue());
    }

    @NonNull
    public KafkaProtocolBuilder replyConsumerName(@NonNull String string) {
        return new KafkaProtocolBuilder(this.wrapped.replyConsumerName(string));
    }

    public Protocol protocol() {
        return this.wrapped.build();
    }
}

