/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerousful.kafka.action;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.stats.StatsEngine;
import io.github.amerousful.kafka.action.Around;
import io.github.amerousful.kafka.action.KafkaAction;
import io.github.amerousful.kafka.client.KafkaTracker;
import io.github.amerousful.kafka.client.KafkaTrackerPoll;
import io.github.amerousful.kafka.protocol.KafkaMatcher;
import io.github.amerousful.kafka.protocol.KafkaProtocol;
import io.github.amerousful.kafka.request.KafkaAttributes;
import java.io.Serializable;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!1\u0007A!A!\u0002\u00139\u0007\u0002C7\u0001\u0005\u000b\u0007I\u0011\u00018\t\u0011U\u0004!\u0011!Q\u0001\n=D\u0001B\u001e\u0001\u0003\u0006\u0004%\ta\u001e\u0005\n\u0003\u0003\u0001!\u0011!Q\u0001\naD!\"a\u0001\u0001\u0005\u000b\u0007I\u0011AA\u0003\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u0011q\u0001\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011%\tI\u0003\u0001b\u0001\n\u0003\nY\u0003C\u0004\u0002.\u0001\u0001\u000b\u0011B#\t\u0013\u0005=\u0002A1A\u0005\n\u0005E\u0002\u0002CA\u001d\u0001\u0001\u0006I!a\r\t\u0013\u0005m\u0002A1A\u0005\n\u0005u\u0002\u0002CA#\u0001\u0001\u0006I!a\u0010\t\u000f\u0005\u001d\u0003\u0001\"\u0015\u0002J\ta!+Z9vKN$(+\u001a9ms*\u0011acF\u0001\u0007C\u000e$\u0018n\u001c8\u000b\u0005aI\u0012!B6bM.\f'B\u0001\u000e\u001c\u0003)\tW.\u001a:pkN4W\u000f\u001c\u0006\u00039u\taaZ5uQV\u0014'\"\u0001\u0010\u0002\u0005%|7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0012\u000e\u0003UI!\u0001J\u000b\u0003\u0017-\u000bgm[1BGRLwN\\\u0001\u000bCR$(/\u001b2vi\u0016\u001c\bCA\u0014+\u001b\u0005A#BA\u0015\u0018\u0003\u001d\u0011X-];fgRL!a\u000b\u0015\u0003\u001f-\u000bgm[1BiR\u0014\u0018NY;uKN\f!B]3qYf$v\u000e]5d!\rq#)\u0012\b\u0003_}r!\u0001\r\u001f\u000f\u0005EJdB\u0001\u001a8\u001d\t\u0019d'D\u00015\u0015\t)t$\u0001\u0004=e>|GOP\u0005\u0002=%\u0011\u0001(H\u0001\bO\u0006$H.\u001b8h\u0013\tQ4(\u0001\u0003d_J,'B\u0001\u001d\u001e\u0013\tid(A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005iZ\u0014B\u0001!B\u0003\u001d\u0001\u0018mY6bO\u0016T!!\u0010 \n\u0005\r#%AC#yaJ,7o]5p]*\u0011\u0001)\u0011\t\u0003\r2s!a\u0012&\u0011\u0005MB%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C\u0015A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!a\u0013%\u0002\u0011A\u0014x\u000e^8d_2\u0004\"!U*\u000e\u0003IS!aT\f\n\u0005Q\u0013&!D&bM.\f\u0007K]8u_\u000e|G.\u0001\u0005qe>$WoY3s!\u00119\u0006-\u00122\u000e\u0003aS!!V-\u000b\u0005i[\u0016aB2mS\u0016tGo\u001d\u0006\u00031qS!!\u00180\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0016aA8sO&\u0011\u0011\r\u0017\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u0005\r$W\"\u0001%\n\u0005\u0015D%aA!os\u0006\u00012.\u00194lCR\u0013\u0018mY6feB{G\u000e\u001c\t\u0003Q.l\u0011!\u001b\u0006\u0003U^\taa\u00197jK:$\u0018B\u00017j\u0005AY\u0015MZ6b)J\f7m[3s!>dG.A\u0006ti\u0006$8/\u00128hS:,W#A8\u0011\u0005A\u001cX\"A9\u000b\u0005It\u0014!B:uCR\u001c\u0018B\u0001;r\u0005-\u0019F/\u0019;t\u000b:<\u0017N\\3\u0002\u0019M$\u0018\r^:F]\u001eLg.\u001a\u0011\u0002\u000b\rdwnY6\u0016\u0003a\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\tU$\u0018\u000e\u001c\u0006\u0003{n\nqaY8n[>t7/\u0003\u0002\u0000u\n)1\t\\8dW\u000611\r\\8dW\u0002\nAA\\3yiV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ti!\u0004\u0002\u0002\f)\u0011aCP\u0005\u0005\u0003\u001f\tYA\u0001\u0004BGRLwN\\\u0001\u0006]\u0016DH\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u0005]\u0011\u0011DA\u000e\u0003;\ty\"!\t\u0002$\u0005\u0015\u0012q\u0005\t\u0003E\u0001AQ!\n\u0007A\u0002\u0019BQ\u0001\f\u0007A\u00025BQa\u0014\u0007A\u0002ACQ!\u0016\u0007A\u0002YCQA\u001a\u0007A\u0002\u001dDQ!\u001c\u0007A\u0002=DQA\u001e\u0007A\u0002aDq!a\u0001\r\u0001\u0004\t9!\u0001\u0003oC6,W#A#\u0002\u000b9\fW.\u001a\u0011\u0002\u001d5,7o]1hK6\u000bGo\u00195feV\u0011\u00111\u0007\t\u0004#\u0006U\u0012bAA\u001c%\na1*\u00194lC6\u000bGo\u00195fe\u0006yQ.Z:tC\u001e,W*\u0019;dQ\u0016\u0014\b%\u0001\tsKBd\u0017\u0010V5nK>,H/\u00138NgV\u0011\u0011q\b\t\u0004G\u0006\u0005\u0013bAA\"\u0011\n!Aj\u001c8h\u0003E\u0011X\r\u001d7z)&lWm\\;u\u0013:l5\u000fI\u0001\u000bCJ|WO\u001c3TK:$GCCA&\u0003;\n\t'a\u001b\u0002vA1\u0011QJA*\u0003/j!!a\u0014\u000b\u0007\u0005EC0\u0001\u0006wC2LG-\u0019;j_:LA!!\u0016\u0002P\tQa+\u00197jI\u0006$\u0018n\u001c8\u0011\u0007\t\nI&C\u0002\u0002\\U\u0011a!\u0011:pk:$\u0007BBA0'\u0001\u0007Q)A\u0006sKF,Xm\u001d;OC6,\u0007BB\u001f\u0014\u0001\u0004\t\u0019\u0007\u0005\u0003\u0002f\u0005\u001dT\"A!\n\u0007\u0005%\u0014IA\u0004TKN\u001c\u0018n\u001c8\t\u000f\u000554\u00031\u0001\u0002p\u0005q\u0001O]8ek\u000e,'OU3d_J$\u0007#B,\u0002r\u0015\u0013\u0017bAA:1\nq\u0001K]8ek\u000e,'OU3d_J$\u0007BBA<'\u0001\u0007Q)A\u0003u_BL7\r")
public class RequestReply
extends KafkaAction {
    private final KafkaAttributes attributes;
    private final Function1<Session, Validation<String>> replyTopic;
    private final KafkaTrackerPoll kafkaTrackerPoll;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private final Action next;
    private final String name;
    private final KafkaMatcher messageMatcher;
    private final long replyTimeoutInMs;

    public StatsEngine statsEngine() {
        return this.statsEngine;
    }

    public Clock clock() {
        return this.clock;
    }

    public Action next() {
        return this.next;
    }

    public String name() {
        return this.name;
    }

    private KafkaMatcher messageMatcher() {
        return this.messageMatcher;
    }

    private long replyTimeoutInMs() {
        return this.replyTimeoutInMs;
    }

    @Override
    public Validation<Around> aroundSend(String requestName, Session session, ProducerRecord<String, Object> producerRecord, String topic) {
        return ((Validation)this.replyTopic.apply((Object)session)).map((Function1 & Serializable)resolvedReadTopic -> {
            Object matchId = this.messageMatcher().requestMatchId(producerRecord);
            KafkaTracker tracker = $this.kafkaTrackerPoll.tracker((String)resolvedReadTopic, this.messageMatcher(), $this.attributes);
            return new Around((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Sent Kafka message. Topic: {} Key: {} Payload: {}", new Object[]{topic, producerRecord.key(), producerRecord.value()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (matchId != null) {
                    tracker.track(matchId, this.clock().nowMillis(), this.replyTimeoutInMs(), $this.attributes.checks(), session, this.next(), requestName);
                    return;
                }
            }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                if (matchId == null) {
                    Object updatedMatchId = this.messageMatcher().requestMatchId(producerRecord);
                    if (updatedMatchId != null) {
                        tracker.track(updatedMatchId, this.clock().nowMillis(), this.replyTimeoutInMs(), $this.attributes.checks(), session, this.next(), requestName);
                        return;
                    }
                    long now = this.clock().nowMillis();
                    this.statsEngine().logResponse(session.scenario(), session.groups(), requestName, now, now, (Status)KO$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"Failed to get a matchId to track"));
                    this.next().$bang(session.markAsFailed());
                    return;
                }
            });
        });
    }

    public RequestReply(KafkaAttributes attributes, Function1<Session, Validation<String>> replyTopic, KafkaProtocol protocol, KafkaProducer<String, Object> producer, KafkaTrackerPoll kafkaTrackerPoll, StatsEngine statsEngine, Clock clock, Action next) {
        this.attributes = attributes;
        this.replyTopic = replyTopic;
        this.kafkaTrackerPoll = kafkaTrackerPoll;
        this.statsEngine = statsEngine;
        this.clock = clock;
        this.next = next;
        super(attributes, protocol, producer, kafkaTrackerPoll);
        this.name = this.genName("kafkaRequestReply");
        this.messageMatcher = protocol.messageMatcher();
        this.replyTimeoutInMs = BoxesRunTime.unboxToLong((Object)protocol.replyTimeout().fold((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.toMillis())));
    }
}

