/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerousful.kafka.javaapi;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.core.protocol.Protocol;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.internal.Converters;
import io.github.amerousful.kafka.javaapi.KafkaBroker;
import io.github.amerousful.kafka.javaapi.KafkaMessageMatcher;
import io.github.amerousful.kafka.protocol.javaapi.KafkaMessageMatchers;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import scala.Enumeration;
import scala.collection.immutable.Seq;

public final class KafkaProtocolBuilder
implements ProtocolBuilder {
    private final io.github.amerousful.kafka.protocol.KafkaProtocolBuilder wrapped;

    KafkaProtocolBuilder(io.github.amerousful.kafka.protocol.KafkaProtocolBuilder wrapped) {
        this.wrapped = wrapped;
    }

    @NonNull
    public KafkaProtocolBuilder broker(KafkaBroker broker) {
        return new KafkaProtocolBuilder(this.wrapped.broker(broker.asScala()));
    }

    @NonNull
    public KafkaProtocolBuilder brokers(KafkaBroker ... brokers) {
        List listOfBrokersAsScala = Arrays.stream(brokers).map(KafkaBroker::asScala).collect(Collectors.toList());
        return new KafkaProtocolBuilder(this.wrapped.brokers((Seq<io.github.amerousful.kafka.protocol.KafkaBroker>)Converters.toScalaSeq(listOfBrokersAsScala)));
    }

    @NonNull
    public KafkaProtocolBuilder acks(@NonNull String acks) {
        return new KafkaProtocolBuilder(this.wrapped.acks(acks));
    }

    @NonNull
    public KafkaProtocolBuilder producerKeySerializer(@NonNull String serializer) {
        return new KafkaProtocolBuilder(this.wrapped.producerKeySerializer(serializer));
    }

    @NonNull
    public KafkaProtocolBuilder producerValueSerializer(@NonNull String serializer) {
        return new KafkaProtocolBuilder(this.wrapped.producerValueSerializer(serializer));
    }

    @NonNull
    public KafkaProtocolBuilder consumerKeyDeserializer(@NonNull String deserializer) {
        return new KafkaProtocolBuilder(this.wrapped.consumerKeyDeserializer(deserializer));
    }

    @NonNull
    public KafkaProtocolBuilder consumerValueDeserializer(@NonNull String deserializer) {
        return new KafkaProtocolBuilder(this.wrapped.consumerValueDeserializer(deserializer));
    }

    @NonNull
    public KafkaProtocolBuilder consumerIdenticalDeserializer(@NonNull String deserializer) {
        return this.consumerKeyDeserializer(deserializer).consumerValueDeserializer(deserializer);
    }

    @NonNull
    public KafkaProtocolBuilder producerIdenticalSerializer(@NonNull String serializer) {
        return new KafkaProtocolBuilder(this.wrapped.producerIdenticalSerializer(serializer));
    }

    @NonNull
    public KafkaProtocolBuilder addProducerProperty(@NonNull String key, @NonNull String value) {
        return new KafkaProtocolBuilder(this.wrapped.addProducerProperty(key, value));
    }

    @NonNull
    public KafkaProtocolBuilder addConsumerProperty(@NonNull String key, @NonNull String value) {
        return new KafkaProtocolBuilder(this.wrapped.addConsumerProperty(key, value));
    }

    @NonNull
    public KafkaProtocolBuilder credentials(@NonNull String username, @NonNull String password, boolean sslEnabled, @NonNull Enumeration.Value saslMechanism) {
        return new KafkaProtocolBuilder(this.wrapped.credentials(username, password, sslEnabled, saslMechanism));
    }

    @NonNull
    public KafkaProtocolBuilder replyTimeout(long timeout) {
        return this.replyTimeout(Duration.ofSeconds(timeout));
    }

    @NonNull
    public KafkaProtocolBuilder replyTimeout(@NonNull Duration timeout) {
        return new KafkaProtocolBuilder(this.wrapped.replyTimeout(Converters.toScalaDuration((Duration)timeout)));
    }

    @NonNull
    public KafkaProtocolBuilder messageMatcher(@NonNull KafkaMessageMatcher matcher) {
        return new KafkaProtocolBuilder(this.wrapped.messageMatcher(KafkaMessageMatchers.toScala(matcher)));
    }

    @NonNull
    public KafkaProtocolBuilder matchByKey() {
        return new KafkaProtocolBuilder(this.wrapped.matchByKey());
    }

    @NonNull
    public KafkaProtocolBuilder matchByValue() {
        return new KafkaProtocolBuilder(this.wrapped.matchByValue());
    }

    @NonNull
    public KafkaProtocolBuilder replyConsumerName(@NonNull String name) {
        return new KafkaProtocolBuilder(this.wrapped.replyConsumerName(name));
    }

    @NonNull
    public KafkaProtocolBuilder schemaUrl(@NonNull String url) {
        return new KafkaProtocolBuilder(this.wrapped.schemaUrl(url));
    }

    public Protocol protocol() {
        return this.wrapped.build();
    }
}

