/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerousful.kafka.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.ClassicActorSystemProvider;
import akka.kafka.AutoSubscription;
import akka.kafka.ConsumerSettings;
import akka.kafka.ConsumerSettings$;
import akka.kafka.Subscription;
import akka.kafka.Subscriptions$;
import akka.kafka.scaladsl.Consumer;
import akka.kafka.scaladsl.Consumer$;
import akka.kafka.scaladsl.PartitionAssignmentHandler;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.Materializer$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.util.NameGen;
import io.github.amerousful.kafka.action.KafkaLogging;
import io.github.amerousful.kafka.client.KafkaTracker;
import io.github.amerousful.kafka.client.MessageReceived;
import io.github.amerousful.kafka.client.Tracker$;
import io.github.amerousful.kafka.client.TrackerAndController;
import io.github.amerousful.kafka.client.WaitRebalancing;
import io.github.amerousful.kafka.protocol.KafkaMatcher;
import io.github.amerousful.kafka.request.KafkaAttributes;
import io.github.amerousful.kafka.request.ProtoAttributes;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u001d9\u0007A1A\u0005\n!Da!\u001e\u0001!\u0002\u0013I\u0007b\u0002<\u0001\u0005\u0004%Ia\u001e\u0005\u0007w\u0002\u0001\u000b\u0011\u0002=\t\u000fq\u0004!\u0019!C\u0005{\"9\u0011\u0011\u0003\u0001!\u0002\u0013q\bBCA\n\u0001!\u0015\r\u0011b\u0003\u0002\u0016!Q\u0011q\u0003\u0001\t\u0006\u0004%Y!!\u0007\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111\u0007\u0005\b\u0003k\u0001\u0001\u0015!\u0003:\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI\u0004\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA\u001e\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001bBq!a0\u0001\t\u0003\t\tM\u0001\tLC\u001a\\\u0017\r\u0016:bG.,'\u000fU8mY*\u0011q\u0003G\u0001\u0007G2LWM\u001c;\u000b\u0005eQ\u0012!B6bM.\f'BA\u000e\u001d\u0003)\tW.\u001a:pkN4W\u000f\u001c\u0006\u0003;y\taaZ5uQV\u0014'\"A\u0010\u0002\u0005%|7\u0001A\n\u0005\u0001\tBc\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S1j\u0011A\u000b\u0006\u0003Wa\ta!Y2uS>t\u0017BA\u0017+\u00051Y\u0015MZ6b\u0019><w-\u001b8h!\tyc'D\u00011\u0015\t\t$'\u0001\u0003vi&d'BA\u001a5\u0003\u0011\u0019wN]3\u000b\u0005Ur\u0012aB4bi2LgnZ\u0005\u0003oA\u0012qAT1nK\u001e+g.\u0001\nd_:\u001cX/\\3s!J|\u0007/\u001a:uS\u0016\u001c\b\u0003\u0002\u001eB\t\nr!aO \u0011\u0005q\"S\"A\u001f\u000b\u0005y\u0002\u0013A\u0002\u001fs_>$h(\u0003\u0002AI\u00051\u0001K]3eK\u001aL!AQ\"\u0003\u00075\u000b\u0007O\u0003\u0002AIA\u0011!(R\u0005\u0003\r\u000e\u0013aa\u0015;sS:<\u0017AB:zgR,W\u000e\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006)\u0011m\u0019;pe*\tQ*\u0001\u0003bW.\f\u0017BA(K\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0017M$\u0018\r^:F]\u001eLg.\u001a\t\u0003%Vk\u0011a\u0015\u0006\u0003)J\nQa\u001d;biNL!AV*\u0003\u0017M#\u0018\r^:F]\u001eLg.Z\u0001\u0006G2|7m\u001b\t\u00033vk\u0011A\u0017\u0006\u0003cmS!\u0001\u0018\u001b\u0002\u000f\r|W.\\8og&\u0011aL\u0017\u0002\u0006\u00072|7m[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0005\u001cG-\u001a4\u0011\u0005\t\u0004Q\"\u0001\f\t\u000ba*\u0001\u0019A\u001d\t\u000b\u001d+\u0001\u0019\u0001%\t\u000bA+\u0001\u0019A)\t\u000b]+\u0001\u0019\u0001-\u0002\u0011Q\u0014\u0018mY6feN,\u0012!\u001b\t\u0005UB$%/D\u0001l\u0015\taW.\u0001\u0006d_:\u001cWO\u001d:f]RT!!\r8\u000b\u0003=\fAA[1wC&\u0011\u0011o\u001b\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u00012t\u0013\t!hC\u0001\u000bUe\u0006\u001c7.\u001a:B]\u0012\u001cuN\u001c;s_2dWM]\u0001\niJ\f7m[3sg\u0002\n\u0001C]3cC2\fgnY5oO2\u000bGo\u00195\u0016\u0003a\u0004\"A[=\n\u0005i\\'AD\"pk:$Hi\\<o\u0019\u0006$8\r[\u0001\u0012e\u0016\u0014\u0017\r\\1oG&tw\rT1uG\"\u0004\u0013!\u00053jg\u0006\u0014G.\u001a'pON\u001cuN\u001c4jOV\ta\u0010E\u0002\u0000\u0003\u001bi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0007G>tg-[4\u000b\t\u0005\u001d\u0011\u0011B\u0001\tif\u0004Xm]1gK*\u0011\u00111B\u0001\u0004G>l\u0017\u0002BA\b\u0003\u0003\u0011aaQ8oM&<\u0017A\u00053jg\u0006\u0014G.\u001a'pON\u001cuN\u001c4jO\u0002\n!c]=ti\u0016l\u0017i[6b\u0007>t7/^7feV\t\u0001*\u0001\u0007nCR,'/[1mSj,'/\u0006\u0002\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"1\u000baa\u001d;sK\u0006l\u0017\u0002BA\u0013\u0003?\u0011A\"T1uKJL\u0017\r\\5{KJ\fQa\u00197pg\u0016$\"!a\u000b\u0011\u0007\r\ni#C\u0002\u00020\u0011\u0012A!\u00168ji\u0006i2m\u001c8tk6,'\u000f\u0015:pa\u0016\u0014H/[3t)J\f7m[3s!>|G.F\u0001:\u0003y\u0019wN\\:v[\u0016\u0014\bK]8qKJ$\u0018.Z:Ue\u0006\u001c7.\u001a:Q_>d\u0007%A\rue\u0006t7OZ8s[6\u000b\u0007OV1mk\u0016$vn\u0015;sS:<WCAA\u001e!\u001d\u0019\u0013QHA!\u0003\u000fJ1!a\u0010%\u0005%1UO\\2uS>t\u0017\u0007E\u0003$\u0003\u0007\"%%C\u0002\u0002F\u0011\u0012a\u0001V;qY\u0016\u0014\u0004#B\u0012\u0002D\u0011#\u0015A\u0007;sC:\u001chm\u001c:n\u001b\u0006\u0004h+\u00197vKR{7\u000b\u001e:j]\u001e\u0004\u0013AD2sK\u0006$XmQ8ogVlWM\u001d\u000b\u0007\u0003\u001f\nY+a,1\t\u0005E\u0013Q\u0011\t\t\u0003'\nI&!\u0018\u0002\u00186\u0011\u0011Q\u000b\u0006\u0005\u0003/\ny\"\u0001\u0005tG\u0006d\u0017\rZ:m\u0013\u0011\tY&!\u0016\u0003\rM{WO]2f!!\ty&a\u001d\u0002x\u0005\u0005UBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u0011\r|gn];nKJTA!a\u001a\u0002j\u000591\r\\5f]R\u001c(bA\r\u0002l)!\u0011QNA8\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011O\u0001\u0004_J<\u0017\u0002BA;\u0003C\u0012abQ8ogVlWM\u001d*fG>\u0014H\r\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\tiH\\\u0001\u0005Y\u0006tw-C\u0002G\u0003w\u0002B!a!\u0002\u00062\u0001AaCAD'\u0005\u0005\t\u0011!B\u0001\u0003\u0013\u00131a\u0018\u00132#\u0011\tY)!%\u0011\u0007\r\ni)C\u0002\u0002\u0010\u0012\u0012qAT8uQ&tw\rE\u0002$\u0003'K1!!&%\u0005\r\te.\u001f\t\u0005\u00033\u000b)K\u0004\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\u0011\t9&a(\u000b\u0005ea\u0015\u0002BAR\u0003;\u000b\u0001bQ8ogVlWM]\u0005\u0005\u0003O\u000bIKA\u0004D_:$(o\u001c7\u000b\t\u0005\r\u0016Q\u0014\u0005\u0007\u0003[\u001b\u0002\u0019\u0001#\u0002\u0013I,\u0017\r\u001a+pa&\u001c\u0007bBAY'\u0001\u0007\u00111W\u0001\u000bCR$(/\u001b2vi\u0016\u001c\b\u0003BA[\u0003wk!!a.\u000b\u0007\u0005e\u0006$A\u0004sKF,Xm\u001d;\n\t\u0005u\u0016q\u0017\u0002\u0010\u0017\u000647.Y!uiJL'-\u001e;fg\u00069AO]1dW\u0016\u0014H\u0003CAb\u0003\u0013\fY-a7\u0011\u0007\t\f)-C\u0002\u0002HZ\u0011AbS1gW\u0006$&/Y2lKJDa!!,\u0015\u0001\u0004!\u0005bBAg)\u0001\u0007\u0011qZ\u0001\u000f[\u0016\u001c8/Y4f\u001b\u0006$8\r[3s!\u0011\t\t.a6\u000e\u0005\u0005M'bAAk1\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002Z\u0006M'\u0001D&bM.\fW*\u0019;dQ\u0016\u0014\bbBAY)\u0001\u0007\u00111\u0017")
public class KafkaTrackerPoll
implements KafkaLogging,
NameGen {
    private ActorSystem systemAkkaConsumer;
    private Materializer materializer;
    private final ActorSystem system;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private final ConcurrentHashMap<String, TrackerAndController> trackers;
    private final CountDownLatch rebalancingLatch;
    private Config disableLogsConfig;
    private final scala.collection.immutable.Map<String, Object> consumerPropertiesTrackerPool;
    private final Function1<Tuple2<String, Object>, Tuple2<String, String>> transformMapValueToString;
    private Logger logger;
    private volatile byte bitmap$0;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    @Override
    public void logMessage(Function0<String> text, ProducerRecord<String, String> msg) {
        KafkaLogging.logMessage$(this, text, msg);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ConcurrentHashMap<String, TrackerAndController> trackers() {
        return this.trackers;
    }

    private CountDownLatch rebalancingLatch() {
        return this.rebalancingLatch;
    }

    private Config disableLogsConfig() {
        return this.disableLogsConfig;
    }

    private ActorSystem systemAkkaConsumer$lzycompute() {
        KafkaTrackerPoll kafkaTrackerPoll = this;
        synchronized (kafkaTrackerPoll) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.systemAkkaConsumer = ActorSystem$.MODULE$.apply("KafkaAkkaConsumer", this.disableLogsConfig());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.disableLogsConfig = null;
        return this.systemAkkaConsumer;
    }

    private ActorSystem systemAkkaConsumer() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.systemAkkaConsumer$lzycompute();
        }
        return this.systemAkkaConsumer;
    }

    private Materializer materializer$lzycompute() {
        KafkaTrackerPoll kafkaTrackerPoll = this;
        synchronized (kafkaTrackerPoll) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.materializer = Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.systemAkkaConsumer());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.materializer;
    }

    private Materializer materializer() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.materializer$lzycompute();
        }
        return this.materializer;
    }

    public void close() {
        this.trackers().values().forEach(x0$1 -> {
            TrackerAndController trackerAndController = x0$1;
            if (trackerAndController != null) {
                Consumer.Control consumerControl = trackerAndController.consumerControl();
                consumerControl.shutdown();
                return;
            }
            throw new MatchError((Object)trackerAndController);
        });
    }

    private scala.collection.immutable.Map<String, Object> consumerPropertiesTrackerPool() {
        return this.consumerPropertiesTrackerPool;
    }

    private Function1<Tuple2<String, Object>, Tuple2<String, String>> transformMapValueToString() {
        return this.transformMapValueToString;
    }

    private Source<ConsumerRecord<String, Object>, Consumer.Control> createConsumer(String readTopic, KafkaAttributes attributes) {
        BoxedUnit boxedUnit;
        Deserializer deserializer;
        BoxedUnit boxedUnit2;
        scala.collection.immutable.Map properties = (scala.collection.immutable.Map)this.consumerPropertiesTrackerPool().map(this.transformMapValueToString());
        String consumerName = (String)properties.apply((Object)"group.id");
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Create consumer - {}", (Object)consumerName);
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Config kafkaConfig = this.systemAkkaConsumer().settings().config().getConfig("akka.kafka.consumer");
        Option<ProtoAttributes> option = attributes.protoAttributes();
        if (option instanceof Some) {
            BoxedUnit boxedUnit3;
            Some some = (Some)option;
            ProtoAttributes protoAttribute = (ProtoAttributes)some.value();
            java.util.Map updatedMap = CollectionConverters$.MODULE$.MapHasAsJava((Map)properties.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specific.protobuf.value.type"), protoAttribute.javaPBClazz())})))).asJava();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Protobuf deserializer {} | specific.protobuf.value.type: {}", new Object[]{protoAttribute.valueDeserializer().getClass().getSimpleName(), protoAttribute.javaPBClazz()});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            protoAttribute.valueDeserializer().configure(updatedMap, false);
            deserializer = protoAttribute.valueDeserializer();
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit4;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Default String deserializer");
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            deserializer = new Deserializer();
        } else {
            throw new MatchError(option);
        }
        Deserializer deserializer2 = deserializer;
        String consProps = ((IterableOnceOps)properties.map((Function1 & Serializable)i -> new StringBuilder(2).append(i._1()).append(": ").append(i._2()).toString())).mkString("\n");
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("[{}] Consumer properties:\n{}\n", new Object[]{consumerName, consProps});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ConsumerSettings consumerSettings = ConsumerSettings$.MODULE$.apply(kafkaConfig, (Deserializer)new StringDeserializer(), deserializer2).withProperties(properties);
        AutoSubscription subscription = Subscriptions$.MODULE$.topics((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{readTopic})).withPartitionAssignmentHandler((PartitionAssignmentHandler)new WaitRebalancing(consumerName, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.rebalancingLatch().countDown()));
        return Consumer$.MODULE$.plainSource(consumerSettings, (Subscription)subscription);
    }

    public KafkaTracker tracker(String readTopic, KafkaMatcher messageMatcher, KafkaAttributes attributes) {
        return this.trackers().computeIfAbsent(readTopic, x$1 -> {
            ActorRef actor = $this.system.actorOf(Tracker$.MODULE$.props($this.statsEngine, $this.clock), this.genName("kafkaTrackerActor"));
            Source<ConsumerRecord<String, Object>, Consumer.Control> consumer = this.createConsumer(readTopic, attributes);
            Tuple2 tuple2 = (Tuple2)consumer.toMat((Graph)Sink$.MODULE$.foreach((Function1 & Serializable)record -> {
                KafkaTrackerPoll.$anonfun$tracker$2(this, messageMatcher, actor, record);
                return BoxedUnit.UNIT;
            }), Keep$.MODULE$.both()).run(this.materializer());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Consumer.Control consumerControl = (Consumer.Control)tuple2._1();
            Future streamComplete = (Future)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)consumerControl, (Object)streamComplete);
            Consumer.Control consumerControl2 = (Consumer.Control)tuple22._1();
            Future streamComplete2 = (Future)tuple22._2();
            streamComplete2.onComplete((Function1 & Serializable)x$3 -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Kafka akka consumer stream has been completed.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.systemAkkaConsumer().terminate();
            }, ExecutionContext.Implicits$.MODULE$.global());
            this.rebalancingLatch().await();
            return new TrackerAndController(new KafkaTracker(actor), consumerControl2);
        }).kafkaTracker();
    }

    public static final /* synthetic */ void $anonfun$tracker$2(KafkaTrackerPoll $this, KafkaMatcher messageMatcher$1, ActorRef actor$1, ConsumerRecord record) {
        BoxedUnit boxedUnit;
        Object matchId = messageMatcher$1.responseMatchId(record);
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Received Kafka message. Key: {} Payload: {}. With matchId - {}", new Object[]{record.key(), record.value(), matchId});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MessageReceived x$1 = new MessageReceived(matchId, $this.clock.nowMillis(), record);
        ActorRef x$2 = actor$1.$bang$default$2((Object)x$1);
        actor$1.$bang((Object)x$1, x$2);
    }

    public KafkaTrackerPoll(scala.collection.immutable.Map<String, Object> consumerProperties, ActorSystem system, StatsEngine statsEngine, Clock clock) {
        this.system = system;
        this.statsEngine = statsEngine;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        KafkaLogging.$init$(this);
        NameGen.$init$((NameGen)this);
        this.trackers = new ConcurrentHashMap();
        this.rebalancingLatch = new CountDownLatch(1);
        String configString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | akka {\n        |   loglevel = \"OFF\"\n        | }\n        "));
        Config config = ConfigFactory.parseString((String)configString);
        this.disableLogsConfig = ConfigFactory.load((Config)config);
        this.consumerPropertiesTrackerPool = (scala.collection.immutable.Map)((scala.collection.immutable.MapOps)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"enable.auto.commit"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"auto.offset.reset"), (Object)"latest")}))).$plus$plus(consumerProperties)).updatedWith((Object)"group.id", (Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return new Some((Object)new StringBuilder(13).append("gatling-test-").append(UUID.randomUUID()).toString());
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Object value = some.value();
                return new Some(value);
            }
            throw new MatchError((Object)option);
        });
        this.transformMapValueToString = (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof String) {
                    String string = (String)value;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)string);
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.toString());
            }
            throw new MatchError((Object)tuple2);
        };
        Statics.releaseFence();
    }
}

