/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerousful.kafka.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.ClassicActorSystemProvider;
import akka.kafka.AutoSubscription;
import akka.kafka.ConsumerSettings;
import akka.kafka.ConsumerSettings$;
import akka.kafka.Subscription;
import akka.kafka.Subscriptions$;
import akka.kafka.scaladsl.Consumer;
import akka.kafka.scaladsl.Consumer$;
import akka.kafka.scaladsl.PartitionAssignmentHandler;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.Materializer$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.util.NameGen;
import io.github.amerousful.kafka.action.KafkaLogging;
import io.github.amerousful.kafka.client.KafkaTracker;
import io.github.amerousful.kafka.client.MessageReceived;
import io.github.amerousful.kafka.client.Tracker$;
import io.github.amerousful.kafka.client.TrackerAndController;
import io.github.amerousful.kafka.client.WaitRebalancing;
import io.github.amerousful.kafka.protocol.KafkaMatcher;
import io.github.amerousful.kafka.request.KafkaAttributes;
import io.github.amerousful.kafka.request.ProtoAttributes;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u001d1\u0007A1A\u0005\n\u001dDa\u0001\u001e\u0001!\u0002\u0013A\u0007bB;\u0001\u0005\u0004%IA\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B<\t\u000fm\u0004!\u0019!C\u0005y\"9\u0011q\u0002\u0001!\u0002\u0013i\bBCA\t\u0001!\u0015\r\u0011b\u0003\u0002\u0014!Q\u0011Q\u0003\u0001\t\u0006\u0004%Y!a\u0006\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011q\u0006\u0001\u0005\n\u0005E\u0002\"CA\u001a\u0001\t\u0007I\u0011BA\u001b\u0011!\t)\u0005\u0001Q\u0001\n\u0005]\u0002bBA$\u0001\u0011%\u0011\u0011\n\u0005\b\u0003w\u0003A\u0011AA_\u0005AY\u0015MZ6b)J\f7m[3s!>dGN\u0003\u0002\u0017/\u000511\r\\5f]RT!\u0001G\r\u0002\u000b-\fgm[1\u000b\u0005iY\u0012AC1nKJ|Wo\u001d4vY*\u0011A$H\u0001\u0007O&$\b.\u001e2\u000b\u0003y\t!![8\u0004\u0001M!\u0001!I\u0014.!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001fK\u0007\u0002S)\u0011!fF\u0001\u0007C\u000e$\u0018n\u001c8\n\u00051J#\u0001D&bM.\fGj\\4hS:<\u0007C\u0001\u00186\u001b\u0005y#B\u0001\u00192\u0003\u0011)H/\u001b7\u000b\u0005I\u001a\u0014\u0001B2pe\u0016T!\u0001N\u000f\u0002\u000f\u001d\fG\u000f\\5oO&\u0011ag\f\u0002\b\u001d\u0006lWmR3o\u0003I\u0019wN\\:v[\u0016\u0014\bK]8qKJ$\u0018.Z:\u0011\te\u00025)\t\b\u0003uy\u0002\"aO\u0012\u000e\u0003qR!!P\u0010\u0002\rq\u0012xn\u001c;?\u0013\ty4%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0003\n\u00131!T1q\u0015\ty4\u0005\u0005\u0002:\t&\u0011QI\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002\rML8\u000f^3n!\tAU*D\u0001J\u0015\tQ5*A\u0003bGR|'OC\u0001M\u0003\u0011\t7n[1\n\u00059K%aC!di>\u00148+_:uK6\f1b\u001d;biN,enZ5oKB\u0011\u0011\u000bV\u0007\u0002%*\u00111+M\u0001\u0006gR\fGo]\u0005\u0003+J\u00131b\u0015;biN,enZ5oK\u0006)1\r\\8dWB\u0011\u0001\fX\u0007\u00023*\u0011\u0001G\u0017\u0006\u00037N\nqaY8n[>t7/\u0003\u0002^3\n)1\t\\8dW\u00061A(\u001b8jiz\"R\u0001\u00192dI\u0016\u0004\"!\u0019\u0001\u000e\u0003UAQaN\u0003A\u0002aBQAR\u0003A\u0002\u001dCQaT\u0003A\u0002ACQAV\u0003A\u0002]\u000b\u0001\u0002\u001e:bG.,'o]\u000b\u0002QB!\u0011n\\\"r\u001b\u0005Q'BA6m\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003a5T\u0011A\\\u0001\u0005U\u00064\u0018-\u0003\u0002qU\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005\u0005\u0014\u0018BA:\u0016\u0005Q!&/Y2lKJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0006IAO]1dW\u0016\u00148\u000fI\u0001\u0011e\u0016\u0014\u0017\r\\1oG&tw\rT1uG\",\u0012a\u001e\t\u0003SbL!!\u001f6\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\u0006\t\"/\u001a2bY\u0006t7-\u001b8h\u0019\u0006$8\r\u001b\u0011\u0002#\u0011L7/\u00192mK2{wm]\"p]\u001aLw-F\u0001~!\rq\u00181B\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0019\u0019wN\u001c4jO*!\u0011QAA\u0004\u0003!!\u0018\u0010]3tC\u001a,'BAA\u0005\u0003\r\u0019w.\\\u0005\u0004\u0003\u001by(AB\"p]\u001aLw-\u0001\neSN\f'\r\\3M_\u001e\u001c8i\u001c8gS\u001e\u0004\u0013AE:zgR,W.Q6lC\u000e{gn];nKJ,\u0012aR\u0001\r[\u0006$XM]5bY&TXM]\u000b\u0003\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?Y\u0015AB:ue\u0016\fW.\u0003\u0003\u0002$\u0005u!\u0001D'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018!B2m_N,GCAA\u0015!\r\u0011\u00131F\u0005\u0004\u0003[\u0019#\u0001B+oSR\fQdY8ogVlWM\u001d)s_B,'\u000f^5fgR\u0013\u0018mY6feB{w\u000e\\\u000b\u0002q\u0005IBO]1og\u001a|'/\\'baZ\u000bG.^3U_N#(/\u001b8h+\t\t9\u0004E\u0004#\u0003s\ti$a\u0011\n\u0007\u0005m2EA\u0005Gk:\u001cG/[8ocA)!%a\u0010DC%\u0019\u0011\u0011I\u0012\u0003\rQ+\b\u000f\\33!\u0015\u0011\u0013qH\"D\u0003i!(/\u00198tM>\u0014X.T1q-\u0006dW/\u001a+p'R\u0014\u0018N\\4!\u00039\u0019'/Z1uK\u000e{gn];nKJ$b!a\u0013\u0002(\u0006-\u0006\u0007BA'\u0003\u0003\u0003\u0002\"a\u0014\u0002V\u0005e\u00131S\u0007\u0003\u0003#RA!a\u0015\u0002\u001e\u0005A1oY1mC\u0012\u001cH.\u0003\u0003\u0002X\u0005E#AB*pkJ\u001cW\r\u0005\u0005\u0002\\\u0005=\u00141OA?\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014\u0001C2p]N,X.\u001a:\u000b\t\u0005\r\u0014QM\u0001\bG2LWM\u001c;t\u0015\rA\u0012q\r\u0006\u0005\u0003S\nY'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003[\n1a\u001c:h\u0013\u0011\t\t(!\u0018\u0003\u001d\r{gn];nKJ\u0014VmY8sIB!\u0011QOA>\u001b\t\t9HC\u0002\u0002z5\fA\u0001\\1oO&\u0019Q)a\u001e\u0011\t\u0005}\u0014\u0011\u0011\u0007\u0001\t-\t\u0019IEA\u0001\u0002\u0003\u0015\t!!\"\u0003\u0007}#\u0013'\u0005\u0003\u0002\b\u00065\u0005c\u0001\u0012\u0002\n&\u0019\u00111R\u0012\u0003\u000f9{G\u000f[5oOB\u0019!%a$\n\u0007\u0005E5EA\u0002B]f\u0004B!!&\u0002\":!\u0011qSAO\u001b\t\tIJ\u0003\u0003\u0002T\u0005m%B\u0001\rL\u0013\u0011\ty*!'\u0002\u0011\r{gn];nKJLA!a)\u0002&\n91i\u001c8ue>d'\u0002BAP\u00033Ca!!+\u0013\u0001\u0004\u0019\u0015!\u0003:fC\u0012$v\u000e]5d\u0011\u001d\tiK\u0005a\u0001\u0003_\u000b!\"\u0019;ue&\u0014W\u000f^3t!\u0011\t\t,a.\u000e\u0005\u0005M&bAA[/\u00059!/Z9vKN$\u0018\u0002BA]\u0003g\u0013qbS1gW\u0006\fE\u000f\u001e:jEV$Xm]\u0001\biJ\f7m[3s)!\ty,!2\u0002H\u0006]\u0007cA1\u0002B&\u0019\u00111Y\u000b\u0003\u0019-\u000bgm[1Ue\u0006\u001c7.\u001a:\t\r\u0005%6\u00031\u0001D\u0011\u001d\tIm\u0005a\u0001\u0003\u0017\fa\"\\3tg\u0006<W-T1uG\",'\u000f\u0005\u0003\u0002N\u0006MWBAAh\u0015\r\t\tnF\u0001\taJ|Go\\2pY&!\u0011Q[Ah\u00051Y\u0015MZ6b\u001b\u0006$8\r[3s\u0011\u001d\tik\u0005a\u0001\u0003_\u0003")
public class KafkaTrackerPoll
implements KafkaLogging,
NameGen {
    private ActorSystem systemAkkaConsumer;
    private Materializer materializer;
    private final scala.collection.immutable.Map<String, Object> consumerProperties;
    private final ActorSystem system;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private final ConcurrentHashMap<String, TrackerAndController> trackers;
    private final CountDownLatch rebalancingLatch;
    private Config disableLogsConfig;
    private final Function1<Tuple2<String, Object>, Tuple2<String, String>> transformMapValueToString;
    private Logger logger;
    private volatile byte bitmap$0;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    @Override
    public void logMessage(Function0<String> text, ProducerRecord<String, String> msg) {
        KafkaLogging.logMessage$(this, text, msg);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ConcurrentHashMap<String, TrackerAndController> trackers() {
        return this.trackers;
    }

    private CountDownLatch rebalancingLatch() {
        return this.rebalancingLatch;
    }

    private Config disableLogsConfig() {
        return this.disableLogsConfig;
    }

    private ActorSystem systemAkkaConsumer$lzycompute() {
        KafkaTrackerPoll kafkaTrackerPoll = this;
        synchronized (kafkaTrackerPoll) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.systemAkkaConsumer = ActorSystem$.MODULE$.apply("KafkaAkkaConsumer", this.disableLogsConfig());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.disableLogsConfig = null;
        return this.systemAkkaConsumer;
    }

    private ActorSystem systemAkkaConsumer() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.systemAkkaConsumer$lzycompute();
        }
        return this.systemAkkaConsumer;
    }

    private Materializer materializer$lzycompute() {
        KafkaTrackerPoll kafkaTrackerPoll = this;
        synchronized (kafkaTrackerPoll) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.materializer = Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.systemAkkaConsumer());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.materializer;
    }

    private Materializer materializer() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.materializer$lzycompute();
        }
        return this.materializer;
    }

    public void close() {
        this.trackers().values().forEach(x0$1 -> {
            TrackerAndController trackerAndController = x0$1;
            if (trackerAndController != null) {
                Consumer.Control consumerControl = trackerAndController.consumerControl();
                consumerControl.shutdown();
                return;
            }
            throw new MatchError((Object)trackerAndController);
        });
    }

    private scala.collection.immutable.Map<String, Object> consumerPropertiesTrackerPool() {
        return (scala.collection.immutable.Map)((scala.collection.immutable.MapOps)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"enable.auto.commit"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"auto.offset.reset"), (Object)"latest")}))).$plus$plus(this.consumerProperties)).updatedWith((Object)"group.id", (Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return new Some((Object)new StringBuilder(13).append("gatling-test-").append(UUID.randomUUID()).toString());
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Object value = some.value();
                return new Some(value);
            }
            throw new MatchError((Object)option);
        });
    }

    private Function1<Tuple2<String, Object>, Tuple2<String, String>> transformMapValueToString() {
        return this.transformMapValueToString;
    }

    private Source<ConsumerRecord<String, Object>, Consumer.Control> createConsumer(String readTopic, KafkaAttributes attributes) {
        BoxedUnit boxedUnit;
        Deserializer deserializer;
        BoxedUnit boxedUnit2;
        scala.collection.immutable.Map properties = (scala.collection.immutable.Map)this.consumerPropertiesTrackerPool().map(this.transformMapValueToString());
        String consumerName = (String)properties.apply((Object)"group.id");
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Create consumer - {}", (Object)consumerName);
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Config kafkaConfig = this.systemAkkaConsumer().settings().config().getConfig("akka.kafka.consumer");
        Option<ProtoAttributes> option = attributes.protoAttributes();
        if (option instanceof Some) {
            BoxedUnit boxedUnit3;
            Some some = (Some)option;
            ProtoAttributes protoAttribute = (ProtoAttributes)some.value();
            java.util.Map updatedMap = CollectionConverters$.MODULE$.MapHasAsJava((Map)properties.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specific.protobuf.value.type"), protoAttribute.javaPBClazz())})))).asJava();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Protobuf deserializer {} | specific.protobuf.value.type: {}", new Object[]{protoAttribute.valueDeserializer().getClass().getSimpleName(), protoAttribute.javaPBClazz()});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            protoAttribute.valueDeserializer().configure(updatedMap, false);
            deserializer = protoAttribute.valueDeserializer();
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit4;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Default String deserializer");
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            deserializer = new Deserializer();
        } else {
            throw new MatchError(option);
        }
        Deserializer deserializer2 = deserializer;
        String consProps = ((IterableOnceOps)properties.map((Function1 & Serializable)i -> new StringBuilder(2).append(i._1()).append(": ").append(i._2()).toString())).mkString("\n");
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("[{}] Consumer properties:\n{}\n", new Object[]{consumerName, consProps});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ConsumerSettings consumerSettings = ConsumerSettings$.MODULE$.apply(kafkaConfig, (Deserializer)new StringDeserializer(), deserializer2).withProperties(properties);
        AutoSubscription subscription = Subscriptions$.MODULE$.topics((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{readTopic})).withPartitionAssignmentHandler((PartitionAssignmentHandler)new WaitRebalancing(consumerName, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.rebalancingLatch().countDown()));
        return Consumer$.MODULE$.plainSource(consumerSettings, (Subscription)subscription);
    }

    public KafkaTracker tracker(String readTopic, KafkaMatcher messageMatcher, KafkaAttributes attributes) {
        return this.trackers().computeIfAbsent(readTopic, x$1 -> {
            ActorRef actor = $this.system.actorOf(Tracker$.MODULE$.props($this.statsEngine, $this.clock), this.genName("kafkaTrackerActor"));
            Source<ConsumerRecord<String, Object>, Consumer.Control> consumer = this.createConsumer(readTopic, attributes);
            Tuple2 tuple2 = (Tuple2)consumer.toMat((Graph)Sink$.MODULE$.foreach((Function1 & Serializable)record -> {
                KafkaTrackerPoll.$anonfun$tracker$2(this, messageMatcher, actor, record);
                return BoxedUnit.UNIT;
            }), Keep$.MODULE$.both()).run(this.materializer());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Consumer.Control consumerControl = (Consumer.Control)tuple2._1();
            Future streamComplete = (Future)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)consumerControl, (Object)streamComplete);
            Consumer.Control consumerControl2 = (Consumer.Control)tuple22._1();
            Future streamComplete2 = (Future)tuple22._2();
            streamComplete2.onComplete((Function1 & Serializable)x$3 -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Kafka akka consumer stream has been completed.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.systemAkkaConsumer().terminate();
            }, ExecutionContext.Implicits$.MODULE$.global());
            this.rebalancingLatch().await();
            return new TrackerAndController(new KafkaTracker(actor), consumerControl2);
        }).kafkaTracker();
    }

    public static final /* synthetic */ void $anonfun$tracker$2(KafkaTrackerPoll $this, KafkaMatcher messageMatcher$1, ActorRef actor$1, ConsumerRecord record) {
        BoxedUnit boxedUnit;
        Object matchId = messageMatcher$1.responseMatchId(record);
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Received Kafka message. Key: {} Payload: {}. With matchId - {}", new Object[]{record.key(), record.value(), matchId});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MessageReceived x$1 = new MessageReceived(matchId, $this.clock.nowMillis(), record);
        ActorRef x$2 = actor$1.$bang$default$2((Object)x$1);
        actor$1.$bang((Object)x$1, x$2);
    }

    public KafkaTrackerPoll(scala.collection.immutable.Map<String, Object> consumerProperties, ActorSystem system, StatsEngine statsEngine, Clock clock) {
        this.consumerProperties = consumerProperties;
        this.system = system;
        this.statsEngine = statsEngine;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        KafkaLogging.$init$(this);
        NameGen.$init$((NameGen)this);
        this.trackers = new ConcurrentHashMap();
        this.rebalancingLatch = new CountDownLatch(1);
        String configString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | akka {\n        |   loglevel = \"OFF\"\n        | }\n        "));
        Config config = ConfigFactory.parseString((String)configString);
        this.disableLogsConfig = ConfigFactory.load((Config)config);
        this.transformMapValueToString = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (value instanceof String) {
                    String string = (String)value;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)string);
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.toString());
            }
            throw new MatchError((Object)tuple2);
        };
        Statics.releaseFence();
    }
}

