/*
 * Decompiled with CFR 0.152.
 */
package tech.amikos.chromadb;

import java.util.List;
import tech.amikos.chromadb.EmbeddingFunction;
import tech.amikos.cohere.CohereClient;
import tech.amikos.cohere.CreateEmbeddingRequest;
import tech.amikos.cohere.CreateEmbeddingResponse;

public class CohereEmbeddingFunction
implements EmbeddingFunction {
    private final String cohereAPIKey;

    public CohereEmbeddingFunction(String cohereAPIKey) {
        this.cohereAPIKey = cohereAPIKey;
    }

    @Override
    public List<List<Float>> createEmbedding(List<String> documents) {
        CohereClient client = new CohereClient(this.cohereAPIKey);
        CreateEmbeddingResponse response = client.createEmbedding(new CreateEmbeddingRequest().texts(documents.toArray(new String[0])));
        return response.getEmbeddings();
    }

    @Override
    public List<List<Float>> createEmbedding(List<String> documents, String model) {
        CohereClient client = new CohereClient(this.cohereAPIKey);
        CreateEmbeddingResponse response = client.createEmbedding(new CreateEmbeddingRequest().texts(documents.toArray(new String[0])).model(model));
        return response.getEmbeddings();
    }
}

