/*
 * Decompiled with CFR 0.152.
 */
package tech.amikos.chromadb;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LinkedTreeMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tech.amikos.chromadb.EmbeddingFunction;
import tech.amikos.chromadb.handler.ApiException;
import tech.amikos.chromadb.handler.DefaultApi;
import tech.amikos.chromadb.model.AddEmbedding;
import tech.amikos.chromadb.model.DeleteEmbedding;
import tech.amikos.chromadb.model.GetEmbedding;
import tech.amikos.chromadb.model.QueryEmbedding;
import tech.amikos.chromadb.model.UpdateCollection;
import tech.amikos.chromadb.model.UpdateEmbedding;

public class Collection {
    static Gson gson = new Gson();
    DefaultApi api;
    String collectionName;
    String collectionId;
    LinkedTreeMap<String, Object> metadata = new LinkedTreeMap();
    private EmbeddingFunction embeddingFunction;

    public Collection(DefaultApi api, String collectionName, EmbeddingFunction embeddingFunction) {
        this.api = api;
        this.collectionName = collectionName;
        this.embeddingFunction = embeddingFunction;
    }

    public String getName() {
        return this.collectionName;
    }

    public String getId() {
        return this.collectionId;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Collection fetch() throws ApiException {
        LinkedTreeMap resp = (LinkedTreeMap)this.api.getCollection(this.collectionName);
        this.collectionName = resp.get((Object)"name").toString();
        this.collectionId = resp.get((Object)"id").toString();
        this.metadata = (LinkedTreeMap)resp.get((Object)"metadata");
        return this;
    }

    public static Collection getInstance(DefaultApi api, String collectionName) throws ApiException {
        return new Collection(api, collectionName, null);
    }

    public String toString() {
        return "Collection{collectionName='" + this.collectionName + '\'' + ", collectionId='" + this.collectionId + '\'' + ", metadata=" + this.metadata + '}';
    }

    public GetResult get(List<String> ids, Map<String, String> where, Map<String, Object> whereDocument) throws ApiException {
        GetEmbedding req = new GetEmbedding();
        req.ids(ids).where(where).whereDocument(whereDocument);
        Gson gson = new Gson();
        String json = gson.toJson(this.api.get(req, this.collectionId));
        return (GetResult)new Gson().fromJson(json, GetResult.class);
    }

    public GetResult get() throws ApiException {
        return this.get(null, null, null);
    }

    public Object delete() throws ApiException {
        return this.delete(null, null, null);
    }

    public Object upsert(List<List<Float>> embeddings, List<Map<String, String>> metadatas, List<String> documents, List<String> ids) throws ApiException {
        AddEmbedding req = new AddEmbedding();
        List<Object> _embeddings = embeddings;
        if (_embeddings == null) {
            _embeddings = this.embeddingFunction.createEmbedding(documents);
        }
        req.setEmbeddings(_embeddings);
        req.setMetadatas(metadatas);
        req.setDocuments(documents);
        req.incrementIndex(true);
        req.setIds(ids);
        return this.api.upsert(req, this.collectionId);
    }

    public Object add(List<List<Float>> embeddings, List<Map<String, String>> metadatas, List<String> documents, List<String> ids) throws ApiException {
        AddEmbedding req = new AddEmbedding();
        List<Object> _embeddings = embeddings;
        if (_embeddings == null) {
            _embeddings = this.embeddingFunction.createEmbedding(documents);
        }
        req.setEmbeddings(_embeddings);
        req.setMetadatas(metadatas);
        req.setDocuments(documents);
        req.incrementIndex(true);
        req.setIds(ids);
        return this.api.add(req, this.collectionId);
    }

    public Integer count() throws ApiException {
        return this.api.count(this.collectionId);
    }

    public Object delete(List<String> ids, Map<String, String> where, Map<String, Object> whereDocument) throws ApiException {
        DeleteEmbedding req = new DeleteEmbedding();
        req.setIds(ids);
        if (where != null) {
            req.where(where.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue())));
        }
        if (whereDocument != null) {
            req.whereDocument(whereDocument.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue())));
        }
        return this.api.delete(req, this.collectionId);
    }

    public Object deleteWithIds(List<String> ids) throws ApiException {
        return this.delete(ids, null, null);
    }

    public Object deleteWhere(Map<String, String> where) throws ApiException {
        return this.delete(null, where, null);
    }

    public Object deleteWhereWhereDocuments(Map<String, String> where, Map<String, Object> whereDocument) throws ApiException {
        return this.delete(null, where, whereDocument);
    }

    public Object deleteWhereDocuments(Map<String, Object> whereDocument) throws ApiException {
        return this.delete(null, null, whereDocument);
    }

    @Deprecated
    public Boolean createIndex() throws ApiException {
        return this.api.createIndex(this.collectionId);
    }

    public Object update(String newName, Map<String, Object> newMetadata) throws ApiException {
        UpdateCollection req = new UpdateCollection();
        if (newName != null) {
            req.setNewName(newName);
        }
        if (newMetadata != null && this.embeddingFunction != null) {
            if (!newMetadata.containsKey("embedding_function")) {
                newMetadata.put("embedding_function", this.embeddingFunction.getClass().getName());
            }
            req.setNewMetadata(newMetadata);
        }
        Object resp = this.api.updateCollection(req, this.collectionId);
        this.collectionName = newName;
        this.fetch();
        return resp;
    }

    public Object updateEmbeddings(List<List<Float>> embeddings, List<Map<String, String>> metadatas, List<String> documents, List<String> ids) throws ApiException {
        UpdateEmbedding req = new UpdateEmbedding();
        List<Object> _embeddings = embeddings;
        if (_embeddings == null) {
            _embeddings = this.embeddingFunction.createEmbedding(documents);
        }
        req.setEmbeddings(_embeddings);
        req.setDocuments(documents);
        req.setMetadatas(metadatas);
        req.setIds(ids);
        return this.api.update(req, this.collectionId);
    }

    public QueryResponse query(List<String> queryTexts, Integer nResults, Map<String, String> where, Map<String, String> whereDocument, List<QueryEmbedding.IncludeEnum> include) throws ApiException {
        QueryEmbedding body = new QueryEmbedding();
        body.queryEmbeddings(this.embeddingFunction.createEmbedding(queryTexts));
        body.nResults(nResults);
        body.include(include);
        if (where != null) {
            body.where(where.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue())));
        }
        if (whereDocument != null) {
            body.whereDocument(whereDocument.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue())));
        }
        Gson gson = new Gson();
        String json = gson.toJson(this.api.getNearestNeighbors(body, this.collectionId));
        return (QueryResponse)new Gson().fromJson(json, QueryResponse.class);
    }

    public static class GetResult {
        @SerializedName(value="documents")
        private List<String> documents;
        @SerializedName(value="embeddings")
        private List<Float> embeddings;
        @SerializedName(value="ids")
        private List<String> ids;
        @SerializedName(value="metadatas")
        private List<Map<String, Object>> metadatas;

        public List<String> getDocuments() {
            return this.documents;
        }

        public List<Float> getEmbeddings() {
            return this.embeddings;
        }

        public List<String> getIds() {
            return this.ids;
        }

        public List<Map<String, Object>> getMetadatas() {
            return this.metadatas;
        }

        public String toString() {
            return new Gson().toJson((Object)this);
        }
    }

    public static class QueryResponse {
        @SerializedName(value="documents")
        private List<List<String>> documents;
        @SerializedName(value="embeddings")
        private List<List<Float>> embeddings;
        @SerializedName(value="ids")
        private List<List<String>> ids;
        @SerializedName(value="metadatas")
        private List<List<Map<String, Object>>> metadatas;
        @SerializedName(value="distances")
        private List<List<Float>> distances;

        public List<List<String>> getDocuments() {
            return this.documents;
        }

        public List<List<Float>> getEmbeddings() {
            return this.embeddings;
        }

        public List<List<String>> getIds() {
            return this.ids;
        }

        public List<List<Map<String, Object>>> getMetadatas() {
            return this.metadatas;
        }

        public List<List<Float>> getDistances() {
            return this.distances;
        }

        public String toString() {
            return new Gson().toJson((Object)this);
        }
    }
}

