/*
 * Decompiled with CFR 0.152.
 */
package tech.amikos.cohere;

import com.google.gson.Gson;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import tech.amikos.cohere.CreateEmbeddingRequest;
import tech.amikos.cohere.CreateEmbeddingResponse;

public class CohereClient {
    private String baseUrl = "https://api.cohere.ai/";
    private String apiVersion = "v1";
    private String apiKey;
    private OkHttpClient client = new OkHttpClient();
    private Gson gson = new Gson();
    MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public CohereClient(String apiKey) {
        this.apiKey = apiKey;
    }

    public CohereClient apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public CohereClient apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public CohereClient baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    private String getApiKey() {
        if (this.apiKey == null) {
            throw new RuntimeException("API Key not set");
        }
        return this.apiKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CreateEmbeddingResponse createEmbedding(CreateEmbeddingRequest req) {
        Request request = new Request.Builder().url(this.baseUrl + this.apiVersion + "/embed").post(RequestBody.create((String)req.json(), (MediaType)this.JSON)).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("Request-Source", "chroma-java-client").addHeader("Authorization", "Bearer " + this.getApiKey()).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String responseData = response.body().string();
            CreateEmbeddingResponse createEmbeddingResponse = (CreateEmbeddingResponse)this.gson.fromJson(responseData, CreateEmbeddingResponse.class);
            return createEmbeddingResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

