/*
 * Decompiled with CFR 0.152.
 */
package tech.amikos.hf;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import tech.amikos.hf.CreateEmbeddingRequest;
import tech.amikos.hf.CreateEmbeddingResponse;

public class HuggingFaceClient {
    private String baseUrl = "https://api-inference.huggingface.co/pipeline/feature-extraction/";
    private String apiKey;
    private OkHttpClient client = new OkHttpClient();
    private String modelId = "sentence-transformers/all-MiniLM-L6-v2";
    private Gson gson = new Gson();
    MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public HuggingFaceClient(String apiKey) {
        this.apiKey = apiKey;
    }

    public HuggingFaceClient apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public HuggingFaceClient baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public HuggingFaceClient modelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    private String getApiKey() {
        if (this.apiKey == null) {
            throw new RuntimeException("API Key not set");
        }
        return this.apiKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CreateEmbeddingResponse createEmbedding(CreateEmbeddingRequest req) {
        Request request = new Request.Builder().url(this.baseUrl + this.modelId).post(RequestBody.create((String)req.json(), (MediaType)this.JSON)).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.getApiKey()).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String responseData = response.body().string();
            List parsedResponse = (List)this.gson.fromJson(responseData, List.class);
            CreateEmbeddingResponse createEmbeddingResponse = new CreateEmbeddingResponse(parsedResponse);
            return createEmbeddingResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

