/*
 * Decompiled with CFR 0.152.
 */
package tech.amikos.chromadb;

import com.google.gson.internal.LinkedTreeMap;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import tech.amikos.chromadb.Collection;
import tech.amikos.chromadb.embeddings.EmbeddingFunction;
import tech.amikos.chromadb.handler.ApiClient;
import tech.amikos.chromadb.handler.ApiException;
import tech.amikos.chromadb.handler.DefaultApi;
import tech.amikos.chromadb.model.CreateCollection;

public class Client {
    final ApiClient apiClient = new ApiClient();
    private int timeout = 60;
    DefaultApi api;

    public Client(String basePath) {
        this.apiClient.setBasePath(basePath);
        this.api = new DefaultApi(this.apiClient);
        this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build());
        this.api.getApiClient().setUserAgent("Chroma-JavaClient/0.1.x");
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build());
    }

    public void setDefaultHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.apiClient.addDefaultHeader(entry.getKey(), entry.getValue());
        }
    }

    public Collection getCollection(String collectionName, EmbeddingFunction embeddingFunction) throws ApiException {
        return new Collection(this.api, collectionName, embeddingFunction).fetch();
    }

    public Map<String, BigDecimal> heartbeat() throws ApiException {
        return this.api.heartbeat();
    }

    public Collection createCollection(String collectionName, Map<String, String> metadata, Boolean createOrGet, EmbeddingFunction embeddingFunction) throws ApiException {
        CreateCollection req = new CreateCollection();
        req.setName(collectionName);
        LinkedTreeMap _metadata = metadata;
        if (metadata == null || metadata.isEmpty() || !metadata.containsKey("embedding_function")) {
            _metadata = new LinkedTreeMap();
            _metadata.put("embedding_function", embeddingFunction.getClass().getName());
        }
        req.setMetadata(_metadata);
        req.setGetOrCreate(createOrGet);
        LinkedTreeMap resp = (LinkedTreeMap)this.api.createCollection(req);
        return new Collection(this.api, (String)resp.get((Object)"name"), embeddingFunction).fetch();
    }

    public Collection deleteCollection(String collectionName) throws ApiException {
        Collection collection = Collection.getInstance(this.api, collectionName);
        this.api.deleteCollection(collectionName);
        return collection;
    }

    public Collection upsert(String collectionName, EmbeddingFunction ef) throws ApiException {
        Collection collection = this.getCollection(collectionName, ef);
        return collection;
    }

    public Boolean reset() throws ApiException {
        return this.api.reset();
    }

    public List<Collection> listCollections() throws ApiException {
        List apiResponse = (List)this.api.listCollections();
        return apiResponse.stream().map(m -> {
            try {
                return this.getCollection((String)m.get((Object)"name"), null);
            }
            catch (ApiException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList());
    }

    public String version() throws ApiException {
        return this.api.version();
    }
}

