/*
 * Decompiled with CFR 0.152.
 */
package tech.amikos.chromadb.embeddings.hf;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import tech.amikos.chromadb.Constants;
import tech.amikos.chromadb.EFException;
import tech.amikos.chromadb.Embedding;
import tech.amikos.chromadb.embeddings.EmbeddingFunction;
import tech.amikos.chromadb.embeddings.WithParam;
import tech.amikos.chromadb.embeddings.hf.CreateEmbeddingRequest;
import tech.amikos.chromadb.embeddings.hf.CreateEmbeddingResponse;

public class HuggingFaceEmbeddingFunction
implements EmbeddingFunction {
    public static final String DEFAULT_MODEL_NAME = "sentence-transformers/all-MiniLM-L6-v2";
    public static final String DEFAULT_BASE_API = "https://api-inference.huggingface.co/pipeline/feature-extraction/";
    public static final String HFEI_API_PATH = "/embed";
    public static final String HF_API_KEY_ENV = "HF_API_KEY";
    public static final String API_TYPE_CONFIG_KEY = "apiType";
    private final OkHttpClient client = new OkHttpClient();
    private final Map<String, Object> configParams = new HashMap<String, Object>();
    private static final Gson gson = new Gson();
    private static final List<WithParam> defaults = Arrays.asList(new WithAPIType(APIType.HF_API), WithParam.baseAPI("https://api-inference.huggingface.co/pipeline/feature-extraction/"), WithParam.defaultModel("sentence-transformers/all-MiniLM-L6-v2"));

    public HuggingFaceEmbeddingFunction() throws EFException {
        for (WithParam param : defaults) {
            param.apply(this.configParams);
        }
        WithParam.apiKeyFromEnv(HF_API_KEY_ENV).apply(this.configParams);
    }

    public HuggingFaceEmbeddingFunction(WithParam ... params) throws EFException {
        for (WithParam param : defaults) {
            param.apply(this.configParams);
        }
        for (WithParam param : params) {
            param.apply(this.configParams);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CreateEmbeddingResponse createEmbedding(CreateEmbeddingRequest req) throws EFException {
        Request.Builder rb = new Request.Builder().post(RequestBody.create((String)req.json(), (MediaType)Constants.JSON)).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("User-Agent", "chroma-java-client");
        if (this.configParams.containsKey(API_TYPE_CONFIG_KEY) && this.configParams.get(API_TYPE_CONFIG_KEY).equals((Object)APIType.HFEI_API)) {
            rb.url(this.configParams.get("baseAPI").toString() + HFEI_API_PATH);
        } else {
            rb.url(this.configParams.get("baseAPI").toString() + this.configParams.get("modelName").toString());
        }
        if (this.configParams.containsKey("apiKey")) {
            rb.addHeader("Authorization", "Bearer " + this.configParams.get("apiKey").toString());
        }
        Request request = rb.build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String responseData = response.body().string();
            List parsedResponse = (List)gson.fromJson(responseData, List.class);
            CreateEmbeddingResponse createEmbeddingResponse = new CreateEmbeddingResponse(parsedResponse);
            return createEmbeddingResponse;
        }
        catch (IOException e) {
            throw new EFException(e);
        }
    }

    @Override
    public Embedding embedQuery(String query) throws EFException {
        CreateEmbeddingResponse response = this.createEmbedding(new CreateEmbeddingRequest().inputs(new String[]{query}));
        return new Embedding(response.getEmbeddings().get(0));
    }

    @Override
    public List<Embedding> embedDocuments(@NotNull List<String> documents) throws EFException {
        CreateEmbeddingResponse response = this.createEmbedding(new CreateEmbeddingRequest().inputs(documents.toArray(new String[0])));
        return response.getEmbeddings().stream().map(Embedding::fromList).collect(Collectors.toList());
    }

    @Override
    public List<Embedding> embedDocuments(String[] documents) throws EFException {
        CreateEmbeddingResponse response = this.createEmbedding(new CreateEmbeddingRequest().inputs(documents));
        return response.getEmbeddings().stream().map(Embedding::fromList).collect(Collectors.toList());
    }

    public static enum APIType {
        HF_API,
        HFEI_API;

    }

    public static class WithAPIType
    extends WithParam {
        private final APIType apiType;

        public WithAPIType(APIType apitype) {
            this.apiType = apitype;
        }

        @Override
        public void apply(Map<String, Object> params) {
            params.put(HuggingFaceEmbeddingFunction.API_TYPE_CONFIG_KEY, (Object)this.apiType);
        }
    }
}

