/*
 * Decompiled with CFR 0.152.
 */
package io.github.amithkoujalgi.ollama4j.core.models;

import io.github.amithkoujalgi.ollama4j.core.exceptions.OllamaBaseException;
import io.github.amithkoujalgi.ollama4j.core.models.OllamaErrorResponseModel;
import io.github.amithkoujalgi.ollama4j.core.models.generate.OllamaGenerateRequestModel;
import io.github.amithkoujalgi.ollama4j.core.models.generate.OllamaGenerateResponseModel;
import io.github.amithkoujalgi.ollama4j.core.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Queue;

public class OllamaAsyncResultCallback
extends Thread {
    private final HttpRequest.Builder requestBuilder;
    private final OllamaGenerateRequestModel ollamaRequestModel;
    private final Queue<String> queue = new LinkedList<String>();
    private String result;
    private boolean isDone;
    private boolean succeeded;
    private long requestTimeoutSeconds;
    private int httpStatusCode;
    private long responseTime = 0L;

    public OllamaAsyncResultCallback(HttpRequest.Builder requestBuilder, OllamaGenerateRequestModel ollamaRequestModel, long requestTimeoutSeconds) {
        this.requestBuilder = requestBuilder;
        this.ollamaRequestModel = ollamaRequestModel;
        this.isDone = false;
        this.result = "";
        this.queue.add("");
        this.requestTimeoutSeconds = requestTimeoutSeconds;
    }

    @Override
    public void run() {
        HttpClient httpClient = HttpClient.newHttpClient();
        try {
            int statusCode;
            long startTime = System.currentTimeMillis();
            HttpRequest request = this.requestBuilder.POST(HttpRequest.BodyPublishers.ofString(Utils.getObjectMapper().writeValueAsString((Object)this.ollamaRequestModel))).header("Content-Type", "application/json").timeout(Duration.ofSeconds(this.requestTimeoutSeconds)).build();
            HttpResponse<InputStream> response = httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            this.httpStatusCode = statusCode = response.statusCode();
            InputStream responseBodyStream = response.body();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseBodyStream, StandardCharsets.UTF_8));){
                String line;
                StringBuilder responseBuffer = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    Object ollamaResponseModel;
                    if (statusCode == 404) {
                        ollamaResponseModel = (OllamaErrorResponseModel)Utils.getObjectMapper().readValue(line, OllamaErrorResponseModel.class);
                        this.queue.add(((OllamaErrorResponseModel)ollamaResponseModel).getError());
                        responseBuffer.append(((OllamaErrorResponseModel)ollamaResponseModel).getError());
                        continue;
                    }
                    ollamaResponseModel = (OllamaGenerateResponseModel)Utils.getObjectMapper().readValue(line, OllamaGenerateResponseModel.class);
                    this.queue.add(((OllamaGenerateResponseModel)ollamaResponseModel).getResponse());
                    if (((OllamaGenerateResponseModel)ollamaResponseModel).isDone()) continue;
                    responseBuffer.append(((OllamaGenerateResponseModel)ollamaResponseModel).getResponse());
                }
                this.isDone = true;
                this.succeeded = true;
                this.result = responseBuffer.toString();
                long endTime = System.currentTimeMillis();
                this.responseTime = endTime - startTime;
            }
            if (statusCode != 200) {
                throw new OllamaBaseException(this.result);
            }
        }
        catch (OllamaBaseException | IOException | InterruptedException e) {
            this.isDone = true;
            this.succeeded = false;
            this.result = "[FAILED] " + e.getMessage();
        }
    }

    public boolean isComplete() {
        return this.isDone;
    }

    public String getResponse() {
        return this.result;
    }

    public Queue<String> getStream() {
        return this.queue;
    }

    public void setRequestTimeoutSeconds(long requestTimeoutSeconds) {
        this.requestTimeoutSeconds = requestTimeoutSeconds;
    }

    public HttpRequest.Builder getRequestBuilder() {
        return this.requestBuilder;
    }

    public OllamaGenerateRequestModel getOllamaRequestModel() {
        return this.ollamaRequestModel;
    }

    public Queue<String> getQueue() {
        return this.queue;
    }

    public String getResult() {
        return this.result;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public long getRequestTimeoutSeconds() {
        return this.requestTimeoutSeconds;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setDone(boolean isDone) {
        this.isDone = isDone;
    }

    public void setSucceeded(boolean succeeded) {
        this.succeeded = succeeded;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    @Override
    public String toString() {
        return "OllamaAsyncResultCallback(requestBuilder=" + this.getRequestBuilder() + ", ollamaRequestModel=" + this.getOllamaRequestModel() + ", queue=" + this.getQueue() + ", result=" + this.getResult() + ", isDone=" + this.isDone() + ", succeeded=" + this.isSucceeded() + ", requestTimeoutSeconds=" + this.getRequestTimeoutSeconds() + ", httpStatusCode=" + this.getHttpStatusCode() + ", responseTime=" + this.getResponseTime() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OllamaAsyncResultCallback)) {
            return false;
        }
        OllamaAsyncResultCallback other = (OllamaAsyncResultCallback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDone() != other.isDone()) {
            return false;
        }
        if (this.isSucceeded() != other.isSucceeded()) {
            return false;
        }
        if (this.getRequestTimeoutSeconds() != other.getRequestTimeoutSeconds()) {
            return false;
        }
        if (this.getHttpStatusCode() != other.getHttpStatusCode()) {
            return false;
        }
        if (this.getResponseTime() != other.getResponseTime()) {
            return false;
        }
        HttpRequest.Builder this$requestBuilder = this.getRequestBuilder();
        HttpRequest.Builder other$requestBuilder = other.getRequestBuilder();
        if (this$requestBuilder == null ? other$requestBuilder != null : !this$requestBuilder.equals(other$requestBuilder)) {
            return false;
        }
        OllamaGenerateRequestModel this$ollamaRequestModel = this.getOllamaRequestModel();
        OllamaGenerateRequestModel other$ollamaRequestModel = other.getOllamaRequestModel();
        if (this$ollamaRequestModel == null ? other$ollamaRequestModel != null : !((Object)this$ollamaRequestModel).equals(other$ollamaRequestModel)) {
            return false;
        }
        Queue<String> this$queue = this.getQueue();
        Queue<String> other$queue = other.getQueue();
        if (this$queue == null ? other$queue != null : !this$queue.equals(other$queue)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OllamaAsyncResultCallback;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDone() ? 79 : 97);
        result = result * 59 + (this.isSucceeded() ? 79 : 97);
        long $requestTimeoutSeconds = this.getRequestTimeoutSeconds();
        result = result * 59 + (int)($requestTimeoutSeconds >>> 32 ^ $requestTimeoutSeconds);
        result = result * 59 + this.getHttpStatusCode();
        long $responseTime = this.getResponseTime();
        result = result * 59 + (int)($responseTime >>> 32 ^ $responseTime);
        HttpRequest.Builder $requestBuilder = this.getRequestBuilder();
        result = result * 59 + ($requestBuilder == null ? 43 : $requestBuilder.hashCode());
        OllamaGenerateRequestModel $ollamaRequestModel = this.getOllamaRequestModel();
        result = result * 59 + ($ollamaRequestModel == null ? 43 : ((Object)$ollamaRequestModel).hashCode());
        Queue<String> $queue = this.getQueue();
        result = result * 59 + ($queue == null ? 43 : $queue.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public long getResponseTime() {
        return this.responseTime;
    }
}

