/*
 * Decompiled with CFR 0.152.
 */
package io.github.amithkoujalgi.ollama4j.core.models.chat;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.github.amithkoujalgi.ollama4j.core.models.chat.OllamaChatMessageRole;
import io.github.amithkoujalgi.ollama4j.core.utils.FileToBase64Serializer;
import io.github.amithkoujalgi.ollama4j.core.utils.Utils;
import java.util.List;
import lombok.NonNull;

public class OllamaChatMessage {
    @NonNull
    private OllamaChatMessageRole role;
    @NonNull
    private String content;
    @JsonSerialize(using=FileToBase64Serializer.class)
    private List<byte[]> images;

    public String toString() {
        try {
            return Utils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public OllamaChatMessageRole getRole() {
        return this.role;
    }

    @NonNull
    public String getContent() {
        return this.content;
    }

    public List<byte[]> getImages() {
        return this.images;
    }

    public void setRole(@NonNull OllamaChatMessageRole role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
    }

    public void setContent(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.content = content;
    }

    public void setImages(List<byte[]> images) {
        this.images = images;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OllamaChatMessage)) {
            return false;
        }
        OllamaChatMessage other = (OllamaChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OllamaChatMessageRole this$role = this.getRole();
        OllamaChatMessageRole other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<byte[]> this$images = this.getImages();
        List<byte[]> other$images = other.getImages();
        return !(this$images == null ? other$images != null : !((Object)this$images).equals(other$images));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OllamaChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OllamaChatMessageRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<byte[]> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        return result;
    }

    public OllamaChatMessage(@NonNull OllamaChatMessageRole role, @NonNull String content, List<byte[]> images) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.role = role;
        this.content = content;
        this.images = images;
    }

    public OllamaChatMessage(@NonNull OllamaChatMessageRole role, @NonNull String content) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.role = role;
        this.content = content;
    }

    public OllamaChatMessage() {
    }
}

