/*
 * Decompiled with CFR 0.152.
 */
package io.github.amithkoujalgi.ollama4j.core.models.chat;

import io.github.amithkoujalgi.ollama4j.core.models.chat.OllamaChatMessage;
import io.github.amithkoujalgi.ollama4j.core.models.chat.OllamaChatMessageRole;
import io.github.amithkoujalgi.ollama4j.core.models.chat.OllamaChatRequestModel;
import io.github.amithkoujalgi.ollama4j.core.utils.Options;
import io.github.amithkoujalgi.ollama4j.core.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OllamaChatRequestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OllamaChatRequestBuilder.class);
    private OllamaChatRequestModel request;

    private OllamaChatRequestBuilder(String model, List<OllamaChatMessage> messages) {
        this.request = new OllamaChatRequestModel(model, messages);
    }

    public static OllamaChatRequestBuilder getInstance(String model) {
        return new OllamaChatRequestBuilder(model, new ArrayList<OllamaChatMessage>());
    }

    public OllamaChatRequestModel build() {
        return this.request;
    }

    public void reset() {
        this.request = new OllamaChatRequestModel(this.request.getModel(), new ArrayList<OllamaChatMessage>());
    }

    public OllamaChatRequestBuilder withMessage(OllamaChatMessageRole role, String content, List<File> images) {
        List<OllamaChatMessage> messages = this.request.getMessages();
        List<byte[]> binaryImages = images.stream().map(file -> {
            try {
                return Files.readAllBytes(file.toPath());
            }
            catch (IOException e) {
                LOG.warn(String.format("File '%s' could not be accessed, will not add to message!", file.toPath()), (Throwable)e);
                return new byte[0];
            }
        }).collect(Collectors.toList());
        messages.add(new OllamaChatMessage(role, content, binaryImages));
        return this;
    }

    public OllamaChatRequestBuilder withMessage(OllamaChatMessageRole role, String content, String ... imageUrls) {
        List<OllamaChatMessage> messages = this.request.getMessages();
        ArrayList<byte[]> binaryImages = null;
        if (imageUrls.length > 0) {
            binaryImages = new ArrayList<byte[]>();
            for (String imageUrl : imageUrls) {
                try {
                    binaryImages.add(Utils.loadImageBytesFromUrl(imageUrl));
                }
                catch (URISyntaxException e) {
                    LOG.warn(String.format("URL '%s' could not be accessed, will not add to message!", imageUrl), (Throwable)e);
                }
                catch (IOException e) {
                    LOG.warn(String.format("Content of URL '%s' could not be read, will not add to message!", imageUrl), (Throwable)e);
                }
            }
        }
        messages.add(new OllamaChatMessage(role, content, binaryImages));
        return this;
    }

    public OllamaChatRequestBuilder withMessages(List<OllamaChatMessage> messages) {
        this.request.getMessages().addAll(messages);
        return this;
    }

    public OllamaChatRequestBuilder withOptions(Options options) {
        this.request.setOptions(options.getOptionsMap());
        return this;
    }

    public OllamaChatRequestBuilder withGetJsonResponse() {
        this.request.setReturnFormatJson(true);
        return this;
    }

    public OllamaChatRequestBuilder withTemplate(String template) {
        this.request.setTemplate(template);
        return this;
    }

    public OllamaChatRequestBuilder withStreaming() {
        this.request.setStream(true);
        return this;
    }

    public OllamaChatRequestBuilder withKeepAlive(String keepAlive) {
        this.request.setKeepAlive(keepAlive);
        return this;
    }
}

