/*
 * Decompiled with CFR 0.152.
 */
package io.github.amithkoujalgi.ollama4j.core.models.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.amithkoujalgi.ollama4j.core.OllamaStreamHandler;
import io.github.amithkoujalgi.ollama4j.core.exceptions.OllamaBaseException;
import io.github.amithkoujalgi.ollama4j.core.models.BasicAuth;
import io.github.amithkoujalgi.ollama4j.core.models.OllamaResult;
import io.github.amithkoujalgi.ollama4j.core.models.chat.OllamaChatResponseModel;
import io.github.amithkoujalgi.ollama4j.core.models.chat.OllamaChatStreamObserver;
import io.github.amithkoujalgi.ollama4j.core.models.request.OllamaEndpointCaller;
import io.github.amithkoujalgi.ollama4j.core.utils.OllamaRequestBody;
import io.github.amithkoujalgi.ollama4j.core.utils.Utils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OllamaChatEndpointCaller
extends OllamaEndpointCaller {
    private static final Logger LOG = LoggerFactory.getLogger(OllamaChatEndpointCaller.class);
    private OllamaChatStreamObserver streamObserver;

    public OllamaChatEndpointCaller(String host, BasicAuth basicAuth, long requestTimeoutSeconds, boolean verbose) {
        super(host, basicAuth, requestTimeoutSeconds, verbose);
    }

    @Override
    protected String getEndpointSuffix() {
        return "/api/chat";
    }

    @Override
    protected boolean parseResponseAndAddToBuffer(String line, StringBuilder responseBuffer) {
        try {
            OllamaChatResponseModel ollamaResponseModel = (OllamaChatResponseModel)Utils.getObjectMapper().readValue(line, OllamaChatResponseModel.class);
            responseBuffer.append(ollamaResponseModel.getMessage().getContent());
            if (this.streamObserver != null) {
                this.streamObserver.notify(ollamaResponseModel);
            }
            return ollamaResponseModel.isDone();
        }
        catch (JsonProcessingException e) {
            LOG.error("Error parsing the Ollama chat response!", (Throwable)e);
            return true;
        }
    }

    public OllamaResult call(OllamaRequestBody body, OllamaStreamHandler streamHandler) throws OllamaBaseException, IOException, InterruptedException {
        this.streamObserver = new OllamaChatStreamObserver(streamHandler);
        return super.callSync(body);
    }
}

