/*
 * Decompiled with CFR 0.152.
 */
package com.amrdeveloper.treeview;

import java.util.LinkedList;

public class TreeNode {
    private Object value;
    private TreeNode parent;
    private LinkedList<TreeNode> children;
    private int layoutId;
    private int level;
    private boolean isExpanded;
    private boolean isSelected;

    public TreeNode(Object value, int layoutId) {
        this.value = value;
        this.parent = null;
        this.children = new LinkedList();
        this.layoutId = layoutId;
        this.level = 0;
        this.isExpanded = false;
        this.isSelected = false;
    }

    public void addChild(TreeNode child) {
        child.setParent(this);
        child.setLevel(this.level + 1);
        this.children.add(child);
        this.updateNodeChildrenDepth(child);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public LinkedList<TreeNode> getChildren() {
        return this.children;
    }

    public int getLayoutId() {
        return this.layoutId;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    private void updateNodeChildrenDepth(TreeNode node) {
        if (node.getChildren().isEmpty()) {
            return;
        }
        for (TreeNode child : node.getChildren()) {
            child.setLevel(node.getLevel() + 1);
            this.updateNodeChildrenDepth(child);
        }
    }
}

