/*
 * Decompiled with CFR 0.152.
 */
package com.amrdeveloper.treeview;

import com.amrdeveloper.treeview.TreeNode;
import java.util.LinkedList;
import java.util.List;

public class TreeNodeManager {
    private final LinkedList<TreeNode> rootsNodes = new LinkedList();

    public void setTreeNodes(List<TreeNode> treeNodes) {
        this.rootsNodes.clear();
        this.rootsNodes.addAll(treeNodes);
    }

    public List<TreeNode> getTreeNodes() {
        return this.rootsNodes;
    }

    public TreeNode get(int index) {
        return this.rootsNodes.get(index);
    }

    public boolean addNode(TreeNode node) {
        return this.rootsNodes.add(node);
    }

    public void updateNodes(List<TreeNode> newNodes) {
        this.rootsNodes.clear();
        this.rootsNodes.addAll(newNodes);
    }

    public boolean removeNode(TreeNode node) {
        return this.rootsNodes.remove(node);
    }

    public void clearNodes() {
        this.rootsNodes.clear();
    }

    public int size() {
        return this.rootsNodes.size();
    }

    public int collapseNode(TreeNode node) {
        int position = this.rootsNodes.indexOf(node);
        if (position != -1 && node.isExpanded()) {
            node.setExpanded(false);
            LinkedList<TreeNode> deletedParents = new LinkedList<TreeNode>(node.getChildren());
            this.rootsNodes.removeAll(node.getChildren());
            for (int i = position + 1; i < this.rootsNodes.size(); ++i) {
                TreeNode iNode = this.rootsNodes.get(i);
                if (!deletedParents.contains(iNode.getParent())) continue;
                deletedParents.add(iNode);
                deletedParents.addAll(iNode.getChildren());
            }
            this.rootsNodes.removeAll(deletedParents);
        }
        return position;
    }

    public int expandNode(TreeNode node) {
        int position = this.rootsNodes.indexOf(node);
        if (position != -1 && !node.isExpanded()) {
            node.setExpanded(true);
            this.rootsNodes.addAll(position + 1, node.getChildren());
            for (TreeNode child : node.getChildren()) {
                if (!child.isExpanded()) continue;
                this.updateExpandedNodeChildren(child);
            }
        }
        return position;
    }

    private void updateExpandedNodeChildren(TreeNode node) {
        int position = this.rootsNodes.indexOf(node);
        if (position != -1 && node.isExpanded()) {
            this.rootsNodes.addAll(position + 1, node.getChildren());
            for (TreeNode child : node.getChildren()) {
                if (!child.isExpanded()) continue;
                this.updateExpandedNodeChildren(child);
            }
        }
    }

    public int collapseNodeBranch(TreeNode node) {
        int position = this.rootsNodes.indexOf(node);
        if (position != -1 && node.isExpanded()) {
            node.setExpanded(false);
            for (TreeNode child : node.getChildren()) {
                if (!child.getChildren().isEmpty()) {
                    this.collapseNodeBranch(child);
                }
                this.rootsNodes.remove(child);
            }
        }
        return position;
    }

    public int expandNodeBranch(TreeNode node) {
        int position = this.rootsNodes.indexOf(node);
        if (position != -1 && !node.isExpanded()) {
            node.setExpanded(true);
            int index = position + 1;
            for (TreeNode child : node.getChildren()) {
                int before = this.rootsNodes.size();
                this.rootsNodes.add(index, child);
                this.expandNodeBranch(child);
                int after = this.rootsNodes.size();
                int diff = after - before;
                index += diff;
            }
        }
        return position;
    }

    public void expandNodeToLevel(TreeNode node, int level) {
        if (node.getLevel() <= level) {
            this.expandNode(node);
        }
        for (TreeNode child : node.getChildren()) {
            this.expandNodeToLevel(child, level);
        }
    }

    public void expandNodesAtLevel(int level) {
        for (int i = 0; i < this.rootsNodes.size(); ++i) {
            TreeNode node = this.rootsNodes.get(i);
            this.expandNodeToLevel(node, level);
        }
    }

    public void collapseAll() {
        LinkedList<TreeNode> treeNodes = new LinkedList<TreeNode>();
        for (int i = 0; i < this.rootsNodes.size(); ++i) {
            TreeNode root = this.rootsNodes.get(i);
            if (root.getLevel() == 0) {
                this.collapseNodeBranch(root);
                treeNodes.add(root);
                continue;
            }
            root.setExpanded(false);
        }
        this.updateNodes(treeNodes);
    }

    public void expandAll() {
        for (int i = 0; i < this.rootsNodes.size(); ++i) {
            TreeNode root = this.rootsNodes.get(i);
            this.expandNodeBranch(root);
        }
    }
}

