/*
 * Decompiled with CFR 0.152.
 */
package com.amrdeveloper.treeview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.amrdeveloper.treeview.TreeNode;
import com.amrdeveloper.treeview.TreeNodeManager;
import com.amrdeveloper.treeview.TreeViewHolder;
import com.amrdeveloper.treeview.TreeViewHolderFactory;
import java.util.List;

public class TreeViewAdapter
extends RecyclerView.Adapter<TreeViewHolder> {
    private final TreeNodeManager treeNodeManager;
    private final TreeViewHolderFactory treeViewHolderFactory;
    private TreeNode currentSelectedNode;
    private OnTreeNodeClickListener treeNodeClickListener;
    private OnTreeNodeLongClickListener treeNodeLongClickListener;

    public TreeViewAdapter(TreeViewHolderFactory factory) {
        this.treeViewHolderFactory = factory;
        this.treeNodeManager = new TreeNodeManager();
    }

    public TreeViewAdapter(TreeViewHolderFactory factory, TreeNodeManager manager) {
        this.treeViewHolderFactory = factory;
        this.treeNodeManager = manager;
    }

    @NonNull
    public TreeViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int layoutId) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
        return this.treeViewHolderFactory.getTreeViewHolder(view, layoutId);
    }

    public void onBindViewHolder(@NonNull TreeViewHolder holder, int position) {
        TreeNode currentNode = this.treeNodeManager.get(position);
        holder.bindTreeNode(currentNode);
        holder.itemView.setOnClickListener(v -> {
            if (currentNode == this.currentSelectedNode) {
                this.currentSelectedNode.setSelected(!this.currentSelectedNode.isSelected());
            } else {
                if (this.currentSelectedNode != null) {
                    this.currentSelectedNode.setSelected(false);
                }
                this.currentSelectedNode = currentNode;
            }
            if (!currentNode.getChildren().isEmpty()) {
                boolean isNodeExpanded = currentNode.isExpanded();
                if (isNodeExpanded) {
                    this.collapseNode(currentNode);
                } else {
                    this.expandNode(currentNode);
                }
                currentNode.setExpanded(!isNodeExpanded);
                this.notifyItemRangeChanged(position, this.getItemCount() - position);
            }
            if (this.treeNodeClickListener != null) {
                this.treeNodeClickListener.onTreeNodeClick(currentNode, v);
            }
        });
        holder.itemView.setOnLongClickListener(v -> {
            if (this.treeNodeLongClickListener != null) {
                return this.treeNodeLongClickListener.onTreeNodeLongClick(currentNode, v);
            }
            return true;
        });
    }

    public int getItemViewType(int position) {
        return this.treeNodeManager.get(position).getLayoutId();
    }

    public int getItemCount() {
        return this.treeNodeManager.size();
    }

    public void collapseNode(TreeNode node) {
        int position = this.treeNodeManager.collapseNode(node);
        if (position != -1) {
            this.notifyDataSetChanged();
        }
    }

    public void expandNode(TreeNode node) {
        int position = this.treeNodeManager.expandNode(node);
        if (position != -1) {
            this.notifyDataSetChanged();
        }
    }

    public void collapseNodeBranch(TreeNode node) {
        this.treeNodeManager.collapseNodeBranch(node);
        this.notifyDataSetChanged();
    }

    public void expandNodeBranch(TreeNode node) {
        this.treeNodeManager.expandNodeBranch(node);
        this.notifyDataSetChanged();
    }

    public void expandNodeToLevel(TreeNode node, int level) {
        this.treeNodeManager.expandNodeToLevel(node, level);
        this.notifyDataSetChanged();
    }

    public void expandNodesAtLevel(int level) {
        this.treeNodeManager.expandNodesAtLevel(level);
        this.notifyDataSetChanged();
    }

    public void collapseAll() {
        this.treeNodeManager.collapseAll();
        this.notifyDataSetChanged();
    }

    public void expandAll() {
        this.treeNodeManager.expandAll();
        this.notifyDataSetChanged();
    }

    public void updateTreeNodes(List<TreeNode> treeNodes) {
        this.treeNodeManager.updateNodes(treeNodes);
        this.notifyDataSetChanged();
    }

    public void clearTreeNodes() {
        int size = this.treeNodeManager.size();
        this.treeNodeManager.clearNodes();
        this.notifyItemRangeRemoved(0, size);
    }

    public void setTreeNodeClickListener(OnTreeNodeClickListener listener) {
        this.treeNodeClickListener = listener;
    }

    public void setTreeNodeLongClickListener(OnTreeNodeLongClickListener listener) {
        this.treeNodeLongClickListener = listener;
    }

    public void setTreeNodes(List<TreeNode> treeNodes) {
        this.treeNodeManager.setTreeNodes(treeNodes);
        this.notifyDataSetChanged();
    }

    public List<TreeNode> getTreeNodes() {
        return this.treeNodeManager.getTreeNodes();
    }

    public TreeNode getSelectedNode() {
        return this.currentSelectedNode;
    }

    public static interface OnTreeNodeClickListener {
        public void onTreeNodeClick(TreeNode var1, View var2);
    }

    public static interface OnTreeNodeLongClickListener {
        public boolean onTreeNodeLongClick(TreeNode var1, View var2);
    }
}

