/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.io.ParsingDecoder;
import org.apache.avro.io.parsing.JsonGrammarGenerator;
import org.apache.avro.io.parsing.Parser;
import org.apache.avro.io.parsing.Symbol;
import org.apache.avro.util.Utf8;

public class ExtendedJsonDecoder
extends ParsingDecoder
implements Parser.ActionHandler {
    private JsonParser in;
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final Stack<ReorderBuffer> reorderBuffers = new Stack();
    private ReorderBuffer currentReorderBuffer;
    private final Schema schema;
    static final String CHARSET = "ISO-8859-1";
    private static final JsonElement NULL_JSON_ELEMENT = new JsonElement(null);

    public ExtendedJsonDecoder(Schema schema, InputStream in) throws IOException {
        super(ExtendedJsonDecoder.getSymbol(schema));
        this.configure(in);
        this.schema = schema;
    }

    public ExtendedJsonDecoder(Schema schema, String in) throws IOException {
        super(ExtendedJsonDecoder.getSymbol(schema));
        this.configure(in);
        this.schema = schema;
    }

    private static Symbol getSymbol(Schema schema) {
        if (schema == null) {
            throw new NullPointerException("Schema cannot be null!");
        }
        return new JsonGrammarGenerator().generate(schema);
    }

    public ExtendedJsonDecoder configure(InputStream in) throws IOException {
        if (null == in) {
            throw new NullPointerException("InputStream to read from cannot be null!");
        }
        this.parser.reset();
        this.in = jsonFactory.createParser(in);
        this.in.nextToken();
        return this;
    }

    public ExtendedJsonDecoder configure(String in) throws IOException {
        if (null == in) {
            throw new NullPointerException("String to read from cannot be null!");
        }
        this.parser.reset();
        this.in = new JsonFactory().createParser(in);
        this.in.nextToken();
        return this;
    }

    private void advance(Symbol symbol) throws IOException {
        this.parser.processTrailingImplicitActions();
        if (this.in.getCurrentToken() == null && this.parser.depth() == 1) {
            throw new EOFException();
        }
        this.parser.advance(symbol);
    }

    public void readNull() throws IOException {
        this.advance(Symbol.NULL);
        if (this.in.getCurrentToken() != JsonToken.VALUE_NULL) {
            throw this.error("null");
        }
        this.in.nextToken();
    }

    public boolean readBoolean() throws IOException {
        this.advance(Symbol.BOOLEAN);
        JsonToken t = this.in.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE || t == JsonToken.VALUE_FALSE) {
            this.in.nextToken();
            return t == JsonToken.VALUE_TRUE;
        }
        throw this.error("boolean");
    }

    public int readInt() throws IOException {
        this.advance(Symbol.INT);
        if (this.in.getCurrentToken().isNumeric()) {
            int result = this.in.getIntValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("int");
    }

    public long readLong() throws IOException {
        this.advance(Symbol.LONG);
        if (this.in.getCurrentToken().isNumeric()) {
            long result = this.in.getLongValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("long");
    }

    public float readFloat() throws IOException {
        this.advance(Symbol.FLOAT);
        if (this.in.getCurrentToken().isNumeric()) {
            float result = this.in.getFloatValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("float");
    }

    public double readDouble() throws IOException {
        this.advance(Symbol.DOUBLE);
        if (this.in.getCurrentToken().isNumeric()) {
            double result = this.in.getDoubleValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("double");
    }

    public Utf8 readString(Utf8 old) throws IOException {
        return new Utf8(this.readString());
    }

    public String readString() throws IOException {
        this.advance(Symbol.STRING);
        if (this.parser.topSymbol() == Symbol.MAP_KEY_MARKER) {
            this.parser.advance(Symbol.MAP_KEY_MARKER);
            if (this.in.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw this.error("map-key");
            }
        } else if (this.in.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw this.error("string");
        }
        String result = this.in.getText();
        this.in.nextToken();
        return result;
    }

    public void skipString() throws IOException {
        this.advance(Symbol.STRING);
        if (this.parser.topSymbol() == Symbol.MAP_KEY_MARKER) {
            this.parser.advance(Symbol.MAP_KEY_MARKER);
            if (this.in.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw this.error("map-key");
            }
        } else if (this.in.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw this.error("string");
        }
        this.in.nextToken();
    }

    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        this.advance(Symbol.BYTES);
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            byte[] result = this.readByteArray();
            this.in.nextToken();
            return ByteBuffer.wrap(result);
        }
        throw this.error("bytes");
    }

    private byte[] readByteArray() throws IOException {
        return this.in.getText().getBytes(CHARSET);
    }

    public void skipBytes() throws IOException {
        this.advance(Symbol.BYTES);
        if (this.in.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw this.error("bytes");
        }
        this.in.nextToken();
    }

    private void checkFixed(int size) throws IOException {
        this.advance(Symbol.FIXED);
        Symbol.IntCheckAction top = (Symbol.IntCheckAction)this.parser.popSymbol();
        if (size != top.size) {
            throw new AvroTypeException("Incorrect length for fixed binary: expected " + top.size + " but received " + size + " bytes.");
        }
    }

    public void readFixed(byte[] bytes, int start, int len) throws IOException {
        byte[] result;
        this.checkFixed(len);
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            result = this.readByteArray();
            this.in.nextToken();
            if (result.length != len) {
                throw new AvroTypeException("Expected fixed length " + len + ", but got" + result.length);
            }
        } else {
            throw this.error("fixed");
        }
        System.arraycopy(result, 0, bytes, start, len);
    }

    public void skipFixed(int length) throws IOException {
        this.checkFixed(length);
        this.doSkipFixed(length);
    }

    private void doSkipFixed(int length) throws IOException {
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            byte[] result = this.readByteArray();
            this.in.nextToken();
            if (result.length != length) {
                throw new AvroTypeException("Expected fixed length " + length + ", but got" + result.length);
            }
        } else {
            throw this.error("fixed");
        }
    }

    protected void skipFixed() throws IOException {
        this.advance(Symbol.FIXED);
        Symbol.IntCheckAction top = (Symbol.IntCheckAction)this.parser.popSymbol();
        this.doSkipFixed(top.size);
    }

    public int readEnum() throws IOException {
        this.advance(Symbol.ENUM);
        Symbol.EnumLabelsAction top = (Symbol.EnumLabelsAction)this.parser.popSymbol();
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            this.in.getText();
            int n = top.findLabel(this.in.getText());
            if (n >= 0) {
                this.in.nextToken();
                return n;
            }
            throw new AvroTypeException("Unknown symbol in enum " + this.in.getText());
        }
        throw this.error("fixed");
    }

    public long readArrayStart() throws IOException {
        this.advance(Symbol.ARRAY_START);
        if (this.in.getCurrentToken() == JsonToken.START_ARRAY) {
            this.in.nextToken();
            return this.doArrayNext();
        }
        throw this.error("array-start");
    }

    public long arrayNext() throws IOException {
        this.advance(Symbol.ITEM_END);
        return this.doArrayNext();
    }

    private long doArrayNext() throws IOException {
        if (this.in.getCurrentToken() == JsonToken.END_ARRAY) {
            this.parser.advance(Symbol.ARRAY_END);
            this.in.nextToken();
            return 0L;
        }
        return 1L;
    }

    public long skipArray() throws IOException {
        this.advance(Symbol.ARRAY_START);
        if (this.in.getCurrentToken() != JsonToken.START_ARRAY) {
            throw this.error("array-start");
        }
        this.in.skipChildren();
        this.in.nextToken();
        this.advance(Symbol.ARRAY_END);
        return 0L;
    }

    public long readMapStart() throws IOException {
        this.advance(Symbol.MAP_START);
        if (this.in.getCurrentToken() == JsonToken.START_OBJECT) {
            this.in.nextToken();
            return this.doMapNext();
        }
        throw this.error("map-start");
    }

    public long mapNext() throws IOException {
        this.advance(Symbol.ITEM_END);
        return this.doMapNext();
    }

    private long doMapNext() throws IOException {
        if (this.in.getCurrentToken() == JsonToken.END_OBJECT) {
            this.in.nextToken();
            this.advance(Symbol.MAP_END);
            return 0L;
        }
        return 1L;
    }

    public long skipMap() throws IOException {
        this.advance(Symbol.MAP_START);
        if (this.in.getCurrentToken() != JsonToken.START_OBJECT) {
            throw this.error("map-start");
        }
        this.in.skipChildren();
        this.in.nextToken();
        this.advance(Symbol.MAP_END);
        return 0L;
    }

    public int readIndex() throws IOException {
        String label;
        this.advance(Symbol.UNION);
        Symbol.Alternative a = (Symbol.Alternative)this.parser.popSymbol();
        JsonToken currentToken = this.in.getCurrentToken();
        if (currentToken == JsonToken.VALUE_NULL) {
            label = "null";
        } else if (currentToken == JsonToken.START_OBJECT && this.in.nextToken() == JsonToken.FIELD_NAME) {
            label = this.in.getText();
            this.in.nextToken();
            this.parser.pushSymbol(Symbol.UNION_END);
        } else if (a.size() == 2 && ("null".equals(a.getLabel(0)) || "null".equals(a.getLabel(1)))) {
            label = "null".equals(a.getLabel(0)) ? a.getLabel(1) : a.getLabel(0);
        } else {
            throw this.error("start-union");
        }
        int n = a.findLabel(label);
        if (n < 0) {
            throw new AvroTypeException("Unknown union branch " + label);
        }
        this.parser.pushSymbol(a.getSymbol(n));
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Symbol doAction(Symbol input, Symbol top) throws IOException {
        if (top instanceof Symbol.FieldAdjustAction) {
            List<JsonElement> node;
            Symbol.FieldAdjustAction fa = (Symbol.FieldAdjustAction)top;
            String name = fa.fname;
            if (this.currentReorderBuffer != null && (node = this.currentReorderBuffer.savedFields.get(name)) != null) {
                this.currentReorderBuffer.savedFields.remove(name);
                this.currentReorderBuffer.origParser = this.in;
                this.in = this.makeParser(node);
                return null;
            }
            if (this.in.getCurrentToken() == JsonToken.FIELD_NAME) {
                do {
                    String fn = this.in.getText();
                    this.in.nextToken();
                    if (name.equals(fn)) {
                        return null;
                    }
                    if (this.currentReorderBuffer == null) {
                        this.currentReorderBuffer = new ReorderBuffer();
                    }
                    this.currentReorderBuffer.savedFields.put(fn, ExtendedJsonDecoder.getValueAsTree(this.in));
                } while (this.in.getCurrentToken() == JsonToken.FIELD_NAME);
                this.injectDefaultValueIfAvailable(this.in, fa.fname);
                return null;
            } else {
                this.injectDefaultValueIfAvailable(this.in, fa.fname);
            }
            return null;
        } else if (top == Symbol.FIELD_END) {
            if (this.currentReorderBuffer == null || this.currentReorderBuffer.origParser == null) return null;
            this.in = this.currentReorderBuffer.origParser;
            this.currentReorderBuffer.origParser = null;
            return null;
        } else if (top == Symbol.RECORD_START) {
            if (this.in.getCurrentToken() != JsonToken.START_OBJECT) throw this.error("record-start");
            this.in.nextToken();
            this.reorderBuffers.push(this.currentReorderBuffer);
            this.currentReorderBuffer = null;
            return null;
        } else {
            if (top != Symbol.RECORD_END && top != Symbol.UNION_END) throw new AvroTypeException("Unknown action symbol " + top);
            if (this.in.getCurrentToken() != JsonToken.END_OBJECT) throw this.error(top == Symbol.RECORD_END ? "record-end" : "union-end");
            this.in.nextToken();
            if (top != Symbol.RECORD_END) return null;
            if (this.currentReorderBuffer != null && !this.currentReorderBuffer.savedFields.isEmpty()) {
                throw this.error("Unknown fields: " + this.currentReorderBuffer.savedFields.keySet());
            }
            this.currentReorderBuffer = this.reorderBuffers.pop();
        }
        return null;
    }

    private static List<JsonElement> getValueAsTree(JsonParser in) throws IOException {
        int level = 0;
        ArrayList<JsonElement> result = new ArrayList<JsonElement>();
        do {
            JsonToken t = in.getCurrentToken();
            switch (t) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++level;
                    result.add(new JsonElement(t));
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    --level;
                    result.add(new JsonElement(t));
                    break;
                }
                case FIELD_NAME: 
                case VALUE_STRING: 
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    result.add(new JsonElement(t, in.getText()));
                }
            }
            in.nextToken();
        } while (level != 0);
        result.add(new JsonElement(null));
        return result;
    }

    private JsonParser makeParser(final List<JsonElement> elements) {
        return new JsonParser(){
            int pos = 0;

            public ObjectCodec getCodec() {
                throw new UnsupportedOperationException();
            }

            public void setCodec(ObjectCodec c) {
                throw new UnsupportedOperationException();
            }

            public Version version() {
                throw new UnsupportedOperationException();
            }

            public void close() {
                throw new UnsupportedOperationException();
            }

            public JsonToken nextToken() {
                ++this.pos;
                return ((JsonElement)elements.get((int)this.pos)).token;
            }

            public JsonToken nextValue() {
                throw new UnsupportedOperationException();
            }

            public JsonParser skipChildren() {
                int level;
                JsonToken tkn = ((JsonElement)elements.get((int)this.pos)).token;
                int n = level = tkn == JsonToken.START_ARRAY || tkn == JsonToken.END_ARRAY ? 1 : 0;
                while (level > 0) {
                    switch (((JsonElement)elements.get((int)(++this.pos))).token) {
                        case START_OBJECT: 
                        case START_ARRAY: {
                            ++level;
                            break;
                        }
                        case END_OBJECT: 
                        case END_ARRAY: {
                            --level;
                        }
                    }
                }
                return this;
            }

            public boolean isClosed() {
                throw new UnsupportedOperationException();
            }

            public String getCurrentName() {
                throw new UnsupportedOperationException();
            }

            public JsonStreamContext getParsingContext() {
                throw new UnsupportedOperationException();
            }

            public JsonLocation getTokenLocation() {
                throw new UnsupportedOperationException();
            }

            public JsonLocation getCurrentLocation() {
                throw new UnsupportedOperationException();
            }

            public String getText() {
                return ((JsonElement)elements.get((int)this.pos)).value;
            }

            public char[] getTextCharacters() {
                throw new UnsupportedOperationException();
            }

            public int getTextLength() {
                throw new UnsupportedOperationException();
            }

            public int getTextOffset() {
                throw new UnsupportedOperationException();
            }

            public boolean hasTextCharacters() {
                throw new UnsupportedOperationException();
            }

            public Number getNumberValue() {
                throw new UnsupportedOperationException();
            }

            public JsonParser.NumberType getNumberType() {
                throw new UnsupportedOperationException();
            }

            public int getIntValue() {
                return Integer.parseInt(this.getText());
            }

            public long getLongValue() {
                return Long.parseLong(this.getText());
            }

            public BigInteger getBigIntegerValue() {
                throw new UnsupportedOperationException();
            }

            public float getFloatValue() {
                return Float.parseFloat(this.getText());
            }

            public double getDoubleValue() {
                return Double.parseDouble(this.getText());
            }

            public BigDecimal getDecimalValue() {
                throw new UnsupportedOperationException();
            }

            public byte[] getBinaryValue(Base64Variant b64variant) {
                throw new UnsupportedOperationException();
            }

            public String getValueAsString(String def) {
                throw new UnsupportedOperationException();
            }

            public JsonToken getCurrentToken() {
                return ((JsonElement)elements.get((int)this.pos)).token;
            }

            public int getCurrentTokenId() {
                throw new UnsupportedOperationException();
            }

            public boolean hasCurrentToken() {
                throw new UnsupportedOperationException();
            }

            public boolean hasTokenId(int id) {
                throw new UnsupportedOperationException();
            }

            public boolean hasToken(JsonToken t) {
                throw new UnsupportedOperationException();
            }

            public void clearCurrentToken() {
                throw new UnsupportedOperationException();
            }

            public JsonToken getLastClearedToken() {
                throw new UnsupportedOperationException();
            }

            public void overrideCurrentName(String name) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private AvroTypeException error(String type) {
        return new AvroTypeException("Expected " + type + ". Got " + this.in.getCurrentToken());
    }

    private void injectDefaultValueIfAvailable(JsonParser in, String fieldName) throws IOException {
        JsonToken nextToken;
        Schema.Field field = ExtendedJsonDecoder.findField(this.schema, fieldName);
        if (field == null) {
            throw new AvroTypeException("Expected field name not found: " + fieldName);
        }
        JsonNode defVal = field.defaultValue();
        if (defVal == null) {
            throw new AvroTypeException("Expected field name not found: " + fieldName);
        }
        ArrayList<JsonElement> result = new ArrayList<JsonElement>(2);
        JsonParser traverse = defVal.traverse();
        while ((nextToken = traverse.nextToken()) != null) {
            if (nextToken.isScalarValue()) {
                result.add(new JsonElement(nextToken, traverse.getText()));
                continue;
            }
            result.add(new JsonElement(nextToken));
        }
        result.add(NULL_JSON_ELEMENT);
        if (this.currentReorderBuffer == null) {
            this.currentReorderBuffer = new ReorderBuffer();
        }
        this.currentReorderBuffer.origParser = in;
        this.in = this.makeParser(result);
    }

    private static Schema.Field findField(Schema schema, String name) {
        if (schema.isNullable()) {
            return null;
        }
        if (Schema.Type.ARRAY == schema.getType()) {
            return ExtendedJsonDecoder.findField(schema.getElementType(), name);
        }
        if (Schema.Type.MAP == schema.getType()) {
            return ExtendedJsonDecoder.findField(schema.getValueType(), name);
        }
        if (schema.getField(name) != null) {
            return schema.getField(name);
        }
        Schema.Field foundField = null;
        for (Schema.Field field : schema.getFields()) {
            Schema fieldSchema = field.schema();
            switch (fieldSchema.getType()) {
                case RECORD: 
                case ARRAY: 
                case MAP: {
                    foundField = ExtendedJsonDecoder.findField(fieldSchema, name);
                    break;
                }
                case UNION: {
                    for (Schema unionSchema : fieldSchema.getTypes()) {
                        foundField = ExtendedJsonDecoder.findField(unionSchema, name);
                        if (foundField == null) continue;
                        return foundField;
                    }
                    break;
                }
            }
            if (foundField == null) continue;
            return foundField;
        }
        return null;
    }

    private static class JsonElement {
        public final JsonToken token;
        public final String value;

        public JsonElement(JsonToken t, String value) {
            this.token = t;
            this.value = value;
        }

        public JsonElement(JsonToken t) {
            this(t, null);
        }
    }

    private static class ReorderBuffer {
        public Map<String, List<JsonElement>> savedFields = new HashMap<String, List<JsonElement>>();
        public JsonParser origParser = null;

        private ReorderBuffer() {
        }
    }
}

