/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrebeat.pool;

import io.github.andrebeat.pool.Lease;
import io.github.andrebeat.pool.Pool;
import io.github.andrebeat.pool.Ref;
import io.github.andrebeat.pool.ReferenceType;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-f!\u0002\u0014(\u0003\u0003\u0001\u0004\u0002\u0003#\u0001\u0005\u000b\u0007I\u0011A#\t\u0011%\u0003!\u0011!Q\u0001\n\u0019C\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0019\")\u0001\u000b\u0001C\u0001#\u001a)Q\u000bAA\t-\"AqK\u0002BC\u0002\u0013\u0005\u0001\f\u0003\u0005]\r\t\u0005\t\u0015!\u0003Z\u0011\u0015\u0001f\u0001\"\u0001^\u0011\u0015\tg\u0001\"\u0001c\u0011\u00151g\u0001\"\u0001h\u0011\u0015Ag\u0001\"\u0001j\u0011\u0015igA\"\u0001j\u0011\u0015qgA\"\u0001j\u0011\u001dy\u0007A1Q\u0005\u0012ADaa\u001f\u0001!\u0002\u0013\t\b\u0002\u0004?\u0001\t\u0003\u0005)\u0011!A!\u0002\u0013i\b\"DA\u0004\u0001\u0011\u0005\tQ!A\u0001B\u0013%Q\tC\u0004i\u0001\u0001&\t\"!\u0005\t\u0011\u0005e\u0001\u0001)D\t\u00037A\u0001\"a\b\u0001A\u0013%\u0011\u0011\u0005\u0004\u0007\u0003O\u0001A!!\u000b\t\u0015\u0005UaC!b\u0001\n#\t\t\u0004C\u0005\u00024Y\u0011\t\u0011)A\u0005y!1\u0001K\u0006C\u0001\u0003kAa!a\u000f\u0017\t#I\u0007BBA\u001f-\u0011E\u0011\u000e\u0003\u0005\u0002@\u0001\u0001K\u0011BA!\u00119\tY\u0005\u0001C\u0001\u0002\u000b\u0005\t\u0011)C\u0005\u0003\u001bBa\"a\u0018\u0001\t\u0003\u0005)\u0011aI\u0001\n\u0013\t\t\u0007\u0003\u0005\u0002x\u0001\u0001K\u0011CA=\u0011!\tY\b\u0001Q\u0005\u0012\u0005u\u0004\u0002CA>\u0001\u0001&\t\"!!\t\u000f\u0005U\u0005\u0001)C\u000bS\"9\u0011\u0011\u0015\u0001!\n+I\u0007bBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003S\u0003A\u0011AAT\u0005Y\t%O]1z\u00052|7m[5oOF+X-^3Q_>d'B\u0001\u0015*\u0003\u0011\u0001xn\u001c7\u000b\u0005)Z\u0013!C1oIJ,'-Z1u\u0015\taS&\u0001\u0004hSRDWO\u0019\u0006\u0002]\u0005\u0011\u0011n\\\u0002\u0001+\t\tdhE\u0002\u0001ea\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012a!\u00118z%\u00164\u0007cA\u001d;y5\tq%\u0003\u0002<O\t!\u0001k\\8m!\tid\b\u0004\u0001\u0005\u000b}\u0002!\u0019\u0001!\u0003\u0003\u0005\u000b\"!\u0011\u001a\u0011\u0005M\u0012\u0015BA\"5\u0005\u001dqu\u000e\u001e5j]\u001e\f\u0001bY1qC\u000eLG/_\u000b\u0002\rB\u00111gR\u0005\u0003\u0011R\u00121!\u00138u\u0003%\u0019\u0017\r]1dSRL\b%A\u0007sK\u001a,'/\u001a8dKRK\b/Z\u000b\u0002\u0019B\u0011\u0011(T\u0005\u0003\u001d\u001e\u0012QBU3gKJ,gnY3UsB,\u0017A\u0004:fM\u0016\u0014XM\\2f)f\u0004X\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\u001bF\u000bE\u0002:\u0001qBQ\u0001R\u0003A\u0002\u0019CQAS\u0003A\u00021\u0013A!\u0013;f[N\u0011aAM\u0001\u0002eV\t\u0011\fE\u0002:5rJ!aW\u0014\u0003\u0007I+g-\u0001\u0002sAQ\u0011a\f\u0019\t\u0003?\u001ai\u0011\u0001\u0001\u0005\u0006/&\u0001\r!W\u0001\nSN$UMZ5oK\u0012$\u0012a\u0019\t\u0003g\u0011L!!\u001a\u001b\u0003\u000f\t{w\u000e\\3b]\u0006\u0019q-\u001a;\u0015\u0003q\nq\u0001Z3tiJ|\u0017\u0010F\u0001k!\t\u00194.\u0003\u0002mi\t!QK\\5u\u00031ygMZ3s'V\u001c7-Z:t\u0003\u001d\u0019wN\\:v[\u0016\fQ!\u001b;f[N,\u0012!\u001d\t\u0004eftV\"A:\u000b\u0005Q,\u0018AC2p]\u000e,(O]3oi*\u0011ao^\u0001\u0005kRLGNC\u0001y\u0003\u0011Q\u0017M^1\n\u0005i\u001c(AE!se\u0006L(\t\\8dW&tw-U;fk\u0016\fa!\u001b;f[N\u0004\u0013!N5pI\u001dLG\u000f[;cI\u0005tGM]3cK\u0006$H\u0005]8pY\u0012\n%O]1z\u00052|7m[5oOF+X-^3Q_>dG\u0005\n7jm\u0016\u00042A`A\u0002\u001b\u0005y(bAA\u0001g\u00061\u0011\r^8nS\u000eL1!!\u0002\u0000\u00055\tEo\\7jG&sG/Z4fe\u0006q\u0014n\u001c\u0013hSRDWO\u0019\u0013b]\u0012\u0014XMY3bi\u0012\u0002xn\u001c7%\u0003J\u0014\u0018-\u001f\"m_\u000e\\\u0017N\\4Rk\u0016,X\rU8pY\u0012\"C-Z2sK6,g\u000e\u001e'jm\u0016D3AEA\u0006!\r\u0019\u0014QB\u0005\u0004\u0003\u001f!$AB5oY&tW\rF\u0002k\u0003'Aa!!\u0006\u0014\u0001\u0004a\u0014!A1)\u0007M\tY!A\u0004oK^LE/Z7\u0015\u0007y\u000bi\u0002\u0003\u0004\u0002\u0016Q\u0001\r\u0001P\u0001\tiJLxJ\u001a4feR\u0019!.a\t\t\r\u0005UQ\u00031\u0001=Q\r)\u00121\u0002\u0002\n!>|G\u000eT3bg\u0016\u001cBA\u0006\u001a\u0002,A!\u0011(!\f=\u0013\r\tyc\n\u0002\u0006\u0019\u0016\f7/Z\u000b\u0002y\u0005\u0011\u0011\r\t\u000b\u0005\u0003o\tI\u0004\u0005\u0002`-!1\u0011QC\rA\u0002q\nQ\u0002[1oI2,'+\u001a7fCN,\u0017\u0001\u00055b]\u0012dW-\u00138wC2LG-\u0019;f\u0003%!(/_\"sK\u0006$X\r\u0006\u0002\u0002DA!1'!\u0012=\u0013\r\t9\u0005\u000e\u0002\u0007\u001fB$\u0018n\u001c8)\u0007q\tY!A\u001ej_\u0012:\u0017\u000e\u001e5vE\u0012\ng\u000e\u001a:fE\u0016\fG\u000f\n9p_2$\u0013I\u001d:bs\ncwnY6j]\u001e\fV/Z;f!>|G\u000e\n\u0013v]^\u0014\u0018\r]%uK6$b!a\u0011\u0002P\u0005e\u0003b\u0002\u0018\u001e\t\u0003\u0007\u0011\u0011\u000b\t\u0006g\u0005M\u0013qK\u0005\u0004\u0003+\"$\u0001\u0003\u001fcs:\fW.\u001a \u0011\tM\n)E\u0018\u0005\t\u00037j\u0002\u0013!a\u0001G\u0006)!/\u001a;ss\"\u001aQ$a\u0003\u0002\u000b&|GeZ5uQV\u0014G%\u00198ee\u0016\u0014W-\u0019;%a>|G\u000eJ!se\u0006L(\t\\8dW&tw-U;fk\u0016\u0004vn\u001c7%IUtwO]1q\u0013R,W\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019GK\u0002d\u0003KZ#!a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003c\"\u0014AC1o]>$\u0018\r^5p]&!\u0011QOA6\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eQ\u0006tG\r\\3BGF,\u0018N]3\u0015\u0005\u0005-\u0012\u0001\u00055b]\u0012dW\r\u0016:z\u0003\u000e\fX/\u001b:f)\t\ty\bE\u00034\u0003\u000b\nY\u0003\u0006\u0003\u0002\u0000\u0005\r\u0005bBACC\u0001\u0007\u0011qQ\u0001\u0007CRlun\u001d;\u0011\t\u0005%\u0015\u0011S\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006AA-\u001e:bi&|gN\u0003\u0002ui%!\u00111SAF\u0005!!UO]1uS>t\u0017a\u00035b]\u0012dW\r\u0012:bS:D3AIAM!\u0011\tY*!(\u000e\u0005\u0005=\u0014\u0002BAP\u0003_\u0012q\u0001^1jYJ,7-\u0001\u0006iC:$G.\u001a$jY2D3aIAM\u0003\u0011\u0019\u0018N_3\u0015\u0003\u0019\u000bA\u0001\\5wK\u0002")
public abstract class ArrayBlockingQueuePool<A>
implements Pool<A> {
    private final int capacity;
    private final ReferenceType referenceType;
    private final ArrayBlockingQueue<Item> items;
    public final AtomicInteger io$github$andrebeat$pool$ArrayBlockingQueuePool$$live;
    private final AtomicBoolean closed;

    @Override
    public Option<Lease<A>> tryAcquire() {
        return Pool.tryAcquire$(this);
    }

    @Override
    public Option<Lease<A>> tryAcquire(Duration atMost) {
        return Pool.tryAcquire$(this, atMost);
    }

    @Override
    public Lease<A> acquire() {
        return Pool.acquire$(this);
    }

    @Override
    public void drain() {
        Pool.drain$(this);
    }

    @Override
    public void fill() {
        Pool.fill$(this);
    }

    @Override
    public int leased() {
        return Pool.leased$(this);
    }

    @Override
    public void close() {
        Pool.close$(this);
    }

    @Override
    public AtomicBoolean closed() {
        return this.closed;
    }

    @Override
    public void io$github$andrebeat$pool$Pool$_setter_$closed_$eq(AtomicBoolean x$1) {
        this.closed = x$1;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public ReferenceType referenceType() {
        return this.referenceType;
    }

    public ArrayBlockingQueue<Item> items() {
        return this.items;
    }

    public int io$github$andrebeat$pool$ArrayBlockingQueuePool$$decrementLive() {
        return this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$live.getAndDecrement();
    }

    public void destroy(A a) {
        this.dispose(a);
        this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$decrementLive();
    }

    public abstract Item newItem(A var1);

    public void io$github$andrebeat$pool$ArrayBlockingQueuePool$$tryOffer(A a) {
        Item item = this.newItem(a);
        if (this.items().offer(item)) {
            item.offerSuccess();
        } else {
            this.destroy(a);
        }
    }

    private Option<A> tryCreate() {
        Some some;
        int n = this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$live.getAndIncrement();
        switch (n) {
            default: 
        }
        if (n < this.capacity()) {
            some = new Some(this.factory());
        } else {
            this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$decrementLive();
            some = None$.MODULE$;
        }
        return some;
    }

    public Option<A> io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem(Function0<Option<Item>> io, boolean retry) {
        None$ none$;
        block3: {
            block4: {
                while (true) {
                    boolean bl = false;
                    Some some = null;
                    Option option = (Option)io.apply();
                    if (option instanceof Some) {
                        bl = true;
                        some = (Some)option;
                        Item i = (Item)some.value();
                        if (i.isDefined()) {
                            none$ = new Some(i.get());
                            break block3;
                        }
                    }
                    if (!bl) break block4;
                    Item i = (Item)some.value();
                    i.destroy();
                    if (!retry) break;
                    retry = this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem$default$2();
                }
                none$ = None$.MODULE$;
                break block3;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem$default$2() {
        return true;
    }

    @Override
    public Lease<A> handleAcquire() {
        PoolLease poolLease;
        Option<A> item = this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem((Function0<Option<Item>>)(Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.items().poll()), this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem$default$2());
        if (item.isDefined()) {
            poolLease = new PoolLease(this, item.get());
        } else {
            PoolLease poolLease2;
            Option<A> option = this.tryCreate();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object i = some.value();
                poolLease2 = new PoolLease(this, i);
            } else if (None$.MODULE$.equals(option)) {
                poolLease2 = new PoolLease(this, this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem((Function0<Option<Item>>)(Function0 & Serializable & scala.Serializable)() -> new Some((Object)this.items().take()), this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem$default$2()).get());
            } else {
                throw new MatchError(option);
            }
            poolLease = poolLease2;
        }
        return poolLease;
    }

    @Override
    public Option<Lease<A>> handleTryAcquire() {
        Option<A> item = this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem((Function0<Option<Item>>)(Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.items().poll()), this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem$default$2());
        return item.isDefined() ? new Some((Object)new PoolLease(this, item.get())) : this.tryCreate().map((Function1 & Serializable & scala.Serializable)x$1 -> new PoolLease(this, x$1));
    }

    @Override
    public Option<Lease<A>> handleTryAcquire(Duration atMost) {
        Some some;
        Option<A> item = this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem((Function0<Option<Item>>)(Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.items().poll()), this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem$default$2());
        if (item.isDefined()) {
            some = new Some((Object)new PoolLease(this, item.get()));
        } else {
            Some some2;
            Option<A> option = this.tryCreate();
            if (option instanceof Some) {
                Some some3 = (Some)option;
                Object i = some3.value();
                some2 = new Some((Object)new PoolLease(this, i));
            } else if (None$.MODULE$.equals(option)) {
                some2 = this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$unwrapItem((Function0<Option<Item>>)(Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.items().poll(atMost.toNanos(), TimeUnit.NANOSECONDS)), false).map((Function1 & Serializable & scala.Serializable)x$2 -> new PoolLease(this, x$2));
            } else {
                throw new MatchError(option);
            }
            some = some2;
        }
        return some;
    }

    @Override
    public final void handleDrain() {
        Option i;
        while ((i = Option$.MODULE$.apply((Object)this.items().poll())).nonEmpty()) {
            ((Item)i.get()).destroy();
        }
    }

    @Override
    public final void handleFill() {
        Option<A> ao;
        while ((ao = this.tryCreate()).nonEmpty()) {
            Object a = ao.get();
            this.reset(a);
            this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$tryOffer(a);
        }
    }

    @Override
    public int size() {
        return this.items().size();
    }

    @Override
    public int live() {
        return this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$live.get();
    }

    public ArrayBlockingQueuePool(int capacity, ReferenceType referenceType) {
        this.capacity = capacity;
        this.referenceType = referenceType;
        Pool.$init$(this);
        this.items = new ArrayBlockingQueue(capacity);
        this.io$github$andrebeat$pool$ArrayBlockingQueuePool$$live = new AtomicInteger(0);
    }

    public abstract class Item {
        private final Ref<A> r;
        public final /* synthetic */ ArrayBlockingQueuePool $outer;

        public Ref<A> r() {
            return this.r;
        }

        public boolean isDefined() {
            Option ro = this.r().toOption();
            return ro.isDefined() && this.io$github$andrebeat$pool$ArrayBlockingQueuePool$Item$$$outer().healthCheck(ro.get());
        }

        /*
         * WARNING - void declaration
         */
        public A get() {
            void var1_1;
            Object a = this.r().toOption().get();
            this.consume();
            return var1_1;
        }

        public void destroy() {
            this.r().toOption().map((Function1 & Serializable & scala.Serializable)a -> {
                Item.$anonfun$destroy$1(this, a);
                return BoxedUnit.UNIT;
            });
            this.io$github$andrebeat$pool$ArrayBlockingQueuePool$Item$$$outer().io$github$andrebeat$pool$ArrayBlockingQueuePool$$decrementLive();
            this.consume();
        }

        public abstract void offerSuccess();

        public abstract void consume();

        public /* synthetic */ ArrayBlockingQueuePool io$github$andrebeat$pool$ArrayBlockingQueuePool$Item$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$destroy$1(Item $this, Object a) {
            $this.io$github$andrebeat$pool$ArrayBlockingQueuePool$Item$$$outer().dispose(a);
        }

        public Item(ArrayBlockingQueuePool $outer, Ref<A> r) {
            this.r = r;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class PoolLease
    implements Lease<A> {
        private final A a;
        private final AtomicBoolean io$github$andrebeat$pool$Lease$$dirty;
        public final /* synthetic */ ArrayBlockingQueuePool $outer;

        @Override
        public A get() {
            return Lease.get$(this);
        }

        @Override
        public void release() {
            Lease.release$(this);
        }

        @Override
        public void invalidate() {
            Lease.invalidate$(this);
        }

        @Override
        public <B> B apply(Function1<A, B> f) {
            return (B)Lease.apply$(this, f);
        }

        @Override
        public <B> B use(Function1<A, B> f) {
            return (B)Lease.use$(this, f);
        }

        @Override
        public AtomicBoolean io$github$andrebeat$pool$Lease$$dirty() {
            return this.io$github$andrebeat$pool$Lease$$dirty;
        }

        @Override
        public final void io$github$andrebeat$pool$Lease$_setter_$io$github$andrebeat$pool$Lease$$dirty_$eq(AtomicBoolean x$1) {
            this.io$github$andrebeat$pool$Lease$$dirty = x$1;
        }

        @Override
        public A a() {
            return this.a;
        }

        @Override
        public void handleRelease() {
            if (!this.io$github$andrebeat$pool$ArrayBlockingQueuePool$PoolLease$$$outer().closed().get()) {
                this.io$github$andrebeat$pool$ArrayBlockingQueuePool$PoolLease$$$outer().reset(this.a());
                this.io$github$andrebeat$pool$ArrayBlockingQueuePool$PoolLease$$$outer().io$github$andrebeat$pool$ArrayBlockingQueuePool$$tryOffer(this.a());
            } else {
                this.io$github$andrebeat$pool$ArrayBlockingQueuePool$PoolLease$$$outer().destroy(this.a());
            }
        }

        @Override
        public void handleInvalidate() {
            this.io$github$andrebeat$pool$ArrayBlockingQueuePool$PoolLease$$$outer().destroy(this.a());
        }

        public /* synthetic */ ArrayBlockingQueuePool io$github$andrebeat$pool$ArrayBlockingQueuePool$PoolLease$$$outer() {
            return this.$outer;
        }

        public PoolLease(ArrayBlockingQueuePool $outer, A a) {
            this.a = a;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Lease.$init$(this);
        }
    }
}

