/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.api;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import ModernDocking.exception.DockableRegistrationFailureException;
import ModernDocking.exception.DockingLayoutException;
import ModernDocking.internal.DockableProperties;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockingInternal;
import ModernDocking.layouts.ApplicationLayout;
import ModernDocking.layouts.DockingLayoutNode;
import ModernDocking.layouts.DockingSimplePanelNode;
import ModernDocking.layouts.DockingSplitPanelNode;
import ModernDocking.layouts.DockingTabPanelNode;
import ModernDocking.layouts.WindowLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class LayoutPersistenceAPI {
    private static final String NL = "\n";
    private final DockingAPI docking;

    protected LayoutPersistenceAPI(DockingAPI docking) {
        this.docking = docking;
    }

    public void saveLayoutToFile(File file, ApplicationLayout layout) throws DockingLayoutException {
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new DockingLayoutException(e);
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            XMLStreamWriter writer = factory.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeCharacters(NL);
            writer.writeStartElement("app-layout");
            this.saveLayoutToFile(writer, layout.getMainFrameLayout(), true);
            for (WindowLayout frameLayout : layout.getFloatingFrameLayouts()) {
                this.saveLayoutToFile(writer, frameLayout, false);
            }
            writer.writeStartElement("undocked");
            writer.writeCharacters(NL);
            for (Dockable dockable : DockingInternal.get(this.docking).getDockables()) {
                if (this.docking.isDocked(dockable)) continue;
                DockableWrapper wrapper = DockingInternal.get(this.docking).getWrapper(dockable);
                this.writeSimpleNodeToFile(writer, new DockingSimplePanelNode(this.docking, dockable.getPersistentID(), dockable.getClass().getCanonicalName(), DockableProperties.saveProperties(wrapper)));
            }
            writer.writeEndElement();
            writer.writeCharacters(NL);
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (Exception e) {
            throw new DockingLayoutException(e);
        }
    }

    public ApplicationLayout loadApplicationLayoutFromFile(File file) throws DockingLayoutException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = null;
        try {
            ApplicationLayout applicationLayout;
            block19: {
                InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    reader = factory.createXMLStreamReader(in);
                    ApplicationLayout layout = new ApplicationLayout();
                    while (reader.hasNext()) {
                        int next = reader.nextTag();
                        if (next == 1 && reader.getLocalName().equals("layout")) {
                            layout.addFrame(this.readLayoutFromReader(reader));
                            continue;
                        }
                        if (next == 1 && reader.getLocalName().equals("undocked")) {
                            this.readUndocked(reader);
                            continue;
                        }
                        if (next != 2 || !reader.getLocalName().equals("app-layout")) continue;
                        break;
                    }
                    applicationLayout = layout;
                    if (in == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new DockingLayoutException(e);
                    }
                }
                in.close();
            }
            return applicationLayout;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    private void readUndocked(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            int next = reader.nextTag();
            if (next == 1) {
                if (!reader.getLocalName().equals("simple")) continue;
                DockingSimplePanelNode node = this.readSimpleNodeFromFile(reader);
                try {
                    DockableWrapper wrapper = DockingInternal.get(this.docking).getWrapper(DockingInternal.get(this.docking).getDockable(node.getPersistentID()));
                    DockableProperties.configureProperties(wrapper, node.getProperties());
                }
                catch (DockableRegistrationFailureException dockableRegistrationFailureException) {}
                continue;
            }
            if (next != 2 || !reader.getLocalName().equals("undocked")) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveWindowLayoutToFile(File file, WindowLayout layout) {
        XMLStreamWriter writer;
        file.getParentFile().mkdirs();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            writer = factory.createXMLStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        try {
            writer.writeStartDocument();
            this.saveLayoutToFile(writer, layout, false);
            writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                writer.close();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void saveLayoutToFile(XMLStreamWriter writer, WindowLayout layout, boolean isMainFrame) throws XMLStreamException {
        writer.writeCharacters(NL);
        writer.writeStartElement("layout");
        writer.writeAttribute("main-frame", String.valueOf(isMainFrame));
        writer.writeAttribute("location", layout.getLocation().x + "," + layout.getLocation().y);
        writer.writeAttribute("size", layout.getSize().width + "," + layout.getSize().height);
        writer.writeAttribute("state", String.valueOf(layout.getState()));
        if (layout.getMaximizedDockable() != null) {
            writer.writeAttribute("max-dockable", layout.getMaximizedDockable());
        }
        writer.writeCharacters(NL);
        writer.writeStartElement("westToolbar");
        writer.writeCharacters(NL);
        for (String id : layout.getWestUnpinnedToolbarIDs()) {
            writer.writeStartElement("dockable");
            writer.writeAttribute("id", id);
            writer.writeEndElement();
            writer.writeCharacters(NL);
        }
        writer.writeEndElement();
        writer.writeCharacters(NL);
        writer.writeStartElement("eastToolbar");
        writer.writeCharacters(NL);
        for (String id : layout.getEastUnpinnedToolbarIDs()) {
            writer.writeStartElement("dockable");
            writer.writeAttribute("id", id);
            writer.writeEndElement();
            writer.writeCharacters(NL);
        }
        writer.writeEndElement();
        writer.writeCharacters(NL);
        writer.writeStartElement("southToolbar");
        writer.writeCharacters(NL);
        for (String id : layout.getSouthUnpinnedToolbarIDs()) {
            writer.writeStartElement("dockable");
            writer.writeAttribute("id", id);
            writer.writeEndElement();
            writer.writeCharacters(NL);
        }
        writer.writeEndElement();
        writer.writeCharacters(NL);
        this.writeNodeToFile(writer, layout.getRootNode());
        writer.writeEndElement();
        writer.writeCharacters(NL);
    }

    private void writeNodeToFile(XMLStreamWriter writer, DockingLayoutNode node) throws XMLStreamException {
        if (node instanceof DockingSimplePanelNode) {
            this.writeSimpleNodeToFile(writer, (DockingSimplePanelNode)node);
        } else if (node instanceof DockingSplitPanelNode) {
            this.writeSplitNodeToFile(writer, (DockingSplitPanelNode)node);
        } else if (node instanceof DockingTabPanelNode) {
            this.writeTabbedNodeToFile(writer, (DockingTabPanelNode)node);
        }
    }

    private void writeSimpleNodeToFile(XMLStreamWriter writer, DockingSimplePanelNode node) throws XMLStreamException {
        writer.writeStartElement("simple");
        writer.writeAttribute("persistentID", node.getPersistentID());
        writer.writeAttribute("class-name", DockingInternal.get(this.docking).getDockable(node.getPersistentID()).getClass().getCanonicalName());
        writer.writeCharacters(NL);
        writer.writeStartElement("properties");
        Map<String, String> properties = node.getProperties();
        for (String key : properties.keySet()) {
            String value = properties.get(key);
            if (value == null) continue;
            writer.writeAttribute(key, value);
        }
        writer.writeEndElement();
        writer.writeCharacters(NL);
        writer.writeEndElement();
        writer.writeCharacters(NL);
    }

    private void writeSplitNodeToFile(XMLStreamWriter writer, DockingSplitPanelNode node) throws XMLStreamException {
        writer.writeStartElement("split");
        writer.writeAttribute("orientation", String.valueOf(node.getOrientation()));
        writer.writeAttribute("divider-proportion", String.valueOf(node.getDividerProportion()));
        writer.writeCharacters(NL);
        writer.writeStartElement("left");
        writer.writeCharacters(NL);
        this.writeNodeToFile(writer, node.getLeft());
        writer.writeEndElement();
        writer.writeCharacters(NL);
        writer.writeStartElement("right");
        writer.writeCharacters(NL);
        this.writeNodeToFile(writer, node.getRight());
        writer.writeEndElement();
        writer.writeCharacters(NL);
        writer.writeEndElement();
        writer.writeCharacters(NL);
    }

    private void writeTabbedNodeToFile(XMLStreamWriter writer, DockingTabPanelNode node) throws XMLStreamException {
        writer.writeStartElement("tabbed");
        writer.writeCharacters(NL);
        writer.writeStartElement("selectedTab");
        writer.writeAttribute("persistentID", node.getSelectedTabID());
        writer.writeCharacters(NL);
        writer.writeEndElement();
        writer.writeCharacters(NL);
        for (DockingSimplePanelNode simpleNode : node.getPersistentIDs()) {
            writer.writeStartElement("tab");
            writer.writeAttribute("persistentID", simpleNode.getPersistentID());
            writer.writeCharacters(NL);
            writer.writeStartElement("properties");
            Map<String, String> properties = simpleNode.getProperties();
            for (String key : properties.keySet()) {
                String value = properties.get(key);
                if (value == null) continue;
                writer.writeAttribute(key, value);
            }
            writer.writeEndElement();
            writer.writeCharacters(NL);
            writer.writeEndElement();
            writer.writeCharacters(NL);
        }
        writer.writeEndElement();
        writer.writeCharacters(NL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowLayout loadWindowLayoutFromFile(File file) {
        XMLStreamReader reader;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            reader = factory.createXMLStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        WindowLayout layout = null;
        try {
            while (reader.hasNext()) {
                int next = reader.nextTag();
                if (next != 1 || !reader.getLocalName().equals("layout")) continue;
                layout = this.readLayoutFromReader(reader);
                break;
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
        return layout;
    }

    private WindowLayout readLayoutFromReader(XMLStreamReader reader) throws XMLStreamException {
        boolean isMainFrame = Boolean.parseBoolean(reader.getAttributeValue(0));
        String locStr = reader.getAttributeValue(1);
        String sizeStr = reader.getAttributeValue(2);
        int state = Integer.parseInt(reader.getAttributeValue(3));
        String maximizedDockable = reader.getAttributeCount() >= 5 ? reader.getAttributeValue(4) : null;
        Point location = new Point(Integer.parseInt(locStr.substring(0, locStr.indexOf(","))), Integer.parseInt(locStr.substring(locStr.indexOf(",") + 1)));
        Dimension size = new Dimension(Integer.parseInt(sizeStr.substring(0, sizeStr.indexOf(","))), Integer.parseInt(sizeStr.substring(sizeStr.indexOf(",") + 1)));
        List<String> westToolbar = this.readToolbarFromFile(reader, "westToolbar");
        List<String> eastToolbar = this.readToolbarFromFile(reader, "eastToolbar");
        List<String> southToolbar = this.readToolbarFromFile(reader, "southToolbar");
        WindowLayout layout = new WindowLayout(isMainFrame, location, size, state, this.readNodeFromFile(reader, "layout"));
        layout.setWestUnpinnedToolbarIDs(westToolbar);
        layout.setEastUnpinnedToolbarIDs(eastToolbar);
        layout.setSouthUnpinnedToolbarIDs(southToolbar);
        layout.setMaximizedDockable(maximizedDockable);
        return layout;
    }

    private List<String> readToolbarFromFile(XMLStreamReader reader, String name) throws XMLStreamException {
        ArrayList<String> ids = new ArrayList<String>();
        while (reader.hasNext()) {
            int next = reader.nextTag();
            if (next == 1) {
                if (!reader.getLocalName().equals("dockable")) continue;
                ids.add(reader.getAttributeValue(0));
                continue;
            }
            if (next != 2 || !reader.getLocalName().equals(name)) continue;
            break;
        }
        return ids;
    }

    private DockingLayoutNode readNodeFromFile(XMLStreamReader reader, String name) throws XMLStreamException {
        DockingLayoutNode node = null;
        while (reader.hasNext()) {
            int next = reader.nextTag();
            if (next == 1) {
                if (reader.getLocalName().equals("simple")) {
                    node = this.readSimpleNodeFromFile(reader);
                    continue;
                }
                if (reader.getLocalName().equals("split")) {
                    node = this.readSplitNodeFromFile(reader);
                    continue;
                }
                if (!reader.getLocalName().equals("tabbed")) continue;
                node = this.readTabNodeFromFile(reader);
                continue;
            }
            if (next != 2 || !reader.getLocalName().equals(name)) continue;
            break;
        }
        return node;
    }

    private DockingSimplePanelNode readSimpleNodeFromFile(XMLStreamReader reader) throws XMLStreamException {
        String persistentID = reader.getAttributeValue(0);
        String className = reader.getAttributeValue(1);
        return new DockingSimplePanelNode(this.docking, persistentID, className, this.readProperties(reader));
    }

    private Map<String, String> readProperties(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, String> properties = new HashMap<String, String>();
        while (reader.hasNext()) {
            int next = reader.nextTag();
            if (next == 1) {
                if (!reader.getLocalName().equals("properties")) continue;
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    properties.put(String.valueOf(reader.getAttributeName(i)), reader.getAttributeValue(i));
                }
                continue;
            }
            if (next != 2 || !reader.getLocalName().equals("properties")) continue;
            break;
        }
        return properties;
    }

    private DockingSplitPanelNode readSplitNodeFromFile(XMLStreamReader reader) throws XMLStreamException {
        DockingLayoutNode left = null;
        DockingLayoutNode right = null;
        int orientation = Integer.parseInt(reader.getAttributeValue(0));
        double dividerProportion = Double.parseDouble(reader.getAttributeValue(1));
        if (dividerProportion < 0.0) {
            dividerProportion = 0.0;
        } else if (dividerProportion > 1.0) {
            dividerProportion = 1.0;
        }
        while (reader.hasNext()) {
            int next = reader.nextTag();
            if (next == 1) {
                if (reader.getLocalName().equals("left")) {
                    left = this.readNodeFromFile(reader, "left");
                    continue;
                }
                if (!reader.getLocalName().equals("right")) continue;
                right = this.readNodeFromFile(reader, "right");
                continue;
            }
            if (next != 2 || !reader.getLocalName().equals("split")) continue;
            break;
        }
        return new DockingSplitPanelNode(this.docking, left, right, orientation, dividerProportion);
    }

    private DockingTabPanelNode readTabNodeFromFile(XMLStreamReader reader) throws XMLStreamException {
        DockingTabPanelNode node = null;
        String currentPersistentID = "";
        while (reader.hasNext()) {
            int next = reader.nextTag();
            if (next == 1 && reader.getLocalName().equals("selectedTab")) {
                String persistentID = reader.getAttributeValue(0);
                node = new DockingTabPanelNode(this.docking, persistentID);
                continue;
            }
            if (next == 1 && reader.getLocalName().equals("tab")) {
                currentPersistentID = reader.getAttributeValue(0);
                if (node == null) continue;
                node.addTab(currentPersistentID);
                continue;
            }
            if (next == 1 && reader.getLocalName().equals("properties")) {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    properties.put(String.valueOf(reader.getAttributeName(i)), reader.getAttributeValue(i));
                }
                if (node == null) continue;
                node.setProperties(currentPersistentID, properties);
                continue;
            }
            if (next != 2 || !reader.getLocalName().equals("tabbed")) continue;
            break;
        }
        return node;
    }
}

