/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.api;

import ModernDocking.Dockable;
import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.internal.DockableToolbar;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockedSimplePanel;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.internal.DockingInternal;
import ModernDocking.internal.DockingPanel;
import ModernDocking.settings.Settings;
import ModernDocking.ui.ToolbarLocation;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class RootDockingPanelAPI
extends DockingPanel {
    private DockingAPI docking = null;
    private Window window = null;
    private DockingPanel panel = null;
    private JPanel emptyPanel = new JPanel();
    private boolean pinningSupported = false;
    private int pinningLayer = JLayeredPane.MODAL_LAYER;
    private DockableToolbar southToolbar = null;
    private DockableToolbar westToolbar = null;
    private DockableToolbar eastToolbar = null;
    private EnumSet<ToolbarLocation> supportedToolbars = EnumSet.noneOf(ToolbarLocation.class);

    protected RootDockingPanelAPI() {
        this.setLayout(new GridBagLayout());
    }

    protected RootDockingPanelAPI(DockingAPI docking, Window window) {
        this.setLayout(new GridBagLayout());
        this.window = window;
        this.docking = docking;
        if (window instanceof JFrame) {
            docking.registerDockingPanel(this, (JFrame)window);
        } else {
            docking.registerDockingPanel(this, (JDialog)window);
        }
        this.southToolbar = new DockableToolbar(docking, window, this, ToolbarLocation.SOUTH);
        this.westToolbar = new DockableToolbar(docking, window, this, ToolbarLocation.WEST);
        this.eastToolbar = new DockableToolbar(docking, window, this, ToolbarLocation.EAST);
        this.supportedToolbars = EnumSet.allOf(ToolbarLocation.class);
        this.pinningSupported = !this.supportedToolbars.isEmpty();
    }

    protected RootDockingPanelAPI(DockingAPI docking, Window window, EnumSet<ToolbarLocation> supportedToolbars) {
        this(docking, window);
        this.supportedToolbars = supportedToolbars;
        this.pinningSupported = !supportedToolbars.isEmpty();
    }

    public void setWindow(Window window) {
        if (this.window != null) {
            this.docking.deregisterDockingPanel(this.window);
        }
        this.window = window;
        if (window instanceof JFrame) {
            this.docking.registerDockingPanel(this, (JFrame)window);
        } else {
            this.docking.registerDockingPanel(this, (JDialog)window);
        }
        this.southToolbar = new DockableToolbar(this.docking, window, this, ToolbarLocation.SOUTH);
        this.westToolbar = new DockableToolbar(this.docking, window, this, ToolbarLocation.WEST);
        this.eastToolbar = new DockableToolbar(this.docking, window, this, ToolbarLocation.EAST);
        this.supportedToolbars = EnumSet.allOf(ToolbarLocation.class);
    }

    public Window getWindow() {
        return this.window;
    }

    public void setEmptyPanel(JPanel panel) {
        this.emptyPanel = panel;
    }

    public boolean isPinningSupported() {
        if (this.supportedToolbars.isEmpty()) {
            return false;
        }
        return this.pinningSupported;
    }

    public void setPinningSupported(boolean supported) {
        this.pinningSupported = supported;
    }

    public int getPinningLayer() {
        return this.pinningLayer;
    }

    public void setPinningLayer(int layer) {
        this.pinningLayer = layer;
    }

    public DockingPanel getPanel() {
        return this.panel;
    }

    public boolean isEmpty() {
        return this.panel == null;
    }

    public void setPanel(DockingPanel panel) {
        this.panel = panel;
        if (panel != null) {
            this.panel.setParent(this);
            this.createContents();
        }
    }

    private boolean removeExistingPanel() {
        this.remove(this.emptyPanel);
        if (this.panel != null) {
            this.remove(this.panel);
            this.panel = null;
            return true;
        }
        return false;
    }

    @Override
    public void removeNotify() {
        if (this.docking != null) {
            Window rootWindow = (Window)SwingUtilities.getRoot(this);
            this.docking.deregisterDockingPanel(rootWindow);
        }
        super.removeNotify();
    }

    @Override
    public void setParent(DockingPanel parent) {
    }

    @Override
    public void dock(Dockable dockable, DockingRegion region, double dividerProportion) {
        DockableWrapper wrapper = DockingInternal.get(this.docking).getWrapper(dockable);
        if (this.panel != null) {
            this.panel.dock(dockable, region, dividerProportion);
        } else if (Settings.alwaysDisplayTabsMode(dockable)) {
            this.setPanel(new DockedTabbedPanel(this.docking, wrapper));
            wrapper.setWindow(this.window);
        } else {
            this.setPanel(new DockedSimplePanel(this.docking, wrapper));
            wrapper.setWindow(this.window);
        }
    }

    @Override
    public void undock(Dockable dockable) {
        if (this.supportedToolbars.contains((Object)ToolbarLocation.WEST) && this.westToolbar.hasDockable(dockable)) {
            this.westToolbar.removeDockable(dockable);
        } else if (this.supportedToolbars.contains((Object)ToolbarLocation.EAST) && this.eastToolbar.hasDockable(dockable)) {
            this.eastToolbar.removeDockable(dockable);
        } else if (this.supportedToolbars.contains((Object)ToolbarLocation.SOUTH) && this.southToolbar.hasDockable(dockable)) {
            this.southToolbar.removeDockable(dockable);
        }
        this.createContents();
    }

    @Override
    public void replaceChild(DockingPanel child, DockingPanel newChild) {
        if (this.panel == child) {
            this.setPanel(newChild);
        }
    }

    @Override
    public void removeChild(DockingPanel child) {
        if (child == this.panel && this.removeExistingPanel()) {
            this.createContents();
        }
    }

    public void setDockablePinned(Dockable dockable) {
        if (this.supportedToolbars.contains((Object)ToolbarLocation.WEST) && this.westToolbar.hasDockable(dockable)) {
            this.westToolbar.removeDockable(dockable);
            this.dock(dockable, DockingRegion.WEST, 0.25);
        } else if (this.supportedToolbars.contains((Object)ToolbarLocation.EAST) && this.eastToolbar.hasDockable(dockable)) {
            this.eastToolbar.removeDockable(dockable);
            this.dock(dockable, DockingRegion.EAST, 0.25);
        } else if (this.supportedToolbars.contains((Object)ToolbarLocation.SOUTH) && this.southToolbar.hasDockable(dockable)) {
            this.southToolbar.removeDockable(dockable);
            this.dock(dockable, DockingRegion.SOUTH, 0.25);
        }
        this.createContents();
    }

    public void setDockableUnpinned(Dockable dockable, ToolbarLocation location) {
        if (!this.isPinningSupported()) {
            return;
        }
        switch (location) {
            case WEST: {
                if (!this.supportedToolbars.contains((Object)ToolbarLocation.WEST)) break;
                this.westToolbar.addDockable(dockable);
                break;
            }
            case SOUTH: {
                if (!this.supportedToolbars.contains((Object)ToolbarLocation.SOUTH)) break;
                this.southToolbar.addDockable(dockable);
                break;
            }
            case EAST: {
                if (!this.supportedToolbars.contains((Object)ToolbarLocation.EAST)) break;
                this.eastToolbar.addDockable(dockable);
            }
        }
        this.createContents();
    }

    public List<String> unpinnedPersistentIDs(ToolbarLocation location) {
        switch (location) {
            case WEST: {
                return this.westToolbar.getPersistentIDs();
            }
            case EAST: {
                return this.eastToolbar.getPersistentIDs();
            }
            case SOUTH: {
                return this.southToolbar.getPersistentIDs();
            }
        }
        return Collections.emptyList();
    }

    private void createContents() {
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 3;
        if (this.isPinningSupported() && this.westToolbar.shouldDisplay()) {
            this.add((Component)this.westToolbar, gbc);
            ++gbc.gridx;
        }
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        if (this.panel == null) {
            this.add((Component)this.emptyPanel, gbc);
        } else {
            this.add((Component)this.panel, gbc);
        }
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 3;
        if (this.isPinningSupported() && this.eastToolbar.shouldDisplay()) {
            this.add((Component)this.eastToolbar, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        if (this.isPinningSupported() && this.southToolbar.shouldDisplay()) {
            this.add((Component)this.southToolbar, gbc);
        }
        this.revalidate();
        this.repaint();
    }

    public void hideUnpinnedPanels() {
        if (this.westToolbar != null) {
            this.westToolbar.hideAll();
        }
        if (this.southToolbar != null) {
            this.southToolbar.hideAll();
        }
        if (this.eastToolbar != null) {
            this.eastToolbar.hideAll();
        }
    }

    public List<String> getWestUnpinnedToolbarIDs() {
        if (this.westToolbar == null) {
            return Collections.emptyList();
        }
        return this.westToolbar.getPersistentIDs();
    }

    public List<String> getEastUnpinnedToolbarIDs() {
        if (this.eastToolbar == null) {
            return Collections.emptyList();
        }
        return this.eastToolbar.getPersistentIDs();
    }

    public List<String> getSouthUnpinnedToolbarIDs() {
        if (this.southToolbar == null) {
            return Collections.emptyList();
        }
        return this.southToolbar.getPersistentIDs();
    }

    public boolean isLocationSupported(ToolbarLocation location) {
        return this.supportedToolbars.contains((Object)location);
    }

    public void updateLAF() {
        if (this.southToolbar != null) {
            SwingUtilities.updateComponentTreeUI(this.southToolbar);
        }
        if (this.westToolbar != null) {
            SwingUtilities.updateComponentTreeUI(this.westToolbar);
        }
        if (this.eastToolbar != null) {
            SwingUtilities.updateComponentTreeUI(this.eastToolbar);
        }
    }
}

