/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.api;

import ModernDocking.DockingRegion;
import ModernDocking.api.DockingAPI;
import ModernDocking.layouts.ApplicationLayout;
import ModernDocking.layouts.DockingLayoutNode;
import ModernDocking.layouts.DockingLayoutRootNode;
import ModernDocking.layouts.DockingTabPanelNode;
import ModernDocking.layouts.WindowLayout;
import java.util.HashMap;
import java.util.Map;

public class WindowLayoutBuilderAPI {
    private final DockingLayoutRootNode rootNode;
    private final Map<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();

    protected WindowLayoutBuilderAPI(DockingAPI docking, String firstID) {
        this.rootNode = new DockingLayoutRootNode(docking);
        this.rootNode.dock(firstID, DockingRegion.CENTER, 0.0);
    }

    public WindowLayoutBuilderAPI dock(String sourceID, String targetID) {
        return this.dock(sourceID, targetID, DockingRegion.CENTER);
    }

    public WindowLayoutBuilderAPI dock(String sourceID, String targetID, DockingRegion region) {
        return this.dock(sourceID, targetID, region, 0.5);
    }

    public WindowLayoutBuilderAPI dock(String sourceID, String targetID, DockingRegion region, double dividerProportion) {
        DockingLayoutNode node = this.findNode(targetID);
        if (this.exists(sourceID)) {
            throw new RuntimeException("Dockable already in layout: " + sourceID);
        }
        node.dock(sourceID, region, dividerProportion);
        return this;
    }

    public WindowLayoutBuilderAPI dockToRoot(String persistentID, DockingRegion region) {
        return this.dockToRoot(persistentID, region, 0.25);
    }

    public WindowLayoutBuilderAPI dockToRoot(String persistentID, DockingRegion region, double dividerProportion) {
        if (this.exists(persistentID)) {
            throw new RuntimeException("Dockable already in layout: " + persistentID);
        }
        this.rootNode.dock(persistentID, region, dividerProportion);
        return this;
    }

    public WindowLayoutBuilderAPI display(String persistentID) {
        DockingLayoutNode node = this.findNode(persistentID);
        if (node.getParent() != null && node.getParent() instanceof DockingTabPanelNode) {
            ((DockingTabPanelNode)node.getParent()).bringToFront(node);
        }
        return this;
    }

    public WindowLayoutBuilderAPI addProperty(String persistentID, String property, String value) {
        Map props = this.properties.getOrDefault(persistentID, new HashMap());
        props.put(property, value);
        this.properties.put(persistentID, props);
        return this;
    }

    public WindowLayout build() {
        return new WindowLayout(this.rootNode.getNode());
    }

    public ApplicationLayout buildApplicationLayout() {
        return new ApplicationLayout(this.build());
    }

    public DockingLayoutNode findNode(String persistentID) {
        DockingLayoutNode node = this.rootNode.findNode(persistentID);
        if (node == null) {
            throw new RuntimeException("No node for dockable ID found: " + persistentID);
        }
        return node;
    }

    private boolean exists(String persistentID) {
        DockingLayoutNode node = this.rootNode.findNode(persistentID);
        return node != null;
    }
}

