/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.floating;

import ModernDocking.Dockable;
import ModernDocking.DockableStyle;
import ModernDocking.DockingRegion;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.floating.DockingHandle;
import ModernDocking.internal.DisplayPanel;
import ModernDocking.internal.DockedSimplePanel;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.ui.DockingSettings;
import ModernDocking.ui.ToolbarLocation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DockingHandles {
    private final DockingHandle rootCenter = new DockingHandle(DockingRegion.CENTER, true);
    private final DockingHandle rootWest = new DockingHandle(DockingRegion.WEST, true);
    private final DockingHandle rootNorth = new DockingHandle(DockingRegion.NORTH, true);
    private final DockingHandle rootEast = new DockingHandle(DockingRegion.EAST, true);
    private final DockingHandle rootSouth = new DockingHandle(DockingRegion.SOUTH, true);
    private final DockingHandle pinWest = new DockingHandle(DockingRegion.WEST);
    private final DockingHandle pinEast = new DockingHandle(DockingRegion.EAST);
    private final DockingHandle pinSouth = new DockingHandle(DockingRegion.SOUTH);
    private final DockingHandle dockableCenter = new DockingHandle(DockingRegion.CENTER, false);
    private final DockingHandle dockableWest = new DockingHandle(DockingRegion.WEST, false);
    private final DockingHandle dockableNorth = new DockingHandle(DockingRegion.NORTH, false);
    private final DockingHandle dockableEast = new DockingHandle(DockingRegion.EAST, false);
    private final DockingHandle dockableSouth = new DockingHandle(DockingRegion.SOUTH, false);
    private final Map<DockingHandle, Boolean> mouseOver = new HashMap<DockingHandle, Boolean>();
    private DockingRegion rootRegion = null;
    private DockingRegion dockableRegion = null;
    private ToolbarLocation pinRegion = null;
    private final JFrame utilFrame;
    private final RootDockingPanelAPI targetRoot;
    private JPanel floating;
    private Dockable targetDockable = null;
    public boolean overTab = false;

    public DockingHandles(JFrame utilFrame, RootDockingPanelAPI root) {
        this.utilFrame = utilFrame;
        this.targetRoot = root;
        this.setupHandle(this.rootCenter);
        this.setupHandle(this.rootWest);
        this.setupHandle(this.rootNorth);
        this.setupHandle(this.rootEast);
        this.setupHandle(this.rootSouth);
        this.setupHandle(this.pinWest);
        this.setupHandle(this.pinEast);
        this.setupHandle(this.pinSouth);
        this.setupHandle(this.dockableCenter);
        this.setupHandle(this.dockableWest);
        this.setupHandle(this.dockableNorth);
        this.setupHandle(this.dockableEast);
        this.setupHandle(this.dockableSouth);
    }

    public DockingRegion getDockableRegion() {
        return this.dockableRegion;
    }

    public DockingRegion getRootRegion() {
        return this.rootRegion;
    }

    public ToolbarLocation getPinningRegion() {
        return this.pinRegion;
    }

    public void setActive(boolean active) {
        this.utilFrame.setVisible(active);
    }

    public void setFloating(JPanel dockable) {
        this.floating = dockable;
    }

    private void setupHandle(DockingHandle label) {
        this.mouseOver.put(label, false);
        this.utilFrame.add(label);
    }

    private void setRootHandleLocations() {
        this.rootCenter.setVisible(this.targetRoot != null && this.targetRoot.getPanel() == null);
        this.rootWest.setVisible(this.targetRoot != null && this.targetRoot.getPanel() != null && this.isRegionAllowed(DockingRegion.WEST));
        this.rootNorth.setVisible(this.targetRoot != null && this.targetRoot.getPanel() != null && this.isRegionAllowed(DockingRegion.NORTH));
        this.rootEast.setVisible(this.targetRoot != null && this.targetRoot.getPanel() != null && this.isRegionAllowed(DockingRegion.EAST));
        this.rootSouth.setVisible(this.targetRoot != null && this.targetRoot.getPanel() != null && this.isRegionAllowed(DockingRegion.SOUTH));
        this.pinWest.setVisible(this.targetRoot != null && this.isPinningRegionAllowed(DockingRegion.WEST));
        this.pinEast.setVisible(this.targetRoot != null && this.isPinningRegionAllowed(DockingRegion.EAST));
        this.pinSouth.setVisible(this.targetRoot != null && this.isPinningRegionAllowed(DockingRegion.SOUTH));
        if (this.targetRoot != null) {
            Point location = this.targetRoot.getLocation();
            Dimension size = this.targetRoot.getSize();
            location.x += size.width / 2;
            location.y += size.height / 2;
            SwingUtilities.convertPointToScreen(location, this.targetRoot.getParent());
            SwingUtilities.convertPointFromScreen(location, this.utilFrame);
            this.setLocation(this.rootCenter, location.x, location.y);
            this.setLocation(this.rootWest, location.x - size.width / 2 + this.rootHandleSpacing(this.rootWest), location.y);
            this.setLocation(this.rootNorth, location.x, location.y - size.height / 2 + this.rootHandleSpacing(this.rootNorth));
            this.setLocation(this.rootEast, location.x + size.width / 2 - this.rootHandleSpacing(this.rootEast), location.y);
            this.setLocation(this.rootSouth, location.x, location.y + size.height / 2 - this.rootHandleSpacing(this.rootSouth));
            this.setLocation(this.pinWest, location.x - size.width / 2 + this.rootHandleSpacing(this.pinWest), location.y - size.height / 3);
            this.setLocation(this.pinEast, location.x + size.width / 2 - this.rootHandleSpacing(this.pinEast), location.y - size.height / 3);
            this.setLocation(this.pinSouth, location.x - size.width / 3, location.y + size.height / 2 - this.rootHandleSpacing(this.pinSouth));
        }
    }

    private int handleSpacing(JLabel handle) {
        return handle.getWidth() + 8;
    }

    private int rootHandleSpacing(JLabel handle) {
        return handle.getWidth() + 16;
    }

    public void setTarget(Dockable dockable) {
        if (dockable == this.targetDockable) {
            return;
        }
        this.targetDockable = dockable;
        this.dockableCenter.setVisible(false);
        this.dockableWest.setVisible(false);
        this.dockableNorth.setVisible(false);
        this.dockableEast.setVisible(false);
        this.dockableSouth.setVisible(false);
    }

    private boolean isRegionAllowed(DockingRegion region) {
        if (this.floating instanceof DockedSimplePanel) {
            DockedSimplePanel panel = (DockedSimplePanel)this.floating;
            Dockable floating = panel.getWrapper().getDockable();
            if (floating.getStyle() == DockableStyle.BOTH) {
                return true;
            }
            if (region == DockingRegion.NORTH || region == DockingRegion.SOUTH) {
                return floating.getStyle() == DockableStyle.HORIZONTAL;
            }
            return floating.getStyle() == DockableStyle.VERTICAL;
        }
        return true;
    }

    private boolean isPinningRegionAllowed(DockingRegion region) {
        if (this.floating instanceof DockedTabbedPanel) {
            return false;
        }
        Dockable floating = ((DisplayPanel)this.floating).getWrapper().getDockable();
        if (!floating.isPinningAllowed()) {
            return false;
        }
        if (floating.getPinningStyle() == DockableStyle.BOTH) {
            return true;
        }
        if (region == DockingRegion.NORTH || region == DockingRegion.SOUTH) {
            return floating.getPinningStyle() == DockableStyle.HORIZONTAL;
        }
        return floating.getPinningStyle() == DockableStyle.VERTICAL;
    }

    public boolean isMouseOverHandle() {
        Point mousePos = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(mousePos, this.dockableCenter.getParent());
        Rectangle northSouth = new Rectangle(this.dockableNorth.getX(), this.dockableNorth.getY(), this.dockableNorth.getWidth(), this.dockableNorth.getHeight() * 2 + this.handleSpacing(this.dockableNorth) * 2);
        Rectangle westEast = new Rectangle(this.dockableWest.getX(), this.dockableWest.getY(), this.dockableWest.getWidth() * 2 + this.handleSpacing(this.dockableWest) * 2, this.dockableWest.getHeight());
        return northSouth.contains(mousePos) || westEast.contains(mousePos);
    }

    private void setDockableHandleLocations() {
        this.dockableCenter.setVisible(this.targetDockable != null);
        this.dockableWest.setVisible(this.targetDockable != null && this.isRegionAllowed(DockingRegion.WEST));
        this.dockableNorth.setVisible(this.targetDockable != null && this.isRegionAllowed(DockingRegion.NORTH));
        this.dockableEast.setVisible(this.targetDockable != null && this.isRegionAllowed(DockingRegion.EAST));
        this.dockableSouth.setVisible(this.targetDockable != null && this.isRegionAllowed(DockingRegion.SOUTH));
        if (this.targetDockable != null && ((Component)((Object)this.targetDockable)).getParent() != null) {
            Point location = ((Component)((Object)this.targetDockable)).getLocation();
            Dimension size = ((Component)((Object)this.targetDockable)).getSize();
            if (this.targetDockable.isWrappableInScrollpane()) {
                Container parent;
                for (parent = ((Component)((Object)this.targetDockable)).getParent(); parent != null && !(parent instanceof JScrollPane); parent = parent.getParent()) {
                }
                if (parent != null) {
                    JScrollPane display = (JScrollPane)parent;
                    location = display.getLocation();
                    size = display.getSize();
                }
            }
            location.x += size.width / 2;
            location.y += size.height / 2;
            location.y -= 28;
            SwingUtilities.convertPointToScreen(location, ((Component)((Object)this.targetDockable)).getParent());
            SwingUtilities.convertPointFromScreen(location, this.utilFrame);
            this.setLocation(this.dockableCenter, location.x, location.y);
            this.setLocation(this.dockableWest, location.x - this.handleSpacing(this.dockableWest), location.y);
            this.setLocation(this.dockableNorth, location.x, location.y - this.handleSpacing(this.dockableNorth));
            this.setLocation(this.dockableEast, location.x + this.handleSpacing(this.dockableEast), location.y);
            this.setLocation(this.dockableSouth, location.x, location.y + this.handleSpacing(this.dockableSouth));
        }
    }

    public void update(Point screenPos) {
        this.setRootHandleLocations();
        this.setDockableHandleLocations();
        Point framePoint = new Point(screenPos);
        SwingUtilities.convertPointFromScreen(framePoint, this.utilFrame);
        this.rootRegion = null;
        this.dockableRegion = null;
        this.pinRegion = null;
        for (DockingHandle handle : this.mouseOver.keySet()) {
            boolean over = handle.isVisible() && handle.getBounds().contains(framePoint);
            this.mouseOver.put(handle, over);
            if (!over) continue;
            if (handle.isRoot()) {
                this.rootRegion = handle.getRegion();
                continue;
            }
            if (handle.isPin()) {
                switch (handle.getRegion()) {
                    case WEST: {
                        this.pinRegion = ToolbarLocation.WEST;
                        break;
                    }
                    case EAST: {
                        this.pinRegion = ToolbarLocation.EAST;
                        break;
                    }
                    case SOUTH: {
                        this.pinRegion = ToolbarLocation.SOUTH;
                    }
                }
                continue;
            }
            this.dockableRegion = handle.getRegion();
        }
        this.utilFrame.revalidate();
        this.utilFrame.repaint();
    }

    private void setLocation(Component component, int x, int y) {
        component.setLocation(x - 16, y - 16);
    }

    public void paint(Graphics g) {
        int centerX = this.dockableCenter.getX() + this.dockableCenter.getWidth() / 2;
        int centerY = this.dockableCenter.getY() + this.dockableCenter.getWidth() / 2;
        int spacing = this.handleSpacing(this.dockableCenter) - this.dockableCenter.getWidth();
        int half_icon = this.dockableCenter.getWidth() / 2;
        int one_and_a_half_icons = (int)((double)this.dockableCenter.getWidth() * 1.5);
        Polygon poly = new Polygon(new int[]{centerX - half_icon - spacing, centerX + half_icon + spacing, centerX + half_icon + spacing, centerX + half_icon + spacing * 2, centerX + one_and_a_half_icons + spacing * 2, centerX + one_and_a_half_icons + spacing * 2, centerX + half_icon + spacing * 2, centerX + half_icon + spacing, centerX + half_icon + spacing, centerX - half_icon - spacing, centerX - half_icon - spacing, centerX - half_icon - spacing * 2, centerX - one_and_a_half_icons - spacing * 2, centerX - one_and_a_half_icons - spacing * 2, centerX - half_icon - spacing * 2, centerX - half_icon - spacing, centerX - half_icon - spacing}, new int[]{centerY - one_and_a_half_icons - spacing * 2, centerY - one_and_a_half_icons - spacing * 2, centerY - half_icon - spacing * 2, centerY - half_icon - spacing, centerY - half_icon - spacing, centerY + half_icon + spacing, centerY + half_icon + spacing, centerY + half_icon + spacing * 2, centerY + one_and_a_half_icons + spacing * 2, centerY + one_and_a_half_icons + spacing * 2, centerY + half_icon + spacing * 2, centerY + half_icon + spacing, centerY + half_icon + spacing, centerY - half_icon - spacing, centerY - half_icon - spacing, centerY - half_icon - spacing * 2, centerY - one_and_a_half_icons - spacing * 2}, 17);
        Color background = DockingSettings.getHandleBackground();
        Color border = DockingSettings.getHandleForeground();
        Graphics2D g2 = (Graphics2D)g.create();
        BasicStroke dashed = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f}, 0.0f);
        g2.setStroke(dashed);
        this.paintHandle(g, g2, this.rootCenter);
        this.paintHandle(g, g2, this.rootEast);
        this.paintHandle(g, g2, this.rootWest);
        this.paintHandle(g, g2, this.rootNorth);
        this.paintHandle(g, g2, this.rootSouth);
        this.paintHandle(g, g2, this.pinWest);
        this.paintHandle(g, g2, this.pinEast);
        this.paintHandle(g, g2, this.pinSouth);
        if (this.targetDockable != null) {
            g.setColor(background);
            g.fillPolygon(poly.xpoints, poly.ypoints, poly.npoints);
            g.setColor(border);
            g.drawPolygon(poly.xpoints, poly.ypoints, poly.npoints);
        }
        this.paintHandle(g, g2, this.dockableCenter);
        this.paintHandle(g, g2, this.dockableEast);
        this.paintHandle(g, g2, this.dockableWest);
        this.paintHandle(g, g2, this.dockableNorth);
        this.paintHandle(g, g2, this.dockableSouth);
        g2.dispose();
    }

    private void paintHandle(Graphics g, Graphics2D g2, DockingHandle handle) {
        if (handle.isVisible()) {
            handle.paintHandle(g, g2, this.mouseOver.get(handle));
        }
    }
}

