/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.floating;

import ModernDocking.internal.DockableWrapper;
import ModernDocking.settings.Settings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TempFloatingFrame
extends JFrame {
    private static final int BORDER_SIZE = 2;
    private final List<DockableWrapper> dockables;
    private final int selectedIndex;

    public TempFloatingFrame(DockableWrapper dockable, JComponent dragSrc, Dimension size) {
        this.dockables = Collections.emptyList();
        this.selectedIndex = 0;
        this.build(dockable.getDisplayPanel(), dragSrc, size);
    }

    public TempFloatingFrame(List<DockableWrapper> dockables, int selectedIndex, JComponent dragSrc, Dimension size) {
        this.dockables = dockables;
        this.selectedIndex = selectedIndex;
        JTabbedPane tabs = new JTabbedPane();
        boolean usingFlatLaf = tabs.getUI().getClass().getPackageName().startsWith("com.formdev.flatlaf");
        if (Settings.alwaysDisplayTabsMode(dockables.get(0).getDockable()) && usingFlatLaf) {
            tabs.setTabPlacement(1);
        } else {
            tabs.setTabPlacement(3);
        }
        for (DockableWrapper dockable : dockables) {
            tabs.add(dockable.getDockable().getTabText(), dockable.getDisplayPanel());
        }
        tabs.setSelectedIndex(selectedIndex);
        this.build(tabs, dragSrc, size);
    }

    private void build(JComponent dockable, JComponent dragSrc, Dimension size) {
        this.setLayout(new BorderLayout());
        this.setUndecorated(true);
        this.setType(Window.Type.UTILITY);
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.setSize(size);
        Point newPoint = new Point(dragSrc.getLocation());
        if (dragSrc.getParent() != null) {
            SwingUtilities.convertPointToScreen(newPoint, dragSrc.getParent());
        }
        this.setLocation(newPoint);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        Color color = UIManager.getColor("Component.focusColor");
        panel.setBorder(BorderFactory.createLineBorder(color, 2));
        panel.add((Component)dockable, gbc);
        this.add((Component)panel, "Center");
        this.setVisible(true);
    }

    public List<DockableWrapper> getDockables() {
        return this.dockables;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }
}

