/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.DockingProperty;
import ModernDocking.internal.DockableWrapper;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DockableProperties {
    public static void configureProperties(DockableWrapper wrapper, Map<String, String> properties) {
        Dockable dockable = wrapper.getDockable();
        for (String key : wrapper.getProperties().keySet()) {
            wrapper.removeProperty(key);
        }
        for (String key : properties.keySet()) {
            wrapper.setProperty(key, properties.get(key));
        }
        List dockingPropFields = Arrays.stream(dockable.getClass().getDeclaredFields()).filter(field -> field.getAnnotation(DockingProperty.class) != null).collect(Collectors.toList());
        for (Field field2 : dockingPropFields) {
            try {
                DockingProperty property;
                if (!field2.canAccess(dockable)) {
                    field2.setAccessible(true);
                }
                if (properties.containsKey((property = field2.getAnnotation(DockingProperty.class)).name())) {
                    DockableProperties.setProperty(dockable, field2, properties.get(property.name()));
                    wrapper.removeProperty(property.name());
                    continue;
                }
                if (Objects.equals(property.defaultValue(), "__no_default_value__")) continue;
                DockableProperties.setProperty(dockable, field2, property.defaultValue());
                wrapper.removeProperty(property.name());
            }
            catch (IllegalAccessException | SecurityException e) {
                e.printStackTrace();
            }
        }
        dockable.updateProperties();
    }

    public static Map<String, String> saveProperties(DockableWrapper wrapper) {
        Dockable dockable = wrapper.getDockable();
        HashMap<String, String> properties = new HashMap<String, String>(wrapper.getProperties());
        List dockingPropFields = Arrays.stream(dockable.getClass().getDeclaredFields()).filter(field -> field.getAnnotation(DockingProperty.class) != null).collect(Collectors.toList());
        for (Field field2 : dockingPropFields) {
            try {
                field2.setAccessible(true);
                DockingProperty property = field2.getAnnotation(DockingProperty.class);
                properties.put(property.name(), DockableProperties.getProperty(wrapper, field2));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return properties;
    }

    private static String getProperty(DockableWrapper wrapper, Field field) throws IllegalAccessException {
        Dockable dockable = wrapper.getDockable();
        Class<?> type = field.getType();
        if (type == Byte.TYPE) {
            return Byte.toString((Byte)field.get(dockable));
        }
        if (type == Short.TYPE) {
            return Short.toString((Short)field.get(dockable));
        }
        if (type == Integer.TYPE) {
            return Integer.toString((Integer)field.get(dockable));
        }
        if (type == Long.TYPE) {
            return Long.toString((Long)field.get(dockable));
        }
        if (type == Float.TYPE) {
            return Float.toString(((Float)field.get(dockable)).floatValue());
        }
        if (type == Double.TYPE) {
            return Double.toString((Double)field.get(dockable));
        }
        if (type == Character.TYPE) {
            return Character.toString(((Character)field.get(dockable)).charValue());
        }
        if (type == Boolean.TYPE) {
            return Boolean.toString((Boolean)field.get(dockable));
        }
        if (type == String.class) {
            return (String)field.get(dockable);
        }
        throw new RuntimeException("Unsupported property type");
    }

    private static void setProperty(Dockable dockable, Field field, String value) throws IllegalAccessException {
        Class<?> type = field.getType();
        if (type == Byte.TYPE) {
            field.set(dockable, Byte.parseByte(value));
        } else if (type == Short.TYPE) {
            field.set(dockable, Short.parseShort(value));
        } else if (type == Integer.TYPE) {
            field.set(dockable, Integer.parseInt(value));
        } else if (type == Long.TYPE) {
            field.set(dockable, Long.parseLong(value));
        } else if (type == Float.TYPE) {
            field.set(dockable, Float.valueOf(Float.parseFloat(value)));
        } else if (type == Double.TYPE) {
            field.set(dockable, Double.parseDouble(value));
        } else if (type == Character.TYPE) {
            field.set(dockable, Character.valueOf(value.charAt(0)));
        } else if (type == Boolean.TYPE) {
            field.set(dockable, Boolean.parseBoolean(value));
        } else if (type == String.class) {
            field.set(dockable, value);
        } else {
            throw new RuntimeException("Unsupported property type");
        }
    }
}

