/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.floating.FloatListener;
import ModernDocking.internal.DisplayPanel;
import ModernDocking.internal.DockingPanel;
import ModernDocking.ui.DockingHeaderUI;
import ModernDocking.ui.HeaderController;
import ModernDocking.ui.HeaderModel;
import java.awt.Window;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DockableWrapper {
    private final HeaderController headerController;
    private Window window;
    private DockingPanel parent = null;
    private final Dockable dockable;
    private final DockingAPI docking;
    private final DockingHeaderUI headerUI;
    private final DisplayPanel displayPanel;
    private final FloatListener floatListener;
    private boolean maximized = false;
    private boolean unpinned = false;
    private RootDockingPanelAPI root;
    private final Map<String, String> properties = new HashMap<String, String>();

    public DockableWrapper(DockingAPI docking, Dockable dockable) {
        this.docking = docking;
        this.dockable = dockable;
        HeaderModel headerModel = new HeaderModel(dockable, docking);
        this.headerController = new HeaderController(dockable, docking, headerModel);
        this.headerUI = dockable.createHeaderUI(this.headerController, headerModel);
        this.headerController.setUI(this.headerUI);
        this.displayPanel = new DisplayPanel(this);
        this.floatListener = new FloatListener(docking, this.displayPanel);
    }

    public Window getWindow() {
        return this.window;
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    public void setParent(DockingPanel parent) {
        this.parent = parent;
        this.displayPanel.parentChanged();
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public void removeListeners() {
        this.headerController.removeListeners();
        this.floatListener.removeListeners();
    }

    public DockingPanel getParent() {
        return this.parent;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMaximized(boolean maximized) {
        this.maximized = maximized;
    }

    public boolean isUnpinned() {
        return this.unpinned;
    }

    public void setUnpinned(boolean unpinned) {
        this.unpinned = unpinned;
        this.displayPanel.parentChanged();
    }

    public DockingHeaderUI getHeaderUI() {
        return this.headerUI;
    }

    public DisplayPanel getDisplayPanel() {
        return this.displayPanel;
    }

    public void setRoot(RootDockingPanelAPI root) {
        this.root = root;
    }

    public RootDockingPanelAPI getRoot() {
        return this.root;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void setProperty(String propertyName, String value) {
        this.properties.put(propertyName, value);
    }

    public void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
    }
}

