/*
 * Decompiled with CFR 0.152.
 */
package ModernDocking.internal;

import ModernDocking.Dockable;
import ModernDocking.api.DockingAPI;
import ModernDocking.api.RootDockingPanelAPI;
import ModernDocking.exception.DockableRegistrationFailureException;
import ModernDocking.internal.ActiveDockableHighlighter;
import ModernDocking.internal.DockableWrapper;
import ModernDocking.internal.DockedSimplePanel;
import ModernDocking.internal.DockedSplitPanel;
import ModernDocking.internal.DockedTabbedPanel;
import ModernDocking.internal.DockingListeners;
import ModernDocking.internal.DockingPanel;
import ModernDocking.ui.DefaultHeaderUI;
import ModernDocking.ui.DockingHeaderUI;
import ModernDocking.ui.HeaderController;
import ModernDocking.ui.HeaderModel;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;

public class DockingInternal {
    private final Map<String, DockableWrapper> dockables = new HashMap<String, DockableWrapper>();
    private final DockingAPI docking;
    private static final Map<DockingAPI, DockingInternal> internals = new HashMap<DockingAPI, DockingInternal>();
    public static BiFunction<HeaderController, HeaderModel, DockingHeaderUI> createHeaderUI = DefaultHeaderUI::new;

    public DockingInternal(DockingAPI docking) {
        this.docking = docking;
        internals.put(docking, this);
    }

    public static DockingInternal get(DockingAPI docking) {
        return internals.get(docking);
    }

    public static void remove(DockingAPI docking) {
        internals.remove(docking);
    }

    public List<Dockable> getDockables() {
        return this.dockables.values().stream().map(DockableWrapper::getDockable).collect(Collectors.toList());
    }

    public void registerDockable(Dockable dockable) {
        if (this.dockables.containsKey(dockable.getPersistentID())) {
            throw new DockableRegistrationFailureException("Registration for Dockable failed. Persistent ID " + dockable.getPersistentID() + " already exists.");
        }
        if (dockable.getTabText() == null) {
            throw new RuntimeException("Dockable '" + dockable.getPersistentID() + "' should not return 'null' for tabText()");
        }
        this.dockables.put(dockable.getPersistentID(), new DockableWrapper(this.docking, dockable));
    }

    public void deregisterDockable(Dockable dockable) {
        this.getWrapper(dockable).removeListeners();
        this.dockables.remove(dockable.getPersistentID());
    }

    public DockableWrapper getWrapper(Dockable dockable) {
        if (this.dockables.containsKey(dockable.getPersistentID())) {
            return this.dockables.get(dockable.getPersistentID());
        }
        throw new DockableRegistrationFailureException("Dockable with Persistent ID " + dockable.getPersistentID() + " has not been registered.");
    }

    public Dockable getDockable(String persistentID) {
        if (this.dockables.containsKey(persistentID)) {
            return this.dockables.get(persistentID).getDockable();
        }
        throw new DockableRegistrationFailureException("Dockable with Persistent ID " + persistentID + " has not been registered.");
    }

    public void fireDockedEventForFrame(Window window) {
        List wrappers = this.dockables.values().stream().filter(wrapper -> wrapper.getWindow() == window).collect(Collectors.toList());
        for (DockableWrapper wrapper2 : wrappers) {
            DockingListeners.fireDockedEvent(wrapper2.getDockable());
        }
    }

    public static void fireDockedEventForAll(DockingAPI docking) {
        for (Dockable dockable : DockingInternal.get(docking).getDockables()) {
            if (!docking.isDocked(dockable)) continue;
            DockingListeners.fireDockedEvent(dockable);
        }
    }

    public void updateLAF() {
        for (DockableWrapper wrapper : this.dockables.values()) {
            SwingUtilities.updateComponentTreeUI(wrapper.getDisplayPanel());
        }
        for (RootDockingPanelAPI root : this.docking.getRootPanels().values()) {
            root.updateLAF();
            this.updateLAF(root.getPanel());
        }
    }

    private void updateLAF(DockingPanel panel) {
        if (panel instanceof DockedTabbedPanel) {
            ActiveDockableHighlighter.setNotSelectedBorder(panel);
        } else if (panel instanceof DockedSimplePanel) {
            DockedSimplePanel simplePanel = (DockedSimplePanel)panel;
            if (simplePanel.getParent() instanceof DockedTabbedPanel) {
                DockedTabbedPanel tabbedPanel = (DockedTabbedPanel)simplePanel.getParent();
                if (tabbedPanel.getDockables().size() == 1) {
                    ActiveDockableHighlighter.setNotSelectedBorder(panel);
                }
            } else {
                ActiveDockableHighlighter.setNotSelectedBorder(panel);
            }
        } else if (panel instanceof DockedSplitPanel) {
            DockedSplitPanel splitPanel = (DockedSplitPanel)panel;
            this.updateLAF(splitPanel.getLeft());
            this.updateLAF(splitPanel.getRight());
        }
    }

    public static DockingHeaderUI createDefaultHeaderUI(HeaderController headerController, HeaderModel headerModel) {
        return createHeaderUI.apply(headerController, headerModel);
    }
}

